/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.command;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonPart;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.xiaoyu.suixingxiugai.data.PlayerHealthData;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class DragonResurrectionCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"iceandfire").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dragonresurrection").requires(source -> source.m_6761_(0))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"healthCost", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> DragonResurrectionCommand.execute((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"healthCost")))))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, Collection<? extends Entity> targets, int healthCost) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        int successCount = 0;
        for (Entity entity : targets) {
            String dragonName;
            EntityDragonBase dragon = DragonResurrectionCommand.getDragonFromEntity(entity);
            if (dragon == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.iceandfire.dragonresurrection.not_dragon"));
                continue;
            }
            if (!dragon.isModelDead()) {
                dragonName = DragonResurrectionCommand.getDragonTypeName(dragon);
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.iceandfire.dragonresurrection.not_dead", (Object[])new Object[]{dragonName}));
                continue;
            }
            if (!dragon.m_21830_((LivingEntity)player)) {
                dragonName = DragonResurrectionCommand.getDragonTypeName(dragon);
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.iceandfire.dragonresurrection.not_owner", (Object[])new Object[]{dragonName}));
                continue;
            }
            if (player.m_21233_() <= (float)healthCost) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.iceandfire.dragonresurrection.insufficient_health"));
                continue;
            }
            dragonName = DragonResurrectionCommand.getDragonTypeName(dragon);
            DragonResurrectionCommand.transferHealthToDragon((Player)player, dragon, healthCost);
            ++successCount;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> DragonResurrectionCommand.lambda$execute$2((Player)player, healthCost, dragonName), true);
        }
        return successCount;
    }

    private static EntityDragonBase getDragonFromEntity(Entity entity) {
        EntityDragonPart dragonPart;
        Entity parent;
        if (entity instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)entity;
            return dragon;
        }
        if (entity instanceof EntityDragonPart && (parent = (dragonPart = (EntityDragonPart)entity).getParent()) instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)parent;
            return dragon;
        }
        return null;
    }

    private static String getDragonTypeName(EntityDragonBase dragon) {
        if (dragon.m_8077_()) {
            return dragon.m_7770_().getString();
        }
        String entityType = dragon.m_6095_().toString();
        if (entityType.contains("fire_dragon")) {
            return Component.m_237115_((String)"entity.iceandfire.fire_dragon").getString();
        }
        if (entityType.contains("ice_dragon")) {
            return Component.m_237115_((String)"entity.iceandfire.ice_dragon").getString();
        }
        if (entityType.contains("lightning_dragon")) {
            return Component.m_237115_((String)"entity.iceandfire.lightning_dragon").getString();
        }
        return Component.m_237115_((String)"entity.iceandfire.dragon_multipart").getString();
    }

    private static void transferHealthToDragon(Player player, EntityDragonBase dragon, int healthToTransfer) {
        float newDragonHealth = Math.min(dragon.m_21233_(), (float)healthToTransfer);
        dragon.m_21153_(newDragonHealth);
        dragon.setModelDead(false);
        DragonResurrectionCommand.reducePlayerMaxHealth(player, healthToTransfer);
    }

    private static void reducePlayerMaxHealth(Player player, int healthToReduce) {
        AttributeInstance maxHealthAttribute = player.m_21051_(Attributes.f_22276_);
        if (maxHealthAttribute != null) {
            double newBaseValue = maxHealthAttribute.m_22115_() - (double)healthToReduce;
            maxHealthAttribute.m_22100_(newBaseValue);
            PlayerHealthData.savePlayerHealthData(player, player.getPersistentData());
            if (player.m_21223_() > player.m_21233_()) {
                player.m_21153_(player.m_21233_());
            }
        }
    }

    private static /* synthetic */ Component lambda$execute$2(Player player, int healthCost, String dragonName) {
        return Component.m_237110_((String)"commands.iceandfire.dragonresurrection.success", (Object[])new Object[]{player.m_7755_().getString(), String.valueOf(healthCost), dragonName});
    }
}

