/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.iceandfire.item;

import com.github.alexthe666.iceandfire.entity.props.EntityDataProvider;
import com.github.alexthe666.iceandfire.item.ItemDeathwormGauntlet;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.xiaoyu.suixingxiugai.config.iceandfire.item.DeathwormGauntletConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ItemDeathwormGauntlet.class})
public abstract class ItemDeathwormGauntletMixin {
    @Shadow
    private boolean deathwormReceded;
    @Shadow
    private boolean deathwormLaunched;
    @Shadow
    private int specialDamage;

    @Overwrite
    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!this.deathwormReceded && !this.deathwormLaunched && entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128451_("HolderID") != player.m_19879_()) {
                tag.m_128405_("HolderID", player.m_19879_());
            }
            if (player.m_36335_().m_41521_(stack.m_41720_(), 0.0f) == 0.0f) {
                player.m_36335_().m_41524_(stack.m_41720_(), ((Integer)DeathwormGauntletConfig.deathwormGauntletCooldown.get()).intValue());
                player.m_5496_(IafSoundRegistry.DEATHWORM_ATTACK, 1.0f, 1.0f);
                this.deathwormReceded = false;
                this.deathwormLaunched = true;
            }
        }
    }

    @Overwrite
    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entity, int timeLeft) {
        CompoundTag tag;
        if (this.specialDamage > 0) {
            stack.m_41622_(this.specialDamage, entity, player -> player.m_21190_(entity.m_7655_()));
            this.specialDamage = 0;
        }
        if ((tag = stack.m_41784_()).m_128451_("HolderID") != -1) {
            tag.m_128405_("HolderID", -1);
        }
    }

    @Overwrite
    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        EntityDataProvider.getCapability((Entity)entity).ifPresent(data -> {
            Player player;
            int tempLungeTicks = data.miscData.lungeTicks;
            if (this.deathwormReceded) {
                if (tempLungeTicks > 0) {
                    tempLungeTicks -= 4;
                }
                if (tempLungeTicks <= 0) {
                    tempLungeTicks = 0;
                    this.deathwormReceded = false;
                    this.deathwormLaunched = false;
                }
            } else if (this.deathwormLaunched && (tempLungeTicks = 4 + tempLungeTicks) > 20) {
                tempLungeTicks = 20;
                this.deathwormReceded = true;
            }
            if (data.miscData.lungeTicks == 20 && entity instanceof Player && !(player = (Player)entity).m_36335_().m_41519_(stack.m_41720_())) {
                Vec3 vector3d = player.m_20252_(1.0f).m_82541_();
                double range = (Double)DeathwormGauntletConfig.deathwormGauntletRange.get();
                for (LivingEntity livingEntity : world.m_45976_(LivingEntity.class, new AABB(player.m_20185_() - range, player.m_20186_() - range, player.m_20189_() - range, player.m_20185_() + range, player.m_20186_() + range, player.m_20189_() + range))) {
                    if (livingEntity == entity) continue;
                    Vec3 vector3d1 = new Vec3(livingEntity.m_20185_() - player.m_20185_(), livingEntity.m_20186_() - player.m_20186_(), livingEntity.m_20189_() - player.m_20189_());
                    double d0 = vector3d1.m_82553_();
                    double d1 = vector3d.m_82526_(vector3d1 = vector3d1.m_82541_());
                    boolean canSee = d1 > 1.0 - 0.5 / d0 && player.m_142582_((Entity)livingEntity);
                    if (!canSee) continue;
                    ++this.specialDamage;
                    livingEntity.m_6469_(entity.m_9236_().m_269111_().m_269075_((Player)entity), ((Double)DeathwormGauntletConfig.deathwormGauntletDamage.get()).floatValue());
                    player.m_36335_().m_41524_(stack.m_41720_(), ((Integer)DeathwormGauntletConfig.deathwormGauntletCooldown.get()).intValue());
                    double pullForce = (Double)DeathwormGauntletConfig.deathwormGauntletPullForce.get();
                    if (((Boolean)DeathwormGauntletConfig.deathwormGauntletKnockbackResistanceReduction.get()).booleanValue()) {
                        pullForce *= 1.0 - Math.min(1.0, livingEntity.m_21133_(Attributes.f_22278_));
                    }
                    livingEntity.m_5997_((player.m_20185_() - livingEntity.m_20185_()) * pullForce, (player.m_20186_() - livingEntity.m_20186_()) * pullForce, (player.m_20189_() - livingEntity.m_20189_()) * pullForce);
                }
            }
            data.miscData.setLungeTicks(tempLungeTicks);
        });
    }
}

