/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.twilightforest.entity.boss;

import com.xiaoyu.suixingxiugai.config.twilightforest.entity.NagaConfig;
import com.xiaoyu.suixingxiugai.util.twilightforest.entity.NagaPhysicsUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import twilightforest.entity.boss.Naga;
import twilightforest.entity.boss.NagaSegment;

@Mixin(value={NagaSegment.class})
public class NagaSegmentMixin {
    @Redirect(method={"collideWithEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean redirectNagaSegmentAttackDamage(Entity instance, DamageSource damageSource, float originalDamage) {
        NagaSegment segment = (NagaSegment)this;
        Naga naga = (Naga)segment.getParent();
        double segmentAttackDamage = (Double)NagaConfig.nagaSegmentAttackDamage.get();
        if (naga.m_9236_().m_46791_() != Difficulty.EASY && naga.m_21051_(Attributes.f_22281_) != null) {
            boolean hard = naga.m_9236_().m_46791_() == Difficulty.HARD;
            double difficultyBoost = hard ? (Double)NagaConfig.nagaDifficultySegmentAttackDamageBoostHard.get() : (Double)NagaConfig.nagaDifficultySegmentAttackDamageBoostNormal.get();
            segmentAttackDamage += difficultyBoost;
        }
        if (instance instanceof Animal) {
            segmentAttackDamage *= ((Double)NagaConfig.nagaSegmentAttackDamageMultiplierAgainstAnimals.get()).doubleValue();
        }
        return instance.m_6469_(damageSource, (float)segmentAttackDamage);
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Ltwilightforest/entity/boss/Naga;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean redirectNagaHurtCall(Naga instance, DamageSource src, float damage) {
        float damageTransferRatio = (float)((Double)NagaConfig.nagaSegmentDamageTransferRatio.get()).doubleValue();
        return instance.m_6469_(src, damage * damageTransferRatio);
    }

    @Redirect(method={"collideWithEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;push(Lnet/minecraft/world/entity/Entity;)V"))
    private void redirectNagaSegmentPush(Entity instance, Entity entity) {
        NagaSegment segment = (NagaSegment)this;
        Naga naga = (Naga)segment.getParent();
        NagaPhysicsUtil.applySegmentPushAndRecoilForces(naga, instance);
    }
}

