/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.util.twilightforest.entity;

import com.xiaoyu.suixingxiugai.config.twilightforest.entity.NagaConfig;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import twilightforest.entity.boss.Naga;

public class NagaPhysicsUtil {
    public static void applyHeadPushAndRecoilForces(Naga naga, Entity target) {
        NagaPhysicsUtil.applyPushAndRecoilForces(naga, target, (Double)NagaConfig.nagaHeadChargePushForce.get(), (Double)NagaConfig.nagaHeadChargeRecoilForce.get());
    }

    public static void applySegmentPushAndRecoilForces(Naga naga, Entity target) {
        NagaPhysicsUtil.applyPushAndRecoilForces(naga, target, (Double)NagaConfig.nagaSegmentChargePushForce.get(), (Double)NagaConfig.nagaSegmentChargeRecoilForce.get());
    }

    private static void applyPushAndRecoilForces(Naga naga, Entity target, double pushForce, double recoilForce) {
        float yRot = naga.m_146908_();
        double pushX = (double)(-Mth.m_14031_((float)(yRot * (float)Math.PI / 180.0f))) * pushForce;
        double pushY = (double)0.4f * pushForce;
        double pushZ = (double)Mth.m_14089_((float)(yRot * (float)Math.PI / 180.0f)) * pushForce;
        target.m_5997_(pushX, pushY, pushZ);
        double recoilX = (double)(-Mth.m_14031_((float)(yRot * (float)Math.PI / 180.0f))) * recoilForce;
        double recoilY = (double)0.4f * recoilForce;
        double recoilZ = (double)Mth.m_14089_((float)(yRot * (float)Math.PI / 180.0f)) * recoilForce;
        naga.m_5997_(recoilX, recoilY, recoilZ);
    }

    public static boolean isEntityWithinNagaCourtyard(Naga naga, Entity entity) {
        if (!naga.isRestrictionPointValid(naga.m_9236_().m_46472_())) {
            return true;
        }
        double distX = Math.abs(naga.getRestrictionPoint().m_122646_().m_123341_() - entity.m_20183_().m_123341_());
        double distY = Math.abs(naga.getRestrictionPoint().m_122646_().m_123342_() - entity.m_20183_().m_123342_());
        double distZ = Math.abs(naga.getRestrictionPoint().m_122646_().m_123343_() - entity.m_20183_().m_123343_());
        return distX <= (double)((Integer)NagaConfig.nagaCourtyardBoundX.get()).intValue() && distY <= (double)((Integer)NagaConfig.nagaCourtyardBoundY.get()).intValue() && distZ <= (double)((Integer)NagaConfig.nagaCourtyardBoundZ.get()).intValue();
    }
}

