/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.volume;

import com.github.natanbc.lavadsp.util.FloatToFloatFunction;
import com.github.natanbc.lavadsp.util.VectorSupport;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public class VolumePcmAudioFilter
implements FloatPcmAudioFilter {
    private final FloatPcmAudioFilter downstream;
    private float volume = 1.0f;

    public VolumePcmAudioFilter(FloatPcmAudioFilter downstream) {
        this.downstream = downstream;
    }

    @Deprecated
    public VolumePcmAudioFilter(FloatPcmAudioFilter downstream, int channelCount, int bufferSize) {
        this(downstream);
    }

    @Deprecated
    public VolumePcmAudioFilter(FloatPcmAudioFilter downstream, int channelCount) {
        this(downstream);
    }

    public float getVolume() {
        return this.volume;
    }

    public VolumePcmAudioFilter setVolume(float volume) {
        if (volume < 0.0f) {
            throw new IllegalArgumentException("Volume < 0.0");
        }
        if (volume > 5.0f) {
            throw new IllegalArgumentException("Volume > 5.0");
        }
        this.volume = volume;
        return this;
    }

    public VolumePcmAudioFilter updateVolume(FloatToFloatFunction function) {
        return this.setVolume(function.apply(this.volume));
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        if (Math.abs(1.0 - (double)this.volume) < 0.02) {
            this.downstream.process(input, offset, length);
            return;
        }
        for (float[] array : input) {
            VectorSupport.volume(array, offset, length, this.volume);
        }
        this.downstream.process(input, offset, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

