/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader;

import com.github.natanbc.nativeloader.LibraryBinaryLoader;
import com.github.natanbc.nativeloader.NativeLibLoader;
import com.github.natanbc.nativeloader.Natives;
import com.github.natanbc.nativeloader.system.CPUInfo;

class DetectorLoader {
    private static volatile boolean loadedDetector;
    private static volatile CPUInfo cachedInfo;

    DetectorLoader() {
    }

    static CPUInfo loadDetector(LibraryBinaryLoader loader) {
        if (loadedDetector) {
            return cachedInfo;
        }
        return DetectorLoader.load0(loader);
    }

    private static synchronized CPUInfo load0(LibraryBinaryLoader loader) {
        CPUInfo info;
        if (loadedDetector) {
            return cachedInfo;
        }
        try {
            NativeLibLoader.create(loader, "detector").load();
        }
        catch (RuntimeException e) {
            try {
                NativeLibLoader.create("detector").load();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
                throw e;
            }
        }
        cachedInfo = info = Natives.createSystemInfo();
        loadedDetector = true;
        return info;
    }
}

