/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.jiosaavn;

import com.github.topi314.lavasearch.AudioSearchManager;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.jiosaavn.JioSaavnAudioPlaylist;
import com.github.topi314.lavasrc.jiosaavn.JioSaavnAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JioSaavnAudioSourceManager
extends ExtendedAudioSourceManager
implements HttpConfigurable,
AudioSearchManager {
    public static final Pattern URL_PATTERN = Pattern.compile("https://www\\.jiosaavn\\.com/(?<type>album|featured|song|s/playlist|artist)/[^/]+/(?<id>[A-Za-z0-9_,\\-]+)");
    public static final String SEARCH_PREFIX = "jssearch:";
    public static final String RECOMMENDATIONS_PREFIX = "jsrec:";
    public static final String PREVIEW_PREFIX = "jsprev:";
    public static final long PREVIEW_LENGTH = 30000L;
    public static final String MEDIA_API_BASE = "https://www.jiosaavn.com/api.php?__call=song.getDetails&cc=in&_marker=0%3F_marker%3D0&_format=json&pids=";
    public static final String SEARCH_API_BASE = "https://www.jiosaavn.com/api.php?__call=search.getResults&_format=json&_marker=0&cc=in&includeMetaTags=1&q=";
    public static final String METADATA_API_BASE = "https://www.jiosaavn.com/api.php?__call=webapi.get&api_version=4&_format=json&_marker=0&ctx=web6dot0&token=%s&type=%s";
    public static final String RECOS_STATION_API_BASE = "https://www.jiosaavn.com/api.php?__call=webradio.createEntityStation&api_version=4&_format=json&_marker=0&ctx=android&entity_id=%s&entity_type=queue";
    public static final String RECOS_API_BASE = "https://www.jiosaavn.com/api.php?__call=webradio.getSong&api_version=4&_format=json&_marker=0&ctx=android&stationid=%s&k=20";
    public static final String ARTIST_RECOS_API_BASE = "https://www.jiosaavn.com/api.php?__call=search.artistOtherTopSongs&api_version=4&_format=json&_marker=0&ctx=wap6dot0&artist_ids=%s&song_id=%s&language=unknown";
    private static final Logger log = LoggerFactory.getLogger(JioSaavnAudioSourceManager.class);
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();
    private final JioSaavnConfig config;

    public JioSaavnAudioSourceManager(@NotNull JioSaavnConfig config) {
        this.config = config;
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "jiosaavn";
    }

    private String buildSearchUrl(String query) {
        return SEARCH_API_BASE + URLEncoder.encode(query, StandardCharsets.UTF_8);
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new JioSaavnAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, extendedAudioTrackInfo.previewUrl, extendedAudioTrackInfo.isPreview, this);
    }

    @Override
    @Nullable
    public AudioSearchResult loadSearch(@NotNull String query, @NotNull Set<AudioSearchResult.Type> types) {
        return null;
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        boolean isPreview = reference.identifier.startsWith(PREVIEW_PREFIX);
        return this.loadItem(isPreview ? identifier.substring(PREVIEW_PREFIX.length()) : identifier, isPreview);
    }

    public AudioItem loadItem(String identifier, boolean preview) {
        try {
            if (identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(identifier.substring(SEARCH_PREFIX.length()), preview);
            }
            if (identifier.startsWith(RECOMMENDATIONS_PREFIX)) {
                return this.getRecommendations(identifier.substring(RECOMMENDATIONS_PREFIX.length()));
            }
            Matcher matcher = URL_PATTERN.matcher(identifier);
            if (!matcher.find()) {
                return null;
            }
            String type = matcher.group("type");
            String id = matcher.group("id");
            switch (type) {
                case "s/playlist": {
                    String playlistId = identifier.substring(identifier.lastIndexOf("/") + 1);
                    return this.getPlaylist(playlistId, preview);
                }
                case "album": {
                    return this.getAlbum(id, preview);
                }
                case "song": {
                    return this.getTrack(id, preview);
                }
                case "featured": {
                    return this.getPlaylist(id, preview);
                }
                case "artist": {
                    return this.getArtist(id, preview);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load audio item: " + e.getMessage(), e);
        }
    }

    public JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", "application/json");
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), request);
    }

    private List<AudioTrack> localParseTracks(JsonBrowser json2, boolean preview, boolean metadataType) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json2.values()) {
            tracks.add(this.parseTrack(track, preview, metadataType));
        }
        return tracks;
    }

    private String cleanString(String text) {
        return text != null ? text.replace("&quot;", "").replace("&amp;", "") : null;
    }

    private AudioTrack parseTrack(JsonBrowser json2, boolean preview, boolean metadataType) {
        String previewUrl;
        String albumUrl;
        String albumName;
        String artworkUrl;
        String author;
        String identifier = json2.get("id").text();
        String title = this.cleanString(metadataType ? json2.get("title").text() : json2.get("song").text());
        String artistArtworkUrl = null;
        String artistUrl = null;
        if (metadataType) {
            JsonBrowser moreInfoJson = json2.get("more_info");
            JsonBrowser artistMapJson = moreInfoJson.get("artistMap");
            List<JsonBrowser> primaryArtists = artistMapJson.get("primary_artists").values();
            if (primaryArtists.isEmpty()) {
                primaryArtists = artistMapJson.get("artists").values();
            }
            if (!primaryArtists.isEmpty()) {
                author = primaryArtists.stream().map(artist -> artist.get("name").text()).filter(name -> name != null && !name.isEmpty()).collect(Collectors.joining(", "));
                artistUrl = primaryArtists.get(0).get("perma_url").text();
                artistArtworkUrl = primaryArtists.get(0).get("image").text();
            } else {
                author = this.cleanString(json2.get("more_info").get("music").text());
            }
        } else {
            author = this.cleanString(json2.get("primary_artists").text());
            if (author.isEmpty()) {
                author = this.cleanString(json2.get("singers").text());
            }
        }
        String string = artworkUrl = json2.get("image").isNull() ? null : json2.get("image").text().replace("150x150", "500x500");
        long length = preview ? 30000L : (metadataType ? json2.get("more_info").get("duration").asLong(30000L) : json2.get("duration").asLong(30000L)) * 1000L;
        String uri = json2.get("perma_url").text();
        if (!metadataType) {
            albumName = !json2.get("album").isNull() ? this.cleanString(json2.get("album").text()) : null;
            albumUrl = !json2.get("album_url").isNull() ? json2.get("album_url").text() : null;
            previewUrl = !json2.get("media_preview_url").isNull() ? json2.get("media_preview_url").text() : json2.get("vlink").text();
        } else {
            JsonBrowser moreInfoJson = json2.get("more_info");
            albumName = !moreInfoJson.get("album").isNull() ? this.cleanString(moreInfoJson.get("album").text()) : null;
            albumUrl = !moreInfoJson.get("album_url").isNull() ? moreInfoJson.get("album_url").text() : null;
            String string2 = previewUrl = !moreInfoJson.get("vlink").isNull() ? moreInfoJson.get("vlink").text() : json2.get("vlink").text();
        }
        if (artistArtworkUrl != null) {
            artistArtworkUrl = artistArtworkUrl.replace("150x150", "500x500");
        }
        AudioTrackInfo info = new AudioTrackInfo(title, author, length, identifier, false, uri, artworkUrl, null);
        return new JioSaavnAudioTrack(info, albumName, albumUrl, artistUrl, artistArtworkUrl, previewUrl, preview, this);
    }

    private AudioItem getRecommendations(String id) throws IOException {
        List<AudioTrack> artistTracks;
        JsonBrowser metadata;
        String encodedId = URLEncoder.encode(String.format("[\"%s\"]", id), StandardCharsets.UTF_8);
        JsonBrowser json2 = this.getJson(String.format(RECOS_STATION_API_BASE, encodedId));
        if (json2 != null && !json2.get("stationid").isNull() && !json2.get("stationid").text().isEmpty()) {
            List<AudioTrack> stationTracks;
            String stationId = json2.get("stationid").text();
            json2 = this.getJson(String.format(RECOS_API_BASE, URLEncoder.encode(stationId, StandardCharsets.UTF_8)));
            if (json2 != null && !json2.values().isEmpty() && json2.get("error").isNull() && !(stationTracks = json2.values().stream().filter(JsonBrowser::isMap).map(value -> value.get("song")).map(value -> this.parseTrack((JsonBrowser)value, false, true)).collect(Collectors.toList())).isEmpty()) {
                return new JioSaavnAudioPlaylist("JioSaavn Recommendations", stationTracks, ExtendedAudioPlaylist.Type.RECOMMENDATIONS, id, null, "Saavn Editor", stationTracks.size());
            }
        }
        if ((metadata = this.getJson(MEDIA_API_BASE + URLEncoder.encode(id, StandardCharsets.UTF_8))) == null || metadata.get(id).isNull()) {
            log.error("Failed to get metadata for id: {}", (Object)id);
            return AudioReference.NO_TRACK;
        }
        String artistIdsJoined = metadata.get(id).get("primary_artists_id").text();
        json2 = this.getJson(String.format(ARTIST_RECOS_API_BASE, URLEncoder.encode(artistIdsJoined, StandardCharsets.UTF_8), URLEncoder.encode(id, StandardCharsets.UTF_8)));
        if (json2 != null && !json2.values().isEmpty() && !(artistTracks = this.localParseTracks(json2, false, true)).isEmpty()) {
            return new JioSaavnAudioPlaylist("JioSaavn Recommendations", artistTracks, ExtendedAudioPlaylist.Type.RECOMMENDATIONS, id, null, "Saavn Editor", artistTracks.size());
        }
        return AudioReference.NO_TRACK;
    }

    private AudioItem getSearch(String query, boolean preview) throws IOException {
        log.debug("Searching text based query on JioSaavn : {}", (Object)query);
        JsonBrowser json2 = this.getJson(this.buildSearchUrl(query));
        if (json2 == null || json2.get("results").values().isEmpty()) {
            log.debug("Failed to get search results for query: {}", (Object)query);
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("JioSaavn Search: " + query, this.localParseTracks(json2.get("results"), preview, false), null, true);
    }

    private AudioItem getAlbum(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson(String.format(METADATA_API_BASE, URLEncoder.encode(id, StandardCharsets.UTF_8), "album"));
        if (json2 == null || json2.get("list").values().isEmpty()) {
            log.debug("Failed to get album for id: {}", (Object)id);
            return AudioReference.NO_TRACK;
        }
        String title = this.cleanString(json2.get("title").text());
        String artworkUrl = json2.get("image").text().replace("150x150", "500x500");
        String uri = json2.get("perma_url").text();
        List<AudioTrack> tracks = this.localParseTracks(json2.get("list"), preview, true);
        int trackCount = tracks.size();
        String author = tracks.get((int)0).getInfo().author;
        return new JioSaavnAudioPlaylist(title, tracks, ExtendedAudioPlaylist.Type.ALBUM, uri, artworkUrl, author, trackCount);
    }

    private AudioItem getTrack(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson(String.format(METADATA_API_BASE, URLEncoder.encode(id, StandardCharsets.UTF_8), "song"));
        if (json2 == null || json2.get("songs").values().isEmpty()) {
            log.debug("Failed to get track for id: {}", (Object)id);
            return AudioReference.NO_TRACK;
        }
        JsonBrowser track = json2.get("songs").values().get(0);
        return this.parseTrack(track, preview, true);
    }

    private AudioItem getPlaylist(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson(String.format(METADATA_API_BASE, URLEncoder.encode(id, StandardCharsets.UTF_8), "playlist") + "&n=10000");
        if (json2 == null || json2.get("list").values().isEmpty()) {
            log.debug("Failed to get playlist for id: {}", (Object)id);
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = null;
        if (!json2.get("image").isNull()) {
            artworkUrl = json2.get("image").text().replace("150x150", "500x500");
        }
        String author = !json2.get("more_info").get("firstname").isNull() && !json2.get("more_info").get("firstname").text().isEmpty() ? json2.get("more_info").get("firstname").text() : json2.get("more_info").get("username").text();
        String title = this.cleanString(json2.get("title").text());
        List<AudioTrack> tracks = this.localParseTracks(json2.get("list"), preview, true);
        String url = json2.get("perma_url").text();
        int trackCount = tracks.size();
        return new JioSaavnAudioPlaylist(title, tracks, ExtendedAudioPlaylist.Type.PLAYLIST, url, artworkUrl, author, trackCount);
    }

    private AudioItem getArtist(String id, boolean preview) throws IOException {
        String url = String.format(METADATA_API_BASE, URLEncoder.encode(id, StandardCharsets.UTF_8), "artist") + "&n_song=" + this.config.getArtistTopTracksRequestLimit();
        JsonBrowser json2 = this.getJson(url);
        if (json2 == null || json2.get("topSongs").values().isEmpty()) {
            log.debug("Failed to get artist for id: {}", (Object)id);
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.localParseTracks(json2.get("topSongs"), preview, true);
        int trackCount = tracks.size();
        String artworkUrl = null;
        if (!json2.get("image").isNull()) {
            artworkUrl = json2.get("image").text().replace("150x150", "500x500");
        }
        String uri = json2.get("urls").get("overview").text();
        String author = this.cleanString(json2.get("name").text());
        return new JioSaavnAudioPlaylist(author + "'s Top Tracks", tracks, ExtendedAudioPlaylist.Type.ARTIST, uri, artworkUrl, author, trackCount);
    }

    @Override
    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", e);
        }
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    public JioSaavnConfig getConfig() {
        return this.config;
    }

    HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    public static class JioSaavnConfig {
        private static final String DEFAULT_ALGORITHM = "DES";
        private static final String DEFAULT_TRANSFORMATION = "DES/ECB/PKCS5Padding";
        private static final int DEFAULT_ARTIST_TOP_TRACKS_REQUEST_LIMIT = 20;
        @NotNull
        private String secretKey = "DES";
        @NotNull
        private String algorithm = "DES/ECB/PKCS5Padding";
        @NotNull
        private String transformation;
        private int artistTopTracksRequestLimit = 20;

        public JioSaavnConfig(@NotNull String secretKey) {
            Objects.requireNonNull(secretKey);
            this.secretKey = secretKey;
        }

        @NotNull
        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(@NotNull String secretKey) {
            Objects.requireNonNull(secretKey);
            this.secretKey = secretKey;
        }

        @NotNull
        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(@NotNull String algorithm) {
            Objects.requireNonNull(algorithm);
            this.algorithm = algorithm;
        }

        @NotNull
        public String getTransformation() {
            return this.transformation;
        }

        public void setTransformation(@NotNull String transformation) {
            Objects.requireNonNull(transformation);
            this.transformation = transformation;
        }

        public int getArtistTopTracksRequestLimit() {
            return this.artistTopTracksRequestLimit;
        }

        public void setArtistTopTracksRequestLimit(int artistTopTracksRequestLimit) {
            if (artistTopTracksRequestLimit < 0) {
                throw new IllegalArgumentException("artistTopTracksRequestLimit must be non-negative");
            }
            this.artistTopTracksRequestLimit = artistTopTracksRequestLimit;
        }
    }
}

