/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.yandexmusic;

import com.github.topi314.lavasrc.ExtendedAudioTrack;
import com.github.topi314.lavasrc.yandexmusic.YandexMusicSourceManager;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;

public class YandexMusicAudioTrack
extends ExtendedAudioTrack {
    private final YandexMusicSourceManager sourceManager;

    public YandexMusicAudioTrack(AudioTrackInfo trackInfo, YandexMusicSourceManager sourceManager) {
        super(trackInfo, null, null, null, null, null, false);
        this.sourceManager = sourceManager;
    }

    public YandexMusicAudioTrack(AudioTrackInfo trackInfo, String albumName, String albumUrl, String artistUrl, String artistArtworkUrl, YandexMusicSourceManager sourceManager) {
        super(trackInfo, albumName, albumUrl, artistUrl, artistArtworkUrl, null, false);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor executor) throws Exception {
        String downloadLink = this.getDownloadURL(this.trackInfo.identifier);
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();
             PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(downloadLink), this.trackInfo.length);){
            this.processDelegate(new Mp3AudioTrack(this.trackInfo, stream), executor);
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new YandexMusicAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    private String getDownloadURL(String id) throws IOException, NoSuchAlgorithmException {
        JsonBrowser json2 = this.sourceManager.getJson("https://api.music.yandex.net/tracks/" + id + "/download-info");
        if (json2.isNull() || json2.get("result").values().isEmpty()) {
            throw new IllegalStateException("No download URL found for track " + id);
        }
        String mp3ItemUrl = json2.get("result").values().stream().filter(c -> c.get("codec").text().equals("mp3")).max(Comparator.comparingLong(b -> b.get("bitrateInKbps").asLong(0L))).map(d -> d.get("downloadInfoUrl").text()).orElseThrow(() -> new IllegalStateException("No download Mp3 item URL found for track " + id));
        String downloadInfo = this.sourceManager.getDownloadStrings(mp3ItemUrl, "downloadinfo-xml-page")[0];
        if (downloadInfo.isEmpty()) {
            throw new IllegalStateException("No downloadInfo found for track " + id);
        }
        Document doc = Jsoup.parse(downloadInfo, "", Parser.xmlParser());
        String host = doc.select("host").text();
        String path = doc.select("path").text();
        String ts = doc.select("ts").text();
        String s = doc.select("s").text();
        String sign = "XGRlBW9FXlekgbPrRHuSiA" + path + s;
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(sign.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte b2 : digest) {
            sb.append(String.format("%02x", b2));
        }
        String md5 = sb.toString();
        return "https://" + host + "/get-mp3/" + md5 + "/" + ts + path;
    }
}

