/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.AudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.AudioFilterChain;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.converter.ConverterAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.converter.ToFloatAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.converter.ToShortAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.converter.ToSplitShortAudioFilter;
import java.util.ArrayList;
import java.util.List;

public class FilterChainBuilder {
    private final List<AudioFilter> filters = new ArrayList<AudioFilter>();

    public void addFirst(AudioFilter filter2) {
        this.filters.add(filter2);
    }

    public AudioFilter first() {
        return this.filters.get(this.filters.size() - 1);
    }

    public FloatPcmAudioFilter makeFirstFloat(int channelCount) {
        AudioFilter first = this.first();
        if (first instanceof FloatPcmAudioFilter) {
            return (FloatPcmAudioFilter)first;
        }
        return this.prependUniversalFilter(first, channelCount);
    }

    public UniversalPcmAudioFilter makeFirstUniversal(int channelCount) {
        AudioFilter first = this.first();
        if (first instanceof UniversalPcmAudioFilter) {
            return (UniversalPcmAudioFilter)first;
        }
        return this.prependUniversalFilter(first, channelCount);
    }

    public AudioFilterChain build(Object context, int channelCount) {
        UniversalPcmAudioFilter firstFilter = this.makeFirstUniversal(channelCount);
        return new AudioFilterChain(firstFilter, this.filters, context);
    }

    private UniversalPcmAudioFilter prependUniversalFilter(AudioFilter first, int channelCount) {
        ConverterAudioFilter universalInput;
        if (first instanceof SplitShortPcmAudioFilter) {
            universalInput = new ToSplitShortAudioFilter((SplitShortPcmAudioFilter)first, channelCount);
        } else if (first instanceof FloatPcmAudioFilter) {
            universalInput = new ToFloatAudioFilter((FloatPcmAudioFilter)first, channelCount);
        } else if (first instanceof ShortPcmAudioFilter) {
            universalInput = new ToShortAudioFilter((ShortPcmAudioFilter)first, channelCount);
        } else {
            throw new RuntimeException("Filter must implement at least one data type.");
        }
        this.addFirst(universalInput);
        return universalInput;
    }
}

