/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import com.sedmelluq.discord.lavaplayer.tools.io.EmptyInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentHttpStream
extends SeekableInputStream
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PersistentHttpStream.class);
    private static final long MAX_SKIP_DISTANCE = 524288L;
    protected final HttpInterface httpInterface;
    protected final URI contentUrl;
    private int lastStatusCode;
    private CloseableHttpResponse currentResponse;
    protected InputStream currentContent;
    protected long position;

    public PersistentHttpStream(HttpInterface httpInterface, URI contentUrl, Long contentLength) {
        super(contentLength == null ? Long.MAX_VALUE : contentLength, 524288L);
        this.httpInterface = httpInterface;
        this.contentUrl = contentUrl;
        this.position = 0L;
    }

    public int checkStatusCode() throws IOException {
        this.connect(true);
        return this.lastStatusCode;
    }

    public HttpResponse getCurrentResponse() {
        return this.currentResponse;
    }

    protected URI getConnectUrl() {
        return this.contentUrl;
    }

    protected boolean useHeadersForRange() {
        return true;
    }

    private static boolean validateStatusCode(HttpResponse response, boolean returnOnServerError) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (returnOnServerError && statusCode >= 500) {
            return false;
        }
        if (!HttpClientTools.isSuccessWithContent(statusCode)) {
            throw new RuntimeException("Not success status code: " + statusCode);
        }
        return true;
    }

    protected HttpGet getConnectRequest() {
        HttpGet request = new HttpGet(this.getConnectUrl());
        if (this.position > 0L && this.useHeadersForRange()) {
            request.setHeader("Range", "bytes=" + this.position + "-");
        }
        return request;
    }

    protected void connect(boolean skipStatusCheck) throws IOException {
        if (this.currentResponse == null) {
            for (int i = 1; i >= 0 && !this.attemptConnect(skipStatusCheck, i > 0); --i) {
            }
        }
    }

    public InputStream createContentInputStream(HttpResponse response) throws IOException {
        return new BufferedInputStream(response.getEntity().getContent());
    }

    private boolean attemptConnect(boolean skipStatusCheck, boolean retryOnServerError) throws IOException {
        Header header;
        this.currentResponse = this.httpInterface.execute(this.getConnectRequest());
        this.lastStatusCode = this.currentResponse.getStatusLine().getStatusCode();
        if (!skipStatusCheck && !PersistentHttpStream.validateStatusCode(this.currentResponse, retryOnServerError)) {
            return false;
        }
        if (this.currentResponse.getEntity() == null) {
            this.currentContent = EmptyInputStream.INSTANCE;
            this.contentLength = 0L;
            return true;
        }
        this.currentContent = this.createContentInputStream(this.currentResponse);
        if (this.contentLength == Long.MAX_VALUE && (header = this.currentResponse.getFirstHeader("Content-Length")) != null) {
            this.contentLength = Long.parseLong(header.getValue());
        }
        return true;
    }

    private void handleNetworkException(IOException exception, boolean attemptReconnect) throws IOException {
        if (!attemptReconnect || !HttpClientTools.isRetriableNetworkException(exception)) {
            throw exception;
        }
        this.close();
        log.debug("Encountered retriable exception on url {}.", (Object)this.contentUrl, (Object)exception);
    }

    private int internalRead(boolean attemptReconnect) throws IOException {
        this.connect(false);
        try {
            int result = this.currentContent.read();
            if (result >= 0) {
                ++this.position;
            }
            return result;
        }
        catch (IOException e) {
            this.handleNetworkException(e, attemptReconnect);
            return this.internalRead(false);
        }
    }

    @Override
    public int read() throws IOException {
        return this.internalRead(true);
    }

    protected int internalRead(byte[] b, int off, int len, boolean attemptReconnect) throws IOException {
        this.connect(false);
        try {
            int result = this.currentContent.read(b, off, len);
            if (result >= 0) {
                this.position += (long)result;
            }
            return result;
        }
        catch (IOException e) {
            this.handleNetworkException(e, attemptReconnect);
            return this.internalRead(b, off, len, false);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.internalRead(b, off, len, true);
    }

    protected long internalSkip(long n, boolean attemptReconnect) throws IOException {
        this.connect(false);
        try {
            long result = this.currentContent.skip(n);
            if (result >= 0L) {
                this.position += result;
            }
            return result;
        }
        catch (IOException e) {
            this.handleNetworkException(e, attemptReconnect);
            return this.internalSkip(n, false);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.internalSkip(n, true);
    }

    private int internalAvailable(boolean attemptReconnect) throws IOException {
        this.connect(false);
        try {
            return this.currentContent.available();
        }
        catch (IOException e) {
            this.handleNetworkException(e, attemptReconnect);
            return this.internalAvailable(false);
        }
    }

    @Override
    public int available() throws IOException {
        return this.internalAvailable(true);
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.currentResponse != null) {
            try {
                this.currentResponse.close();
            }
            catch (IOException e) {
                log.debug("Failed to close response.", e);
            }
            this.currentResponse = null;
            this.currentContent = null;
        }
    }

    public void releaseConnection() {
        if (this.currentContent != null) {
            try {
                this.currentContent.close();
            }
            catch (IOException e) {
                log.debug("Failed to close response stream.", e);
            }
        }
        this.currentResponse = null;
        this.currentContent = null;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    protected void seekHard(long position) throws IOException {
        this.close();
        this.position = position;
    }

    @Override
    public boolean canSeekHard() {
        return this.contentLength != Long.MAX_VALUE;
    }

    @Override
    public List<AudioTrackInfoProvider> getTrackInfoProviders() {
        if (this.currentResponse != null) {
            return Collections.singletonList(this.createIceCastHeaderProvider());
        }
        return Collections.emptyList();
    }

    private AudioTrackInfoProvider createIceCastHeaderProvider() {
        AudioTrackInfoBuilder builder = AudioTrackInfoBuilder.empty().setTitle(HttpClientTools.getHeaderValue(this.currentResponse, "icy-description")).setAuthor(HttpClientTools.getHeaderValue(this.currentResponse, "icy-name"));
        if (builder.getTitle() == null) {
            builder.setTitle(HttpClientTools.getHeaderValue(this.currentResponse, "icy-url"));
        }
        return builder;
    }
}

