/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.InvalidFrameException;

public class ID3Compression {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.id3");

    protected static ByteBuffer uncompress(String identifier, String filename, ByteBuffer byteBuffer, int decompressedFrameSize, int realFrameSize) throws InvalidFrameException {
        byte[] result = new byte[decompressedFrameSize];
        byte[] input = new byte[realFrameSize];
        int position = byteBuffer.position();
        byteBuffer.get(input, 0, realFrameSize);
        byteBuffer.position(position);
        Inflater decompresser = new Inflater();
        decompresser.setInput(input);
        try {
            int n = decompresser.inflate(result);
        }
        catch (DataFormatException dfe) {
            byteBuffer.position(byteBuffer.position() + realFrameSize);
            throw new InvalidFrameException(ErrorMessage.ID3_UNABLE_TO_DECOMPRESS_FRAME.getMsg(identifier, filename, dfe.getMessage()));
        }
        decompresser.end();
        return ByteBuffer.wrap(result);
    }
}

