/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.util.EnumMap;
import java.util.Map;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3v23FieldKey;

public class ID3v23Frames
extends ID3Frames {
    public static final String FRAME_ID_V3_ACCOMPANIMENT = "TPE2";
    public static final String FRAME_ID_V3_ALBUM = "TALB";
    public static final String FRAME_ID_V3_ARTIST = "TPE1";
    public static final String FRAME_ID_V3_ATTACHED_PICTURE = "APIC";
    public static final String FRAME_ID_V3_AUDIO_ENCRYPTION = "AENC";
    public static final String FRAME_ID_V3_BPM = "TBPM";
    public static final String FRAME_ID_V3_CHAPTER = "CHAP";
    public static final String FRAME_ID_V3_CHAPTER_TOC = "CTOC";
    public static final String FRAME_ID_V3_COMMENT = "COMM";
    public static final String FRAME_ID_V3_COMMERCIAL_FRAME = "COMR";
    public static final String FRAME_ID_V3_COMPOSER = "TCOM";
    public static final String FRAME_ID_V3_CONDUCTOR = "TPE3";
    public static final String FRAME_ID_V3_CONTENT_GROUP_DESC = "TIT1";
    public static final String FRAME_ID_V3_COPYRIGHTINFO = "TCOP";
    public static final String FRAME_ID_V3_ENCODEDBY = "TENC";
    public static final String FRAME_ID_V3_ENCRYPTION = "ENCR";
    public static final String FRAME_ID_V3_EQUALISATION = "EQUA";
    public static final String FRAME_ID_V3_EVENT_TIMING_CODES = "ETCO";
    public static final String FRAME_ID_V3_FILE_OWNER = "TOWN";
    public static final String FRAME_ID_V3_FILE_TYPE = "TFLT";
    public static final String FRAME_ID_V3_GENERAL_ENCAPS_OBJECT = "GEOB";
    public static final String FRAME_ID_V3_GENRE = "TCON";
    public static final String FRAME_ID_V3_GROUP_ID_REG = "GRID";
    public static final String FRAME_ID_V3_HW_SW_SETTINGS = "TSSE";
    public static final String FRAME_ID_V3_INITIAL_KEY = "TKEY";
    public static final String FRAME_ID_V3_INVOLVED_PEOPLE = "IPLS";
    public static final String FRAME_ID_V3_ISRC = "TSRC";
    public static final String FRAME_ID_V3_ITUNES_GROUPING = "GRP1";
    public static final String FRAME_ID_V3_LANGUAGE = "TLAN";
    public static final String FRAME_ID_V3_LENGTH = "TLEN";
    public static final String FRAME_ID_V3_LINKED_INFO = "LINK";
    public static final String FRAME_ID_V3_LYRICIST = "TEXT";
    public static final String FRAME_ID_V3_MEDIA_TYPE = "TMED";
    public static final String FRAME_ID_V3_MOVEMENT = "MVNM";
    public static final String FRAME_ID_V3_MOVEMENT_NO = "MVIN";
    public static final String FRAME_ID_V3_MPEG_LOCATION_LOOKUP_TABLE = "MLLT";
    public static final String FRAME_ID_V3_MUSIC_CD_ID = "MCDI";
    public static final String FRAME_ID_V3_ORIGARTIST = "TOPE";
    public static final String FRAME_ID_V3_ORIG_FILENAME = "TOFN";
    public static final String FRAME_ID_V3_ORIG_LYRICIST = "TOLY";
    public static final String FRAME_ID_V3_ORIG_TITLE = "TOAL";
    public static final String FRAME_ID_V3_OWNERSHIP = "OWNE";
    public static final String FRAME_ID_V3_PLAYLIST_DELAY = "TDLY";
    public static final String FRAME_ID_V3_PLAY_COUNTER = "PCNT";
    public static final String FRAME_ID_V3_POPULARIMETER = "POPM";
    public static final String FRAME_ID_V3_POSITION_SYNC = "POSS";
    public static final String FRAME_ID_V3_PRIVATE = "PRIV";
    public static final String FRAME_ID_V3_PUBLISHER = "TPUB";
    public static final String FRAME_ID_V3_RADIO_NAME = "TRSN";
    public static final String FRAME_ID_V3_RADIO_OWNER = "TRSO";
    public static final String FRAME_ID_V3_RECOMMENDED_BUFFER_SIZE = "RBUF";
    public static final String FRAME_ID_V3_RELATIVE_VOLUME_ADJUSTMENT = "RVAD";
    public static final String FRAME_ID_V3_REMIXED = "TPE4";
    public static final String FRAME_ID_V3_REVERB = "RVRB";
    public static final String FRAME_ID_V3_SET = "TPOS";
    public static final String FRAME_ID_V3_SYNC_LYRIC = "SYLT";
    public static final String FRAME_ID_V3_SYNC_TEMPO = "SYTC";
    public static final String FRAME_ID_V3_TDAT = "TDAT";
    public static final String FRAME_ID_V3_TERMS_OF_USE = "USER";
    public static final String FRAME_ID_V3_TIME = "TIME";
    public static final String FRAME_ID_V3_TITLE = "TIT2";
    public static final String FRAME_ID_V3_TITLE_REFINEMENT = "TIT3";
    public static final String FRAME_ID_V3_TORY = "TORY";
    public static final String FRAME_ID_V3_TRACK = "TRCK";
    public static final String FRAME_ID_V3_TRDA = "TRDA";
    public static final String FRAME_ID_V3_TSIZ = "TSIZ";
    public static final String FRAME_ID_V3_TYER = "TYER";
    public static final String FRAME_ID_V3_UNIQUE_FILE_ID = "UFID";
    public static final String FRAME_ID_V3_UNSYNC_LYRICS = "USLT";
    public static final String FRAME_ID_V3_URL_ARTIST_WEB = "WOAR";
    public static final String FRAME_ID_V3_URL_COMMERCIAL = "WCOM";
    public static final String FRAME_ID_V3_URL_COPYRIGHT = "WCOP";
    public static final String FRAME_ID_V3_URL_FILE_WEB = "WOAF";
    public static final String FRAME_ID_V3_URL_OFFICIAL_RADIO = "WORS";
    public static final String FRAME_ID_V3_URL_PAYMENT = "WPAY";
    public static final String FRAME_ID_V3_URL_PUBLISHERS = "WPUB";
    public static final String FRAME_ID_V3_URL_SOURCE_WEB = "WOAS";
    public static final String FRAME_ID_V3_USER_DEFINED_INFO = "TXXX";
    public static final String FRAME_ID_V3_USER_DEFINED_URL = "WXXX";
    public static final String FRAME_ID_V3_IS_COMPILATION = "TCMP";
    public static final String FRAME_ID_V3_TITLE_SORT_ORDER_ITUNES = "TSOT";
    public static final String FRAME_ID_V3_ARTIST_SORT_ORDER_ITUNES = "TSOP";
    public static final String FRAME_ID_V3_ALBUM_SORT_ORDER_ITUNES = "TSOA";
    public static final String FRAME_ID_V3_TITLE_SORT_ORDER_MUSICBRAINZ = "XSOT";
    public static final String FRAME_ID_V3_ARTIST_SORT_ORDER_MUSICBRAINZ = "XSOP";
    public static final String FRAME_ID_V3_ALBUM_SORT_ORDER_MUSICBRAINZ = "XSOA";
    public static final String FRAME_ID_V3_ALBUM_ARTIST_SORT_ORDER_ITUNES = "TSO2";
    public static final String FRAME_ID_V3_COMPOSER_SORT_ORDER_ITUNES = "TSOC";
    public static final String FRAME_ID_V3_SET_SUBTITLE = "TSST";
    private static ID3v23Frames id3v23Frames;
    protected EnumMap<FieldKey, ID3v23FieldKey> tagFieldToId3 = new EnumMap(FieldKey.class);
    protected EnumMap<ID3v23FieldKey, FieldKey> id3ToTagField = new EnumMap(ID3v23FieldKey.class);

    public static ID3v23Frames getInstanceOf() {
        if (id3v23Frames == null) {
            id3v23Frames = new ID3v23Frames();
        }
        return id3v23Frames;
    }

    private ID3v23Frames() {
        this.supportedFrames.add(FRAME_ID_V3_ACCOMPANIMENT);
        this.supportedFrames.add(FRAME_ID_V3_ALBUM);
        this.supportedFrames.add(FRAME_ID_V3_ARTIST);
        this.supportedFrames.add(FRAME_ID_V3_ATTACHED_PICTURE);
        this.supportedFrames.add(FRAME_ID_V3_AUDIO_ENCRYPTION);
        this.supportedFrames.add(FRAME_ID_V3_BPM);
        this.supportedFrames.add(FRAME_ID_V3_CHAPTER);
        this.supportedFrames.add(FRAME_ID_V3_CHAPTER_TOC);
        this.supportedFrames.add(FRAME_ID_V3_COMMENT);
        this.supportedFrames.add(FRAME_ID_V3_COMMERCIAL_FRAME);
        this.supportedFrames.add(FRAME_ID_V3_COMPOSER);
        this.supportedFrames.add(FRAME_ID_V3_CONDUCTOR);
        this.supportedFrames.add(FRAME_ID_V3_CONTENT_GROUP_DESC);
        this.supportedFrames.add(FRAME_ID_V3_COPYRIGHTINFO);
        this.supportedFrames.add(FRAME_ID_V3_ENCODEDBY);
        this.supportedFrames.add(FRAME_ID_V3_ENCRYPTION);
        this.supportedFrames.add(FRAME_ID_V3_EQUALISATION);
        this.supportedFrames.add(FRAME_ID_V3_EVENT_TIMING_CODES);
        this.supportedFrames.add(FRAME_ID_V3_FILE_OWNER);
        this.supportedFrames.add(FRAME_ID_V3_FILE_TYPE);
        this.supportedFrames.add(FRAME_ID_V3_GENERAL_ENCAPS_OBJECT);
        this.supportedFrames.add(FRAME_ID_V3_GENRE);
        this.supportedFrames.add(FRAME_ID_V3_GROUP_ID_REG);
        this.supportedFrames.add(FRAME_ID_V3_HW_SW_SETTINGS);
        this.supportedFrames.add(FRAME_ID_V3_INITIAL_KEY);
        this.supportedFrames.add(FRAME_ID_V3_INVOLVED_PEOPLE);
        this.supportedFrames.add(FRAME_ID_V3_ISRC);
        this.supportedFrames.add(FRAME_ID_V3_ITUNES_GROUPING);
        this.supportedFrames.add(FRAME_ID_V3_LANGUAGE);
        this.supportedFrames.add(FRAME_ID_V3_LENGTH);
        this.supportedFrames.add(FRAME_ID_V3_LINKED_INFO);
        this.supportedFrames.add(FRAME_ID_V3_LYRICIST);
        this.supportedFrames.add(FRAME_ID_V3_MEDIA_TYPE);
        this.supportedFrames.add(FRAME_ID_V3_MPEG_LOCATION_LOOKUP_TABLE);
        this.supportedFrames.add(FRAME_ID_V3_MOVEMENT);
        this.supportedFrames.add(FRAME_ID_V3_MOVEMENT_NO);
        this.supportedFrames.add(FRAME_ID_V3_MUSIC_CD_ID);
        this.supportedFrames.add(FRAME_ID_V3_ORIGARTIST);
        this.supportedFrames.add(FRAME_ID_V3_ORIG_FILENAME);
        this.supportedFrames.add(FRAME_ID_V3_ORIG_LYRICIST);
        this.supportedFrames.add(FRAME_ID_V3_ORIG_TITLE);
        this.supportedFrames.add(FRAME_ID_V3_OWNERSHIP);
        this.supportedFrames.add(FRAME_ID_V3_PLAYLIST_DELAY);
        this.supportedFrames.add(FRAME_ID_V3_PLAY_COUNTER);
        this.supportedFrames.add(FRAME_ID_V3_POPULARIMETER);
        this.supportedFrames.add(FRAME_ID_V3_POSITION_SYNC);
        this.supportedFrames.add(FRAME_ID_V3_PRIVATE);
        this.supportedFrames.add(FRAME_ID_V3_PUBLISHER);
        this.supportedFrames.add(FRAME_ID_V3_RADIO_NAME);
        this.supportedFrames.add(FRAME_ID_V3_RADIO_OWNER);
        this.supportedFrames.add(FRAME_ID_V3_RECOMMENDED_BUFFER_SIZE);
        this.supportedFrames.add(FRAME_ID_V3_RELATIVE_VOLUME_ADJUSTMENT);
        this.supportedFrames.add(FRAME_ID_V3_REMIXED);
        this.supportedFrames.add(FRAME_ID_V3_REVERB);
        this.supportedFrames.add(FRAME_ID_V3_SET);
        this.supportedFrames.add(FRAME_ID_V3_SET_SUBTITLE);
        this.supportedFrames.add(FRAME_ID_V3_SYNC_LYRIC);
        this.supportedFrames.add(FRAME_ID_V3_SYNC_TEMPO);
        this.supportedFrames.add(FRAME_ID_V3_TDAT);
        this.supportedFrames.add(FRAME_ID_V3_TERMS_OF_USE);
        this.supportedFrames.add(FRAME_ID_V3_TIME);
        this.supportedFrames.add(FRAME_ID_V3_TITLE);
        this.supportedFrames.add(FRAME_ID_V3_TITLE_REFINEMENT);
        this.supportedFrames.add(FRAME_ID_V3_TORY);
        this.supportedFrames.add(FRAME_ID_V3_TRACK);
        this.supportedFrames.add(FRAME_ID_V3_TRDA);
        this.supportedFrames.add(FRAME_ID_V3_TSIZ);
        this.supportedFrames.add(FRAME_ID_V3_TYER);
        this.supportedFrames.add(FRAME_ID_V3_UNIQUE_FILE_ID);
        this.supportedFrames.add(FRAME_ID_V3_UNSYNC_LYRICS);
        this.supportedFrames.add(FRAME_ID_V3_URL_ARTIST_WEB);
        this.supportedFrames.add(FRAME_ID_V3_URL_COMMERCIAL);
        this.supportedFrames.add(FRAME_ID_V3_URL_COPYRIGHT);
        this.supportedFrames.add(FRAME_ID_V3_URL_FILE_WEB);
        this.supportedFrames.add(FRAME_ID_V3_URL_OFFICIAL_RADIO);
        this.supportedFrames.add(FRAME_ID_V3_URL_PAYMENT);
        this.supportedFrames.add(FRAME_ID_V3_URL_PUBLISHERS);
        this.supportedFrames.add(FRAME_ID_V3_URL_SOURCE_WEB);
        this.supportedFrames.add(FRAME_ID_V3_USER_DEFINED_INFO);
        this.supportedFrames.add(FRAME_ID_V3_USER_DEFINED_URL);
        this.extensionFrames.add(FRAME_ID_V3_IS_COMPILATION);
        this.extensionFrames.add(FRAME_ID_V3_TITLE_SORT_ORDER_ITUNES);
        this.extensionFrames.add(FRAME_ID_V3_ARTIST_SORT_ORDER_ITUNES);
        this.extensionFrames.add(FRAME_ID_V3_ALBUM_SORT_ORDER_ITUNES);
        this.extensionFrames.add(FRAME_ID_V3_TITLE_SORT_ORDER_MUSICBRAINZ);
        this.extensionFrames.add(FRAME_ID_V3_ARTIST_SORT_ORDER_MUSICBRAINZ);
        this.extensionFrames.add(FRAME_ID_V3_ALBUM_SORT_ORDER_MUSICBRAINZ);
        this.extensionFrames.add(FRAME_ID_V3_ALBUM_ARTIST_SORT_ORDER_ITUNES);
        this.extensionFrames.add(FRAME_ID_V3_COMPOSER_SORT_ORDER_ITUNES);
        this.commonFrames.add(FRAME_ID_V3_ARTIST);
        this.commonFrames.add(FRAME_ID_V3_ALBUM);
        this.commonFrames.add(FRAME_ID_V3_TITLE);
        this.commonFrames.add(FRAME_ID_V3_GENRE);
        this.commonFrames.add(FRAME_ID_V3_TRACK);
        this.commonFrames.add(FRAME_ID_V3_TYER);
        this.commonFrames.add(FRAME_ID_V3_COMMENT);
        this.binaryFrames.add(FRAME_ID_V3_ATTACHED_PICTURE);
        this.binaryFrames.add(FRAME_ID_V3_AUDIO_ENCRYPTION);
        this.binaryFrames.add(FRAME_ID_V3_ENCRYPTION);
        this.binaryFrames.add(FRAME_ID_V3_EQUALISATION);
        this.binaryFrames.add(FRAME_ID_V3_EVENT_TIMING_CODES);
        this.binaryFrames.add(FRAME_ID_V3_GENERAL_ENCAPS_OBJECT);
        this.binaryFrames.add(FRAME_ID_V3_RELATIVE_VOLUME_ADJUSTMENT);
        this.binaryFrames.add(FRAME_ID_V3_RECOMMENDED_BUFFER_SIZE);
        this.binaryFrames.add(FRAME_ID_V3_UNIQUE_FILE_ID);
        this.idToValue.put(FRAME_ID_V3_ACCOMPANIMENT, "Text: Band/Orchestra/Accompaniment");
        this.idToValue.put(FRAME_ID_V3_ALBUM, "Text: Album/Movie/Show title");
        this.idToValue.put(FRAME_ID_V3_ARTIST, "Text: Lead artist(s)/Lead performer(s)/Soloist(s)/Performing group");
        this.idToValue.put(FRAME_ID_V3_ATTACHED_PICTURE, "Attached picture");
        this.idToValue.put(FRAME_ID_V3_AUDIO_ENCRYPTION, "Audio encryption");
        this.idToValue.put(FRAME_ID_V3_BPM, "Text: BPM (Beats Per Minute)");
        this.idToValue.put(FRAME_ID_V3_CHAPTER, "Chapter");
        this.idToValue.put(FRAME_ID_V3_CHAPTER_TOC, "Chapter TOC");
        this.idToValue.put(FRAME_ID_V3_COMMENT, "Comments");
        this.idToValue.put(FRAME_ID_V3_COMMERCIAL_FRAME, "");
        this.idToValue.put(FRAME_ID_V3_COMPOSER, "Text: Composer");
        this.idToValue.put(FRAME_ID_V3_CONDUCTOR, "Text: Conductor/Performer refinement");
        this.idToValue.put(FRAME_ID_V3_CONTENT_GROUP_DESC, "Text: Content group description");
        this.idToValue.put(FRAME_ID_V3_COPYRIGHTINFO, "Text: Copyright message");
        this.idToValue.put(FRAME_ID_V3_ENCODEDBY, "Text: Encoded by");
        this.idToValue.put(FRAME_ID_V3_ENCRYPTION, "Encryption method registration");
        this.idToValue.put(FRAME_ID_V3_EQUALISATION, "Equalization");
        this.idToValue.put(FRAME_ID_V3_EVENT_TIMING_CODES, "Event timing codes");
        this.idToValue.put(FRAME_ID_V3_FILE_OWNER, "");
        this.idToValue.put(FRAME_ID_V3_FILE_TYPE, "Text: File type");
        this.idToValue.put(FRAME_ID_V3_GENERAL_ENCAPS_OBJECT, "General encapsulated datatype");
        this.idToValue.put(FRAME_ID_V3_GENRE, "Text: Content type");
        this.idToValue.put(FRAME_ID_V3_GROUP_ID_REG, "");
        this.idToValue.put(FRAME_ID_V3_HW_SW_SETTINGS, "Text: Software/hardware and settings used for encoding");
        this.idToValue.put(FRAME_ID_V3_INITIAL_KEY, "Text: Initial key");
        this.idToValue.put(FRAME_ID_V3_INVOLVED_PEOPLE, "Involved people list");
        this.idToValue.put(FRAME_ID_V3_ISRC, "Text: ISRC (International Standard Recording Code)");
        this.idToValue.put(FRAME_ID_V3_ITUNES_GROUPING, "Text: iTunes Grouping");
        this.idToValue.put(FRAME_ID_V3_LANGUAGE, "Text: Language(s)");
        this.idToValue.put(FRAME_ID_V3_LENGTH, "Text: Length");
        this.idToValue.put(FRAME_ID_V3_LINKED_INFO, "Linked information");
        this.idToValue.put(FRAME_ID_V3_LYRICIST, "Text: Lyricist/text writer");
        this.idToValue.put(FRAME_ID_V3_MEDIA_TYPE, "Text: Media type");
        this.idToValue.put(FRAME_ID_V3_MOVEMENT, "Text: Movement");
        this.idToValue.put(FRAME_ID_V3_MOVEMENT_NO, "Text: Movement No");
        this.idToValue.put(FRAME_ID_V3_MPEG_LOCATION_LOOKUP_TABLE, "MPEG location lookup table");
        this.idToValue.put(FRAME_ID_V3_MUSIC_CD_ID, "Music CD Identifier");
        this.idToValue.put(FRAME_ID_V3_ORIGARTIST, "Text: Original artist(s)/performer(s)");
        this.idToValue.put(FRAME_ID_V3_ORIG_FILENAME, "Text: Original filename");
        this.idToValue.put(FRAME_ID_V3_ORIG_LYRICIST, "Text: Original Lyricist(s)/text writer(s)");
        this.idToValue.put(FRAME_ID_V3_ORIG_TITLE, "Text: Original album/Movie/Show title");
        this.idToValue.put(FRAME_ID_V3_OWNERSHIP, "");
        this.idToValue.put(FRAME_ID_V3_PLAYLIST_DELAY, "Text: Playlist delay");
        this.idToValue.put(FRAME_ID_V3_PLAY_COUNTER, "Play counter");
        this.idToValue.put(FRAME_ID_V3_POPULARIMETER, "Popularimeter");
        this.idToValue.put(FRAME_ID_V3_POSITION_SYNC, "Position Sync");
        this.idToValue.put(FRAME_ID_V3_PRIVATE, "Private frame");
        this.idToValue.put(FRAME_ID_V3_PUBLISHER, "Text: Publisher");
        this.idToValue.put(FRAME_ID_V3_RADIO_NAME, "");
        this.idToValue.put(FRAME_ID_V3_RADIO_OWNER, "");
        this.idToValue.put(FRAME_ID_V3_RECOMMENDED_BUFFER_SIZE, "Recommended buffer size");
        this.idToValue.put(FRAME_ID_V3_RELATIVE_VOLUME_ADJUSTMENT, "Relative volume adjustment");
        this.idToValue.put(FRAME_ID_V3_REMIXED, "Text: Interpreted, remixed, or otherwise modified by");
        this.idToValue.put(FRAME_ID_V3_REVERB, "Reverb");
        this.idToValue.put(FRAME_ID_V3_SET, "Text: Part of a setField");
        this.idToValue.put(FRAME_ID_V3_SET_SUBTITLE, "Text: SubTitle");
        this.idToValue.put(FRAME_ID_V3_SYNC_LYRIC, "Synchronized lyric/text");
        this.idToValue.put(FRAME_ID_V3_SYNC_TEMPO, "Synced tempo codes");
        this.idToValue.put(FRAME_ID_V3_TDAT, "Text: Date");
        this.idToValue.put(FRAME_ID_V3_TERMS_OF_USE, "");
        this.idToValue.put(FRAME_ID_V3_TIME, "Text: Time");
        this.idToValue.put(FRAME_ID_V3_TITLE, "Text: Title/Songname/Content description");
        this.idToValue.put(FRAME_ID_V3_TITLE_REFINEMENT, "Text: Subtitle/Description refinement");
        this.idToValue.put(FRAME_ID_V3_TORY, "Text: Original release year");
        this.idToValue.put(FRAME_ID_V3_TRACK, "Text: Track number/Position in setField");
        this.idToValue.put(FRAME_ID_V3_TRDA, "Text: Recording dates");
        this.idToValue.put(FRAME_ID_V3_TSIZ, "Text: Size");
        this.idToValue.put(FRAME_ID_V3_TYER, "Text: Year");
        this.idToValue.put(FRAME_ID_V3_UNIQUE_FILE_ID, "Unique file identifier");
        this.idToValue.put(FRAME_ID_V3_UNSYNC_LYRICS, "Unsychronized lyric/text transcription");
        this.idToValue.put(FRAME_ID_V3_URL_ARTIST_WEB, "URL: Official artist/performer webpage");
        this.idToValue.put(FRAME_ID_V3_URL_COMMERCIAL, "URL: Commercial information");
        this.idToValue.put(FRAME_ID_V3_URL_COPYRIGHT, "URL: Copyright/Legal information");
        this.idToValue.put(FRAME_ID_V3_URL_FILE_WEB, "URL: Official audio file webpage");
        this.idToValue.put(FRAME_ID_V3_URL_OFFICIAL_RADIO, "Official Radio");
        this.idToValue.put(FRAME_ID_V3_URL_PAYMENT, "URL: Payment");
        this.idToValue.put(FRAME_ID_V3_URL_PUBLISHERS, "URL: Publishers official webpage");
        this.idToValue.put(FRAME_ID_V3_URL_SOURCE_WEB, "URL: Official audio source webpage");
        this.idToValue.put(FRAME_ID_V3_USER_DEFINED_INFO, "User defined text information frame");
        this.idToValue.put(FRAME_ID_V3_USER_DEFINED_URL, "User defined URL link frame");
        this.idToValue.put(FRAME_ID_V3_IS_COMPILATION, "Is Compilation");
        this.idToValue.put(FRAME_ID_V3_TITLE_SORT_ORDER_ITUNES, "Text: title sort order");
        this.idToValue.put(FRAME_ID_V3_ARTIST_SORT_ORDER_ITUNES, "Text: artist sort order");
        this.idToValue.put(FRAME_ID_V3_ALBUM_SORT_ORDER_ITUNES, "Text: album sort order");
        this.idToValue.put(FRAME_ID_V3_TITLE_SORT_ORDER_MUSICBRAINZ, "Text: title sort order");
        this.idToValue.put(FRAME_ID_V3_ARTIST_SORT_ORDER_MUSICBRAINZ, "Text: artist sort order");
        this.idToValue.put(FRAME_ID_V3_ALBUM_SORT_ORDER_MUSICBRAINZ, "Text: album sort order");
        this.idToValue.put(FRAME_ID_V3_ALBUM_ARTIST_SORT_ORDER_ITUNES, "Text:Album Artist Sort Order Frame");
        this.idToValue.put(FRAME_ID_V3_COMPOSER_SORT_ORDER_ITUNES, "Text:Composer Sort Order Frame");
        this.createMaps();
        this.multipleFrames.add(FRAME_ID_V3_USER_DEFINED_INFO);
        this.multipleFrames.add(FRAME_ID_V3_USER_DEFINED_URL);
        this.multipleFrames.add(FRAME_ID_V3_ATTACHED_PICTURE);
        this.multipleFrames.add(FRAME_ID_V3_PRIVATE);
        this.multipleFrames.add(FRAME_ID_V3_COMMENT);
        this.multipleFrames.add(FRAME_ID_V3_UNIQUE_FILE_ID);
        this.multipleFrames.add(FRAME_ID_V3_UNSYNC_LYRICS);
        this.multipleFrames.add(FRAME_ID_V3_POPULARIMETER);
        this.multipleFrames.add(FRAME_ID_V3_GENERAL_ENCAPS_OBJECT);
        this.multipleFrames.add(FRAME_ID_V3_URL_ARTIST_WEB);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_EVENT_TIMING_CODES);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_EQUALISATION);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_MPEG_LOCATION_LOOKUP_TABLE);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_POSITION_SYNC);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_SYNC_LYRIC);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_SYNC_TEMPO);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_RELATIVE_VOLUME_ADJUSTMENT);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_EVENT_TIMING_CODES);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_ENCODEDBY);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_LENGTH);
        this.discardIfFileAlteredFrames.add(FRAME_ID_V3_TSIZ);
        this.tagFieldToId3.put(FieldKey.ACOUSTID_FINGERPRINT, ID3v23FieldKey.ACOUSTID_FINGERPRINT);
        this.tagFieldToId3.put(FieldKey.ACOUSTID_ID, ID3v23FieldKey.ACOUSTID_ID);
        this.tagFieldToId3.put(FieldKey.ALBUM, ID3v23FieldKey.ALBUM);
        this.tagFieldToId3.put(FieldKey.ALBUM_ARTIST, ID3v23FieldKey.ALBUM_ARTIST);
        this.tagFieldToId3.put(FieldKey.ALBUM_ARTIST_SORT, ID3v23FieldKey.ALBUM_ARTIST_SORT);
        this.tagFieldToId3.put(FieldKey.ALBUM_ARTISTS, ID3v23FieldKey.ALBUM_ARTISTS);
        this.tagFieldToId3.put(FieldKey.ALBUM_ARTISTS_SORT, ID3v23FieldKey.ALBUM_ARTISTS_SORT);
        this.tagFieldToId3.put(FieldKey.ALBUM_SORT, ID3v23FieldKey.ALBUM_SORT);
        this.tagFieldToId3.put(FieldKey.ALBUM_YEAR, ID3v23FieldKey.ALBUM_YEAR);
        this.tagFieldToId3.put(FieldKey.AMAZON_ID, ID3v23FieldKey.AMAZON_ID);
        this.tagFieldToId3.put(FieldKey.ARRANGER, ID3v23FieldKey.ARRANGER);
        this.tagFieldToId3.put(FieldKey.ARRANGER_SORT, ID3v23FieldKey.ARRANGER_SORT);
        this.tagFieldToId3.put(FieldKey.ARTIST, ID3v23FieldKey.ARTIST);
        this.tagFieldToId3.put(FieldKey.ARTISTS, ID3v23FieldKey.ARTISTS);
        this.tagFieldToId3.put(FieldKey.ARTISTS_SORT, ID3v23FieldKey.ARTISTS_SORT);
        this.tagFieldToId3.put(FieldKey.ARTIST_SORT, ID3v23FieldKey.ARTIST_SORT);
        this.tagFieldToId3.put(FieldKey.BARCODE, ID3v23FieldKey.BARCODE);
        this.tagFieldToId3.put(FieldKey.BPM, ID3v23FieldKey.BPM);
        this.tagFieldToId3.put(FieldKey.CATALOG_NO, ID3v23FieldKey.CATALOG_NO);
        this.tagFieldToId3.put(FieldKey.CHOIR, ID3v23FieldKey.CHOIR);
        this.tagFieldToId3.put(FieldKey.CHOIR_SORT, ID3v23FieldKey.CHOIR_SORT);
        this.tagFieldToId3.put(FieldKey.CLASSICAL_CATALOG, ID3v23FieldKey.CLASSICAL_CATALOG);
        this.tagFieldToId3.put(FieldKey.CLASSICAL_NICKNAME, ID3v23FieldKey.CLASSICAL_NICKNAME);
        this.tagFieldToId3.put(FieldKey.COMMENT, ID3v23FieldKey.COMMENT);
        this.tagFieldToId3.put(FieldKey.COMPOSER, ID3v23FieldKey.COMPOSER);
        this.tagFieldToId3.put(FieldKey.COMPOSER_SORT, ID3v23FieldKey.COMPOSER_SORT);
        this.tagFieldToId3.put(FieldKey.CONDUCTOR, ID3v23FieldKey.CONDUCTOR);
        this.tagFieldToId3.put(FieldKey.CONDUCTOR_SORT, ID3v23FieldKey.CONDUCTOR_SORT);
        this.tagFieldToId3.put(FieldKey.COPYRIGHT, ID3v23FieldKey.COPYRIGHT);
        this.tagFieldToId3.put(FieldKey.COUNTRY, ID3v23FieldKey.COUNTRY);
        this.tagFieldToId3.put(FieldKey.COVER_ART, ID3v23FieldKey.COVER_ART);
        this.tagFieldToId3.put(FieldKey.CUSTOM1, ID3v23FieldKey.CUSTOM1);
        this.tagFieldToId3.put(FieldKey.CUSTOM2, ID3v23FieldKey.CUSTOM2);
        this.tagFieldToId3.put(FieldKey.CUSTOM3, ID3v23FieldKey.CUSTOM3);
        this.tagFieldToId3.put(FieldKey.CUSTOM4, ID3v23FieldKey.CUSTOM4);
        this.tagFieldToId3.put(FieldKey.CUSTOM5, ID3v23FieldKey.CUSTOM5);
        this.tagFieldToId3.put(FieldKey.DISC_NO, ID3v23FieldKey.DISC_NO);
        this.tagFieldToId3.put(FieldKey.DISC_SUBTITLE, ID3v23FieldKey.DISC_SUBTITLE);
        this.tagFieldToId3.put(FieldKey.DISC_TOTAL, ID3v23FieldKey.DISC_NO);
        this.tagFieldToId3.put(FieldKey.DJMIXER, ID3v23FieldKey.DJMIXER);
        this.tagFieldToId3.put(FieldKey.DJMIXER_SORT, ID3v23FieldKey.DJMIXER_SORT);
        this.tagFieldToId3.put(FieldKey.MOOD_ELECTRONIC, ID3v23FieldKey.MOOD_ELECTRONIC);
        this.tagFieldToId3.put(FieldKey.ENCODER, ID3v23FieldKey.ENCODER);
        this.tagFieldToId3.put(FieldKey.ENGINEER, ID3v23FieldKey.ENGINEER);
        this.tagFieldToId3.put(FieldKey.ENGINEER_SORT, ID3v23FieldKey.ENGINEER_SORT);
        this.tagFieldToId3.put(FieldKey.ENSEMBLE, ID3v23FieldKey.ENSEMBLE);
        this.tagFieldToId3.put(FieldKey.ENSEMBLE_SORT, ID3v23FieldKey.ENSEMBLE_SORT);
        this.tagFieldToId3.put(FieldKey.FBPM, ID3v23FieldKey.FBPM);
        this.tagFieldToId3.put(FieldKey.GENRE, ID3v23FieldKey.GENRE);
        this.tagFieldToId3.put(FieldKey.GROUP, ID3v23FieldKey.GROUP);
        this.tagFieldToId3.put(FieldKey.GROUPING, ID3v23FieldKey.GROUPING);
        this.tagFieldToId3.put(FieldKey.INSTRUMENT, ID3v23FieldKey.INSTRUMENT);
        this.tagFieldToId3.put(FieldKey.INVOLVEDPEOPLE, ID3v23FieldKey.INVOLVEDPEOPLE);
        this.tagFieldToId3.put(FieldKey.IPI, ID3v23FieldKey.IPI);
        this.tagFieldToId3.put(FieldKey.ISRC, ID3v23FieldKey.ISRC);
        this.tagFieldToId3.put(FieldKey.ISWC, ID3v23FieldKey.ISWC);
        this.tagFieldToId3.put(FieldKey.IS_CLASSICAL, ID3v23FieldKey.IS_CLASSICAL);
        this.tagFieldToId3.put(FieldKey.IS_COMPILATION, ID3v23FieldKey.IS_COMPILATION);
        this.tagFieldToId3.put(FieldKey.IS_GREATEST_HITS, ID3v23FieldKey.IS_GREATEST_HITS);
        this.tagFieldToId3.put(FieldKey.IS_HD, ID3v23FieldKey.IS_HD);
        this.tagFieldToId3.put(FieldKey.IS_LIVE, ID3v23FieldKey.IS_LIVE);
        this.tagFieldToId3.put(FieldKey.IS_SOUNDTRACK, ID3v23FieldKey.IS_SOUNDTRACK);
        this.tagFieldToId3.put(FieldKey.ITUNES_GROUPING, ID3v23FieldKey.ITUNES_GROUPING);
        this.tagFieldToId3.put(FieldKey.JAIKOZ_ID, ID3v23FieldKey.JAIKOZ_ID);
        this.tagFieldToId3.put(FieldKey.KEY, ID3v23FieldKey.KEY);
        this.tagFieldToId3.put(FieldKey.LANGUAGE, ID3v23FieldKey.LANGUAGE);
        this.tagFieldToId3.put(FieldKey.LYRICIST, ID3v23FieldKey.LYRICIST);
        this.tagFieldToId3.put(FieldKey.LYRICIST_SORT, ID3v23FieldKey.LYRICIST_SORT);
        this.tagFieldToId3.put(FieldKey.LYRICS, ID3v23FieldKey.LYRICS);
        this.tagFieldToId3.put(FieldKey.MEDIA, ID3v23FieldKey.MEDIA);
        this.tagFieldToId3.put(FieldKey.MIXER, ID3v23FieldKey.MIXER);
        this.tagFieldToId3.put(FieldKey.MIXER_SORT, ID3v23FieldKey.MIXER_SORT);
        this.tagFieldToId3.put(FieldKey.MOOD, ID3v23FieldKey.MOOD);
        this.tagFieldToId3.put(FieldKey.MOOD_ACOUSTIC, ID3v23FieldKey.MOOD_ACOUSTIC);
        this.tagFieldToId3.put(FieldKey.MOOD_AGGRESSIVE, ID3v23FieldKey.MOOD_AGGRESSIVE);
        this.tagFieldToId3.put(FieldKey.MOOD_AROUSAL, ID3v23FieldKey.MOOD_AROUSAL);
        this.tagFieldToId3.put(FieldKey.MOOD_DANCEABILITY, ID3v23FieldKey.MOOD_DANCEABILITY);
        this.tagFieldToId3.put(FieldKey.MOOD_HAPPY, ID3v23FieldKey.MOOD_HAPPY);
        this.tagFieldToId3.put(FieldKey.MOOD_INSTRUMENTAL, ID3v23FieldKey.MOOD_INSTRUMENTAL);
        this.tagFieldToId3.put(FieldKey.MOOD_PARTY, ID3v23FieldKey.MOOD_PARTY);
        this.tagFieldToId3.put(FieldKey.MOOD_RELAXED, ID3v23FieldKey.MOOD_RELAXED);
        this.tagFieldToId3.put(FieldKey.MOOD_SAD, ID3v23FieldKey.MOOD_SAD);
        this.tagFieldToId3.put(FieldKey.MOOD_VALENCE, ID3v23FieldKey.MOOD_VALENCE);
        this.tagFieldToId3.put(FieldKey.MOVEMENT, ID3v23FieldKey.MOVEMENT);
        this.tagFieldToId3.put(FieldKey.MOVEMENT_NO, ID3v23FieldKey.MOVEMENT_NO);
        this.tagFieldToId3.put(FieldKey.MOVEMENT_TOTAL, ID3v23FieldKey.MOVEMENT_TOTAL);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_ARTISTID, ID3v23FieldKey.MUSICBRAINZ_ARTISTID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_DISC_ID, ID3v23FieldKey.MUSICBRAINZ_DISC_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_ORIGINAL_RELEASE_ID, ID3v23FieldKey.MUSICBRAINZ_ORIGINAL_RELEASEID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASEARTISTID, ID3v23FieldKey.MUSICBRAINZ_RELEASEARTISTID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASEID, ID3v23FieldKey.MUSICBRAINZ_RELEASEID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_COUNTRY, ID3v23FieldKey.MUSICBRAINZ_RELEASE_COUNTRY);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_GROUP_ID, ID3v23FieldKey.MUSICBRAINZ_RELEASE_GROUP_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_STATUS, ID3v23FieldKey.MUSICBRAINZ_RELEASE_STATUS);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_TRACK_ID, ID3v23FieldKey.MUSICBRAINZ_RELEASE_TRACK_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RELEASE_TYPE, ID3v23FieldKey.MUSICBRAINZ_RELEASE_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_TRACK_ID, ID3v23FieldKey.MUSICBRAINZ_TRACK_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK, ID3v23FieldKey.MUSICBRAINZ_WORK);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_ID, ID3v23FieldKey.MUSICBRAINZ_WORK_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RECORDING_WORK_ID, ID3v23FieldKey.MUSICBRAINZ_RECORDING_WORK_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_ID, ID3v23FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_ID, ID3v23FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_ID, ID3v23FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_ID, ID3v23FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_ID, ID3v23FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_ID);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_ID, ID3v23FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_ID);
        this.tagFieldToId3.put(FieldKey.MUSICIP_ID, ID3v23FieldKey.MUSICIP_ID);
        this.tagFieldToId3.put(FieldKey.OCCASION, ID3v23FieldKey.OCCASION);
        this.tagFieldToId3.put(FieldKey.OPUS, ID3v23FieldKey.OPUS);
        this.tagFieldToId3.put(FieldKey.ORCHESTRA, ID3v23FieldKey.ORCHESTRA);
        this.tagFieldToId3.put(FieldKey.ORCHESTRA_SORT, ID3v23FieldKey.ORCHESTRA_SORT);
        this.tagFieldToId3.put(FieldKey.ORIGINAL_ALBUM, ID3v23FieldKey.ORIGINAL_ALBUM);
        this.tagFieldToId3.put(FieldKey.ORIGINALRELEASEDATE, ID3v23FieldKey.ORIGINALRELEASEDATE);
        this.tagFieldToId3.put(FieldKey.ORIGINAL_ARTIST, ID3v23FieldKey.ORIGINAL_ARTIST);
        this.tagFieldToId3.put(FieldKey.ORIGINAL_LYRICIST, ID3v23FieldKey.ORIGINAL_LYRICIST);
        this.tagFieldToId3.put(FieldKey.ORIGINAL_YEAR, ID3v23FieldKey.ORIGINAL_YEAR);
        this.tagFieldToId3.put(FieldKey.OVERALL_WORK, ID3v23FieldKey.OVERALL_WORK);
        this.tagFieldToId3.put(FieldKey.PART, ID3v23FieldKey.PART);
        this.tagFieldToId3.put(FieldKey.PART_NUMBER, ID3v23FieldKey.PART_NUMBER);
        this.tagFieldToId3.put(FieldKey.PART_TYPE, ID3v23FieldKey.PART_TYPE);
        this.tagFieldToId3.put(FieldKey.PERFORMER, ID3v23FieldKey.PERFORMER);
        this.tagFieldToId3.put(FieldKey.PERFORMER_NAME, ID3v23FieldKey.PERFORMER_NAME);
        this.tagFieldToId3.put(FieldKey.PERFORMER_NAME_SORT, ID3v23FieldKey.PERFORMER_NAME_SORT);
        this.tagFieldToId3.put(FieldKey.PERIOD, ID3v23FieldKey.PERIOD);
        this.tagFieldToId3.put(FieldKey.PRODUCER, ID3v23FieldKey.PRODUCER);
        this.tagFieldToId3.put(FieldKey.PRODUCER_SORT, ID3v23FieldKey.PRODUCER_SORT);
        this.tagFieldToId3.put(FieldKey.QUALITY, ID3v23FieldKey.QUALITY);
        this.tagFieldToId3.put(FieldKey.RANKING, ID3v23FieldKey.RANKING);
        this.tagFieldToId3.put(FieldKey.RATING, ID3v23FieldKey.RATING);
        this.tagFieldToId3.put(FieldKey.RECORD_LABEL, ID3v23FieldKey.RECORD_LABEL);
        this.tagFieldToId3.put(FieldKey.RECORDINGDATE, ID3v23FieldKey.RECORDINGDATE);
        this.tagFieldToId3.put(FieldKey.RECORDINGSTARTDATE, ID3v23FieldKey.RECORDINGSTARTDATE);
        this.tagFieldToId3.put(FieldKey.RECORDINGENDDATE, ID3v23FieldKey.RECORDINGENDDATE);
        this.tagFieldToId3.put(FieldKey.RECORDINGLOCATION, ID3v23FieldKey.RECORDINGLOCATION);
        this.tagFieldToId3.put(FieldKey.REMIXER, ID3v23FieldKey.REMIXER);
        this.tagFieldToId3.put(FieldKey.ROONALBUMTAG, ID3v23FieldKey.ROONALBUMTAG);
        this.tagFieldToId3.put(FieldKey.ROONTRACKTAG, ID3v23FieldKey.ROONTRACKTAG);
        this.tagFieldToId3.put(FieldKey.SCRIPT, ID3v23FieldKey.SCRIPT);
        this.tagFieldToId3.put(FieldKey.SECTION, ID3v23FieldKey.SECTION);
        this.tagFieldToId3.put(FieldKey.SINGLE_DISC_TRACK_NO, ID3v23FieldKey.SINGLE_DISC_TRACK_NO);
        this.tagFieldToId3.put(FieldKey.SONGKONG_ID, ID3v23FieldKey.SONGKONG_ID);
        this.tagFieldToId3.put(FieldKey.SUBTITLE, ID3v23FieldKey.SUBTITLE);
        this.tagFieldToId3.put(FieldKey.TAGS, ID3v23FieldKey.TAGS);
        this.tagFieldToId3.put(FieldKey.TEMPO, ID3v23FieldKey.TEMPO);
        this.tagFieldToId3.put(FieldKey.TIMBRE, ID3v23FieldKey.TIMBRE);
        this.tagFieldToId3.put(FieldKey.TITLE, ID3v23FieldKey.TITLE);
        this.tagFieldToId3.put(FieldKey.TITLE_MOVEMENT, ID3v23FieldKey.TITLE_MOVEMENT);
        this.tagFieldToId3.put(FieldKey.TITLE_SORT, ID3v23FieldKey.TITLE_SORT);
        this.tagFieldToId3.put(FieldKey.TONALITY, ID3v23FieldKey.TONALITY);
        this.tagFieldToId3.put(FieldKey.TRACK, ID3v23FieldKey.TRACK);
        this.tagFieldToId3.put(FieldKey.TRACK_TOTAL, ID3v23FieldKey.TRACK_TOTAL);
        this.tagFieldToId3.put(FieldKey.URL_DISCOGS_ARTIST_SITE, ID3v23FieldKey.URL_DISCOGS_ARTIST_SITE);
        this.tagFieldToId3.put(FieldKey.URL_DISCOGS_RELEASE_SITE, ID3v23FieldKey.URL_DISCOGS_RELEASE_SITE);
        this.tagFieldToId3.put(FieldKey.URL_LYRICS_SITE, ID3v23FieldKey.URL_LYRICS_SITE);
        this.tagFieldToId3.put(FieldKey.URL_OFFICIAL_ARTIST_SITE, ID3v23FieldKey.URL_OFFICIAL_ARTIST_SITE);
        this.tagFieldToId3.put(FieldKey.URL_OFFICIAL_RELEASE_SITE, ID3v23FieldKey.URL_OFFICIAL_RELEASE_SITE);
        this.tagFieldToId3.put(FieldKey.URL_WIKIPEDIA_ARTIST_SITE, ID3v23FieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        this.tagFieldToId3.put(FieldKey.URL_WIKIPEDIA_RELEASE_SITE, ID3v23FieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        this.tagFieldToId3.put(FieldKey.WORK, ID3v23FieldKey.WORK);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_RECORDING_WORK, ID3v23FieldKey.MUSICBRAINZ_RECORDING_WORK);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1, ID3v23FieldKey.WORK_PART_LEVEL1);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_TYPE, ID3v23FieldKey.WORK_PART_LEVEL1_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2, ID3v23FieldKey.WORK_PART_LEVEL2);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_TYPE, ID3v23FieldKey.WORK_PART_LEVEL2_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3, ID3v23FieldKey.WORK_PART_LEVEL3);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_TYPE, ID3v23FieldKey.WORK_PART_LEVEL3_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4, ID3v23FieldKey.WORK_PART_LEVEL4);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_TYPE, ID3v23FieldKey.WORK_PART_LEVEL4_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5, ID3v23FieldKey.WORK_PART_LEVEL5);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_TYPE, ID3v23FieldKey.WORK_PART_LEVEL5_TYPE);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6, ID3v23FieldKey.WORK_PART_LEVEL6);
        this.tagFieldToId3.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_TYPE, ID3v23FieldKey.WORK_PART_LEVEL6_TYPE);
        this.tagFieldToId3.put(FieldKey.VERSION, ID3v23FieldKey.VERSION);
        this.tagFieldToId3.put(FieldKey.WORK_TYPE, ID3v23FieldKey.WORK_TYPE);
        this.tagFieldToId3.put(FieldKey.YEAR, ID3v23FieldKey.YEAR);
        this.populateId3ToTagField();
    }

    private void populateId3ToTagField() {
        for (Map.Entry<FieldKey, ID3v23FieldKey> next : this.tagFieldToId3.entrySet()) {
            this.id3ToTagField.put(next.getValue(), next.getKey());
        }
    }

    @Override
    public void setITunes12_6WorkGroupingMode(boolean id3v2ITunes12_6Mode) {
        if (id3v2ITunes12_6Mode) {
            this.tagFieldToId3.put(FieldKey.WORK, ID3v23FieldKey.GROUPING);
            this.tagFieldToId3.put(FieldKey.GROUPING, ID3v23FieldKey.ITUNES_GROUPING);
        } else {
            this.tagFieldToId3.put(FieldKey.WORK, ID3v23FieldKey.WORK);
            this.tagFieldToId3.put(FieldKey.GROUPING, ID3v23FieldKey.GROUPING);
        }
        this.populateId3ToTagField();
    }

    public ID3v23FieldKey getId3KeyFromGenericKey(FieldKey genericKey) {
        return this.tagFieldToId3.get((Object)genericKey);
    }

    public FieldKey getGenericKeyFromId3(ID3v23FieldKey fieldKey) {
        return this.id3ToTagField.get((Object)fieldKey);
    }
}

