/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend.sources.waterplayer.lyrics;

import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LRCLyricsFormat
implements AudioLyrics {
    final AudioTrack track;
    List<AudioLyrics.Line> lines = new ArrayList<AudioLyrics.Line>();
    String text;

    public static boolean isLrcFormat(String text) {
        return text.replaceAll("^\\[(\\d*:\\d*\\.?\\d*)]", "").length() < text.length();
    }

    public LRCLyricsFormat(AudioTrack track, String text) {
        this.track = track;
        this.lines = new ArrayList<AudioLyrics.Line>();
        String[] sLines = text.split("\\n");
        StringBuilder builderText = new StringBuilder();
        String line = "";
        long start = 0L;
        long duration = 0L;
        for (int i = 0; i < sLines.length; ++i) {
            String cleanLine = sLines[i].replaceAll("^\\[(\\d*:\\d*\\.?\\d*)]", "");
            if (cleanLine.isBlank()) {
                cleanLine = "\ud83c\udfb5";
            }
            if (i != 0) {
                builderText.append("\n");
            }
            builderText.append(cleanLine);
            String time = sLines[i].replace(cleanLine, "").replaceAll("[\\[\\]]", "");
            if (i > 0) {
                duration = this.parseLrcTime(time) - start;
                finalStart = start;
                finalDuration = duration;
                finalLine = line;
                this.lines.add(new AudioLyrics.Line(){

                    @Override
                    @NotNull
                    public Duration getTimestamp() {
                        return Duration.ofMillis(finalStart);
                    }

                    @Override
                    @Nullable
                    public Duration getDuration() {
                        return Duration.ofMillis(finalDuration);
                    }

                    @Override
                    @NotNull
                    public String getLine() {
                        return finalLine;
                    }
                });
            } else if (i == sLines.length - 1) {
                duration = track.getDuration() - this.parseLrcTime(time);
                finalStart = this.parseLrcTime(time);
                finalDuration = duration;
                finalLine = cleanLine;
                this.lines.add(new AudioLyrics.Line(){

                    @Override
                    @NotNull
                    public Duration getTimestamp() {
                        return Duration.ofMillis(finalStart);
                    }

                    @Override
                    @Nullable
                    public Duration getDuration() {
                        return Duration.ofMillis(finalDuration);
                    }

                    @Override
                    @NotNull
                    public String getLine() {
                        return finalLine;
                    }
                });
            }
            line = cleanLine;
            start = this.parseLrcTime(time);
        }
        this.text = builderText.toString();
    }

    public long parseLrcTime(String time) {
        String[] splitTile = time.split(":");
        long tdl = 0L;
        tdl += (long)Integer.parseInt(splitTile[0]) * 60L * 1000L;
        tdl += (long)Integer.parseInt(splitTile[1].split("\\.")[0]) * 1000L;
        return tdl += (long)(Double.parseDouble(splitTile[1].split("\\.")[1]) / 100.0 * 1000.0);
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "lrc-file";
    }

    @Override
    @Nullable
    public String getProvider() {
        return this.track.getSourceManager().getSourceName();
    }

    @Override
    @Nullable
    public String getText() {
        return this.text;
    }

    @Override
    @Nullable
    public List<AudioLyrics.Line> getLines() {
        return this.lines;
    }
}

