/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.components;

import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.playlist.Playlist;
import ru.kelcuprum.waterplayer.backend.playlist.WebPlaylist;
import ru.kelcuprum.waterplayer.frontend.gui.TextureHelper;
import ru.kelcuprum.waterplayer.frontend.gui.screens.playlist.ViewPlaylistScreen;

public class PlaylistButton
extends Button {
    protected final Playlist playlist;
    protected WebPlaylist webPlaylist = null;

    public PlaylistButton(int x, int y, int width, WebPlaylist webPlaylist, class_437 screen) {
        this(x, y, width, webPlaylist.playlist, screen);
        this.webPlaylist = webPlaylist;
    }

    public PlaylistButton(int x, int y, int width, Playlist playlist, class_437 screen) {
        super(new ButtonBuilder().setTitle((class_2561)class_2561.method_43473()).setStyle(GuiUtils.getSelected()).setSize(width, playlist.icon == null ? 20 : 40).setPosition(x, y));
        ((ButtonBuilder)this.builder).setOnPress(s -> {
            class_437 parent = screen;
            if (this.webPlaylist == null) {
                AlinLib.MINECRAFT.method_1507((class_437)new ViewPlaylistScreen(parent, playlist));
            } else {
                AlinLib.MINECRAFT.method_1507((class_437)new ViewPlaylistScreen(parent, this.webPlaylist));
            }
        });
        this.playlist = playlist;
        StringBuilder builder = new StringBuilder();
        builder.append(class_2561.method_43469((String)"waterplayer.playlists.value", (Object[])new Object[]{playlist.title, playlist.author}).getString()).append(" ").append(this.webPlaylist == null ? String.format("playlist:%s", playlist.fileName) : String.format("wplayer:%s", this.webPlaylist.url));
        this.method_25355((class_2561)class_2561.method_43470((String)builder.toString()));
    }

    public void renderText(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.method_46427() < guiGraphics.method_51443() && this.method_46427() > -this.method_25364()) {
            String type;
            StringBuilder builder = new StringBuilder();
            builder.append(class_2561.method_43469((String)"waterplayer.playlists.value", (Object[])new Object[]{this.playlist.title, this.playlist.author}).getString());
            String string = type = this.webPlaylist == null ? String.format("playlist:%s", this.playlist.fileName) : String.format("wplayer:%s", this.webPlaylist.url);
            if (this.playlist.icon == null) {
                if (GuiUtils.isDoesNotFit((class_2561)this.method_25369(), (Number)this.method_25368(), (Number)this.method_25364())) {
                    this.method_49604(guiGraphics, AlinLib.MINECRAFT.field_1772, 2, 0xFFFFFF);
                } else {
                    guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, builder.toString(), this.method_46426() + (this.method_25364() - 8) / 2, this.method_46427() + (this.method_25364() - 8) / 2, 0xFFFFFF);
                    guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, type, this.method_46426() + this.method_25368() - AlinLib.MINECRAFT.field_1772.method_1727(type) - (this.method_25364() - 8) / 2, this.method_46427() + (this.method_25364() - 8) / 2, 0xFFFFFF);
                }
            } else {
                guiGraphics.method_25290(class_10799.field_56883, this.getIcon(), this.method_46426() + 4, this.method_46427() + 4, 0.0f, 0.0f, 32, 32, 32, 32);
                this.renderString(guiGraphics, builder.toString(), this.method_46426() + 45, this.method_46427() + 8);
                int n = this.method_46426() + 45;
                int n2 = this.method_46427() + this.field_22759 - 8;
                Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                this.renderString(guiGraphics, type, n, n2 - 9);
            }
        }
    }

    public class_2960 getIcon() {
        if (this.playlist == null) {
            return WaterPlayer.Icons.NO_PLAYLIST_ICON;
        }
        return this.playlist.icon == null ? WaterPlayer.Icons.NO_PLAYLIST_ICON : TextureHelper.getTexture$Base64(this.playlist.icon, this.webPlaylist == null ? String.format("playlist-%s", this.playlist.fileName) : String.format("webplaylist-%s", this.webPlaylist.url));
    }

    protected void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 message, int x, int y, int color) {
        int k = this.method_46426() + x;
        int l = this.method_46426() + this.method_25368() - x;
        if (this.playlist.icon != null) {
            k += 40;
        }
        Objects.requireNonNull(font);
        PlaylistButton.method_52718((class_332)guiGraphics, (class_327)font, (class_2561)message, (int)k, (int)y, (int)l, (int)(y + 9), (int)color);
    }

    protected void renderString(class_332 guiGraphics, String text, int x, int y) {
        if (this.method_25368() - 50 < AlinLib.MINECRAFT.field_1772.method_1727(text)) {
            this.renderScrollingString(guiGraphics, AlinLib.MINECRAFT.field_1772, (class_2561)class_2561.method_43470((String)text), 5, y - 1, -1);
        } else {
            guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, text, x, y, -1);
        }
    }
}

