/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.components;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.frontend.gui.screens.TrackScreen;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;

public class TrackButton
extends Button {
    protected AudioTrack track;
    private final boolean isShort;

    public TrackButton(int x, int y, int width, AudioTrack track, class_437 screen, boolean isShort) {
        super(new ButtonBuilder().setOnPress(s -> AlinLib.MINECRAFT.method_1507((class_437)new TrackScreen(screen, track))).setTitle((class_2561)class_2561.method_43473()).setStyle(GuiUtils.getSelected()).setSize(width, isShort ? 20 : 40).setPosition(x, y));
        StringBuilder builder = new StringBuilder();
        if (!MusicHelper.isAuthorNull(track)) {
            builder.append(MusicHelper.getAuthor(track)).append(" - ");
        }
        builder.append(MusicHelper.getTitle(track)).append(" ").append(WaterPlayer.getTimestamp(MusicHelper.getDuration(track)));
        this.method_25355((class_2561)class_2561.method_43470((String)builder.toString()));
        this.isShort = isShort;
        this.track = track;
    }

    public void renderText(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.method_46427() < guiGraphics.method_51443() && this.method_46427() > -this.method_25364()) {
            String time;
            StringBuilder builder = new StringBuilder();
            if (!MusicHelper.isAuthorNull(this.track)) {
                builder.append(MusicHelper.getAuthor(this.track)).append(" - ");
            }
            builder.append(MusicHelper.getTitle(this.track));
            String string = time = this.track.getInfo().isStream ? WaterPlayer.localization.getLocalization("format.live") : WaterPlayer.getTimestamp(MusicHelper.getDuration(this.track));
            if (this.isShort) {
                if (GuiUtils.isDoesNotFit((class_2561)this.method_25369(), (Number)this.method_25368(), (Number)this.method_25364())) {
                    this.method_49604(guiGraphics, AlinLib.MINECRAFT.field_1772, 2, 0xFFFFFF);
                } else {
                    guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, builder.toString(), this.method_46426() + (this.method_25364() - 8) / 2, this.method_46427() + (this.method_25364() - 8) / 2, 0xFFFFFF);
                    guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, time, this.method_46426() + this.method_25368() - AlinLib.MINECRAFT.field_1772.method_1727(time) - (this.method_25364() - 8) / 2, this.method_46427() + (this.method_25364() - 8) / 2, 0xFFFFFF);
                }
            } else {
                class_2960 icon = MusicHelper.getThumbnail(this.track);
                guiGraphics.method_25290(class_10799.field_56883, icon, this.method_46426() + 4, this.method_46427() + 4, 0.0f, 0.0f, 32, 32, 32, 32);
                this.renderString(guiGraphics, builder.toString(), this.method_46426() + 45, this.method_46427() + 8);
                String string2 = time + " | " + MusicHelper.getServiceName(MusicHelper.getService(this.track)).getString();
                int n = this.method_46426() + 45;
                int n2 = this.method_46427() + this.field_22759 - 8;
                Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                this.renderString(guiGraphics, string2, n, n2 - 9);
            }
        }
    }

    protected void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 message, int y) {
        int k = this.method_46426() + 5;
        int l = this.method_46426() + this.method_25368() - 5;
        if (!this.isShort) {
            k += 40;
        }
        Objects.requireNonNull(font);
        TrackButton.method_52718((class_332)guiGraphics, (class_327)font, (class_2561)message, (int)k, (int)y, (int)l, (int)(y + 9), (int)-1);
    }

    protected void renderString(class_332 guiGraphics, String text, int x, int y) {
        if (this.method_25368() - 50 < AlinLib.MINECRAFT.field_1772.method_1727(text)) {
            this.renderScrollingString(guiGraphics, AlinLib.MINECRAFT.field_1772, (class_2561)class_2561.method_43470((String)text), y - 1);
        } else {
            guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, text, x, y, -1);
        }
    }
}

