/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.screens.playlist;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.components.ConfigureScrolWidget;
import ru.kelcuprum.alinlib.gui.components.ImageWidget;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.alinlib.gui.components.text.TextBox;
import ru.kelcuprum.alinlib.gui.screens.AbstractConfigScreen;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.MusicPlayer;
import ru.kelcuprum.waterplayer.backend.WaterPlayerAPI;
import ru.kelcuprum.waterplayer.backend.exception.WebPlaylistException;
import ru.kelcuprum.waterplayer.backend.playlist.Playlist;
import ru.kelcuprum.waterplayer.backend.playlist.WebPlaylist;
import ru.kelcuprum.waterplayer.backend.queue.PlaylistQueue;
import ru.kelcuprum.waterplayer.frontend.gui.TextureHelper;
import ru.kelcuprum.waterplayer.frontend.gui.components.TrackButton;
import ru.kelcuprum.waterplayer.frontend.gui.screens.config.PlaylistsScreen;
import ru.kelcuprum.waterplayer.frontend.gui.screens.playlist.ConfirmDeletePlaylist;
import ru.kelcuprum.waterplayer.frontend.gui.screens.playlist.EditPlaylistScreen;

public class ViewPlaylistScreen
extends class_437 {
    @NotNull
    protected final Playlist playlist;
    protected WebPlaylist webPlaylist;
    private List<class_339> trackWidgets = new ArrayList<class_339>();
    public final class_437 parent;
    boolean isCreatedLink = false;
    String link = "";
    boolean isEnable = false;
    boolean isInit = false;
    public Button upload;
    public ImageWidget icon;
    public int maxY = 35;
    private ConfigureScrolWidget scroller;
    private List<class_339> widgets = new ArrayList<class_339>();
    private TextBox emptyTracks;
    public static MusicPlayer searchPlayer = new MusicPlayer();
    public class_2960 lastIcon = this.getIcon();
    List<class_339> lastTracks = new ArrayList<class_339>();
    private int lastSize = 0;

    public ViewPlaylistScreen(class_437 parent, WebPlaylist webPlaylist) {
        this(parent, webPlaylist.playlist);
        this.webPlaylist = webPlaylist;
        this.isCreatedLink = true;
        this.link = String.format(WaterPlayerAPI.config.getString("PLAYLIST_URL", WaterPlayerAPI.getURL("/playlist/%s")), webPlaylist.url);
    }

    public ViewPlaylistScreen(class_437 parent, @NotNull Playlist playlist) {
        super((class_2561)class_2561.method_43473());
        this.playlist = playlist;
        this.parent = parent;
    }

    protected void method_25426() {
        this.initPanel();
        this.initTracks();
        if (!this.isInit) {
            this.isInit = true;
            if (this.isCreatedLink) {
                this.isEnable = true;
            } else {
                new Thread(() -> {
                    this.isEnable = WaterPlayerAPI.isPlaylistUploadEnable();
                }).start();
            }
            new Thread(() -> {
                this.trackWidgets = this.getTrackWidgets(this.playlist);
            }).start();
        }
    }

    public void initPanel() {
        int x = 10;
        int size = 200;
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)(this.webPlaylist == null ? "waterplayer.playlist" : "waterplayer.playlist.web"))).setPosition(x, 5).setSize(size, 20).build());
        int y = 35;
        this.icon = (ImageWidget)this.method_37063((class_364)new ImageWidget(x, y, 36, 36, this.getIcon(), 36, 36, (class_2561)class_2561.method_43473()));
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43470((String)this.playlist.title)).setAlign(TextBuilder.ALIGN.LEFT).setPosition(x + 41, y).setSize(size - 41, 18).build());
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43470((String)this.playlist.author)).setAlign(TextBuilder.ALIGN.LEFT).setPosition(x + 41, y + 18).setSize(size - 41, 18).build());
        y += 41;
        if (this.webPlaylist == null) {
            this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.edit_button"), e -> {
                this.isEnable = false;
                this.isInit = false;
                this.trackWidgets = new ArrayList<class_339>();
                AlinLib.MINECRAFT.method_1507((class_437)new EditPlaylistScreen(this, this.playlist));
            }).setPosition(x, y).setSize(size, 20).build());
        } else {
            this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.save"), s -> {
                try {
                    this.webPlaylist.save();
                }
                catch (WebPlaylistException e) {
                    e.printStackTrace();
                    WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43470((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()))).setType(ToastBuilder.Type.ERROR).buildAndShow();
                }
                AlinLib.MINECRAFT.method_1507((class_437)new ViewPlaylistScreen(this.parent, this.playlist));
            }).setPosition(x, y).setSize(size, 20).build());
            if (WaterPlayerAPI.isModerator()) {
                this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.web.delete"), s -> this.field_22787.method_1507((class_437)new ConfirmDeletePlaylist(this, this.webPlaylist, b -> this.method_25419()))).setPosition(x, y += 25).setSize(size, 20).build());
            }
        }
        y += 25;
        if (this.playlist.isPublic.booleanValue()) {
            TextBox box = (TextBox)this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.upload.public.description"), s -> WaterPlayer.confirmLinkNow(this, "https://waterplayer.ru/docs/info")).setType(TextBuilder.TYPE.MESSAGE).setAlign(TextBuilder.ALIGN.CENTER).setPosition(x, y).setSize(size, 20).build());
            y += box.method_25364() + 5;
        }
        this.upload = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)(this.isCreatedLink ? "waterplayer.playlist.copy_link" : "waterplayer.playlist.upload")), e -> new Thread(() -> {
            if (this.isCreatedLink) {
                AlinLib.MINECRAFT.field_1774.method_1455(this.link);
                WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43471((String)"waterplayer.playlist.link_copied")).buildAndShow();
            } else {
                try {
                    this.link = WaterPlayerAPI.uploadPlaylist(this.playlist, this.playlist.fileName);
                    AlinLib.MINECRAFT.field_1774.method_1455(this.link);
                    this.isCreatedLink = true;
                    WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43471((String)"waterplayer.playlist.uploaded")).buildAndShow();
                    e.builder.setTitle((class_2561)class_2561.method_43471((String)"waterplayer.playlist.copy_link"));
                }
                catch (Exception ex) {
                    this.isEnable = false;
                    e.builder.setTitle((class_2561)class_2561.method_43471((String)"waterplayer.playlist.upload.unavailable"));
                    String msg = ex.getMessage() == null ? e.getClass().getName() : ex.getMessage();
                    WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43470((String)msg)).setType(ToastBuilder.Type.ERROR).setIcon(Icons.DONT).buildAndShow();
                    WaterPlayer.log(msg, Level.ERROR);
                }
            }
        }).start()).setPosition(x, y).setSize(size, 20).setActive(false).build());
        this.method_37063((class_364)new ButtonBuilder(class_5244.field_24339, e -> this.method_25419()).setPosition(x, y += 25).setSize(size - 25, 20).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.play"), s -> new Thread(() -> WaterPlayer.player.getTrackScheduler().changeQueue(new PlaylistQueue(this.playlist))).start()).setSprite(WaterPlayer.Icons.PLAY).setPosition(x + size - 20, y).setSize(20, 20).build());
        this.maxY = y += 25;
    }

    public void initTracks() {
        this.widgets = new ArrayList<class_339>();
        this.scroller = (ConfigureScrolWidget)this.method_37063((class_364)new ConfigureScrolWidget(this.field_22789 - 4, 0, 4, this.field_22790, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 5;
            for (class_339 widget : this.widgets) {
                if (widget.field_22764) {
                    widget.method_46419((int)((double)scroller.innerHeight - scroller.scrollAmount()));
                    scroller.innerHeight += widget.method_25364() + 5;
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
        }));
        int x = 220;
        this.widgets.add(new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.tracks")).setPosition(x, 5).setSize(this.field_22789 - 225, 20).build());
        int i = 30;
        for (class_339 element : this.trackWidgets) {
            element.method_48229(x, i);
            element.method_25358(this.field_22789 - 225);
            this.widgets.add(element);
            i += element.method_25364() + 5;
        }
        this.emptyTracks = (TextBox)this.method_25429((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.is_empty")).setPosition(x, 76).setSize(this.field_22789 - 225, 20).build());
        this.emptyTracks.setActive(false);
        this.emptyTracks.field_22764 = this.isClownfishMoment();
        this.addRenderableWidgets(this.widgets);
    }

    protected void addRenderableWidgets(@NotNull List<class_339> widgets) {
        for (class_339 widget : widgets) {
            this.method_37063((class_364)widget);
        }
    }

    public boolean isClownfishMoment() {
        return this.playlist.urls.isEmpty();
    }

    public List<class_339> getTrackWidgets(Playlist playlist) {
        final ArrayList<class_339> trackWidgets = new ArrayList<class_339>();
        for (final String url : playlist.urls) {
            final ViewPlaylistScreen thisScreen = this;
            if (url.isBlank()) continue;
            searchPlayer.getAudioPlayerManager().loadItemSync(url, new AudioLoadResultHandler(){

                @Override
                public void trackLoaded(AudioTrack track) {
                    trackWidgets.add(new TrackButton(195, -50, ViewPlaylistScreen.this.field_22789 - 200, track, thisScreen, false));
                }

                @Override
                public void playlistLoaded(AudioPlaylist playlist) {
                    for (AudioTrack track : playlist.getTracks()) {
                        trackWidgets.add(new TrackButton(195, -50, ViewPlaylistScreen.this.field_22789 - 200, track, thisScreen, false));
                    }
                }

                @Override
                public void noMatches() {
                    trackWidgets.add(new ButtonBuilder((class_2561)class_2561.method_43470((String)url)).setOnPress(s -> WaterPlayer.confirmLinkNow(thisScreen, url)).setCentered(false).setIcon(WaterPlayer.Icons.MUSIC).setPosition(195, -50).setWidth(ViewPlaylistScreen.this.field_22789 - 200).build());
                    WaterPlayer.log("Nothing Found by " + url, Level.WARN);
                }

                @Override
                public void loadFailed(FriendlyException ex) {
                    trackWidgets.add(new ButtonBuilder((class_2561)class_2561.method_43470((String)url)).setOnPress(s -> WaterPlayer.confirmLinkNow(thisScreen, url)).setCentered(false).setIcon(WaterPlayer.Icons.MUSIC).setPosition(195, -50).setWidth(ViewPlaylistScreen.this.field_22789 - 200).build());
                    WaterPlayer.log("ERROR: " + (ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage()), Level.DEBUG);
                }
            });
        }
        return trackWidgets;
    }

    public class_2960 getIcon() {
        if (this.playlist == null) {
            return WaterPlayer.Icons.NO_PLAYLIST_ICON;
        }
        return this.playlist.icon == null ? WaterPlayer.Icons.NO_PLAYLIST_ICON : TextureHelper.getTexture$Base64(this.playlist.icon, this.webPlaylist == null ? String.format("playlist-%s", this.playlist.fileName) : String.format("webplaylist-%s", this.webPlaylist.url));
    }

    public void method_25393() {
        this.emptyTracks.setActive(this.isClownfishMoment());
        if (this.lastIcon != this.getIcon()) {
            this.lastIcon = this.getIcon();
            this.method_37066((class_364)this.icon);
            this.icon = (ImageWidget)this.method_37063((class_364)new ImageWidget(10, 35, 36, 36, this.getIcon(), 36, 36, (class_2561)class_2561.method_43473()));
        }
        if (this.scroller != null) {
            this.scroller.onScroll.accept(this.scroller);
        }
        if (this.isEnable) {
            this.upload.setActive(true);
            this.upload.method_25355((class_2561)class_2561.method_43471((String)(this.isCreatedLink ? "waterplayer.playlist.copy_link" : "waterplayer.playlist.upload")));
        } else {
            this.upload.setActive(false);
            this.upload.method_25355((class_2561)class_2561.method_43471((String)"waterplayer.playlist.upload.unavailable"));
        }
        if (this.lastTracks != this.trackWidgets) {
            this.lastTracks = this.trackWidgets;
            this.rebuildWidgetsList();
        }
        if (!(this.lastSize == this.playlist.getUrlsJSON().size() || this.method_25399() != null && this.method_25399().method_25370() && this.method_25399() instanceof class_342)) {
            new Thread(() -> {
                this.trackWidgets = this.getTrackWidgets(this.playlist);
            }).start();
            this.lastSize = this.playlist.getUrlsJSON().size();
            this.rebuildWidgetsList();
        }
        super.method_25393();
    }

    protected void rebuildWidgetsList() {
        this.method_37066((class_364)this.scroller);
        this.scroller = null;
        for (class_339 widget : this.widgets) {
            this.method_37066((class_364)widget);
        }
        this.initTracks();
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        super.method_25420(guiGraphics, i, j, f);
        if (this.isClownfishMoment()) {
            int clownfishSize = Math.min(this.field_22790 - 96, this.field_22789 - 230);
            guiGraphics.method_25290(class_10799.field_56883, Icons.CLOWNFISH, 220, this.field_22790 - clownfishSize, 0.0f, 0.0f, clownfishSize, clownfishSize, clownfishSize, clownfishSize);
        }
        GuiUtils.getSelected().renderTitleBackground(guiGraphics, 5, 5, 215, 25);
        GuiUtils.getSelected().renderBackground(guiGraphics, 5, 30, 215, this.maxY);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        if (this.isClownfishMoment()) {
            this.emptyTracks.method_25394(guiGraphics, i, j, f);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean scr = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (!scr && this.scroller != null) {
            scr = this.scroller.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return scr;
    }

    public void method_25419() {
        if (this.parent instanceof AbstractConfigScreen) {
            PlaylistsScreen.assetsSize = 0;
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 256 && this.method_25399() != null && this.method_25399().method_25370()) {
            this.method_25399().method_25365(false);
            return true;
        }
        return super.method_25404(i, j, k);
    }
}

