/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.rpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.ActivityType;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.Packet;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.User;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.WaterPlayerAPI;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;

public class DiscordIntegration {
    public static IPCClient client;
    public static RichPresence lastPresence;
    public static boolean connected;
    public static boolean empty;
    private static final Timer TIMER;
    private static String lastException;
    public HashMap<String, JsonObject> urls = new HashMap();
    public long lastUpdate = 0L;

    public DiscordIntegration() {
        TIMER.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                block2: {
                    try {
                        DiscordIntegration.this.update();
                    }
                    catch (Exception ex) {
                        if (lastException != null && lastException.equals(ex.getMessage())) break block2;
                        lastException = ex.getMessage();
                        WaterPlayer.log(ex.getLocalizedMessage(), Level.ERROR);
                        RichPresence.Builder presence = new RichPresence.Builder().setActivityType(ActivityType.Competing).setDetails("There was an error").setState("Check the logs & send a report").setLargeImage("https://wf.kelcu.ru/mods/waterplayer/icons/seadrive.gif");
                        if (!connected) break block2;
                        DiscordIntegration.this.send(presence.build());
                    }
                }
            }
        }, 250L, 250L);
    }

    public void registerApplication() {
        client = new IPCClient(1197963953695903794L);
        this.setupListener();
        try {
            client.connect(new DiscordBuild[0]);
        }
        catch (Exception ex) {
            WaterPlayer.log(ex.getLocalizedMessage(), Level.ERROR);
        }
    }

    public void exitApplication() {
        if (connected) {
            client.close();
        }
    }

    public void setupListener() {
        client.setListener(new IPCListener(this){

            @Override
            public void onPacketSent(IPCClient ipcClient, Packet packet) {
            }

            @Override
            public void onPacketReceived(IPCClient ipcClient, Packet packet) {
            }

            @Override
            public void onActivityJoin(IPCClient ipcClient, String s) {
            }

            @Override
            public void onActivitySpectate(IPCClient ipcClient, String s) {
            }

            @Override
            public void onActivityJoinRequest(IPCClient ipcClient, String s, User user) {
            }

            @Override
            public void onReady(IPCClient client) {
                WaterPlayer.log("The mod has been connected to Discord", Level.DEBUG);
                connected = true;
            }

            @Override
            public void onClose(IPCClient ipcClient, JsonObject jsonObject) {
                connected = false;
            }

            @Override
            public void onDisconnect(IPCClient ipcClient, Throwable throwable) {
                WaterPlayer.log("The mod has been pulled from Discord", Level.DEBUG);
                WaterPlayer.log(String.format("Reason: %s", throwable.getLocalizedMessage()), Level.DEBUG);
                connected = false;
            }
        });
    }

    public void update() {
        AudioTrack track = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
        if (track == null || !WaterPlayer.config.getBoolean("DISCORD", false) || WaterPlayer.player.getAudioPlayer().isPaused() && WaterPlayer.config.getBoolean("DISCORD.HIDE_IN_PAUSE", false)) {
            this.send(null);
        } else {
            String apiIcon;
            String icon;
            RichPresence.Builder builder = new RichPresence.Builder().setActivityType(ActivityType.Listening);
            String string = MusicHelper.isFile() ? "file" : (icon = track.getInfo().artworkUrl == null || track.getInfo().artworkUrl.isBlank() ? "no_icon" : track.getInfo().artworkUrl);
            if (!MusicHelper.isAuthorNull(track) && !MusicHelper.isTitleNull(track) && MusicHelper.isFile(track) && !(apiIcon = WaterPlayerAPI.getArtwork(track)).isBlank()) {
                icon = apiIcon;
            }
            builder.setLargeImage(icon, this.getLargeImageText(track)).setDetails(MusicHelper.getTitle()).setState(MusicHelper.getAuthor());
            this.getYonKaGorMoment(track, builder);
            long start = System.currentTimeMillis() - MusicHelper.getPosition();
            if (WaterPlayer.player.getAudioPlayer().isPaused()) {
                builder.setSmallImage("paused");
            } else {
                if (!MusicHelper.isAuthorNull(track) && WaterPlayer.config.getBoolean("DISCORD.AUTHOR_AVATAR", true)) {
                    String apiIcon2 = WaterPlayerAPI.getAuthorAvatar(track);
                    if (!apiIcon2.isBlank() && (icon.equalsIgnoreCase("file") || icon.equalsIgnoreCase("no_icon"))) {
                        builder.setLargeImage(apiIcon2, this.getLargeImageText(track));
                    } else if (!apiIcon2.isBlank() && !apiIcon2.equals(icon)) {
                        builder.setSmallImage(apiIcon2, MusicHelper.getAuthor(track));
                    }
                }
                if (WaterPlayer.config.getBoolean("DISCORD.TIME", true)) {
                    builder.setStartTimestamp(this.parseSeconds(start));
                    if (!MusicHelper.getIsLive()) {
                        builder.setEndTimestamp(this.parseSeconds(start + MusicHelper.getDuration()));
                    }
                }
            }
            if (!MusicHelper.isFile(track) && WaterPlayer.config.getBoolean("DISCORD.BUTTON", true)) {
                JsonArray buttons = new JsonArray();
                JsonObject button = new JsonObject();
                button.addProperty("label", MusicHelper.getServiceName(MusicHelper.getService(track)).getString());
                button.addProperty("url", track.getInfo().uri);
                buttons.add(button);
                builder.setButtons(buttons);
            }
            this.send(builder.build());
        }
    }

    public long parseSeconds(long mills) {
        return (mills - mills % 1000L) / 1000L;
    }

    public void send(RichPresence presence) {
        if (!empty && connected && presence == null) {
            if (lastPresence != null) {
                this.exitApplication();
            }
            lastPresence = null;
            empty = true;
        } else if (!(presence == null || lastPresence != null && lastPresence.toJson().toString().equalsIgnoreCase(presence.toJson().toString()) || System.currentTimeMillis() - this.lastUpdate <= 2500L)) {
            if (empty) {
                this.registerApplication();
            }
            empty = false;
            try {
                if (connected) {
                    client.sendRichPresence(presence);
                }
                lastPresence = presence;
                this.lastUpdate = System.currentTimeMillis();
            }
            catch (Exception ex) {
                WaterPlayer.log(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage(), Level.ERROR);
            }
        }
    }

    protected String getLargeImageText(AudioTrack track) {
        JsonObject trackInfo = WaterPlayerAPI.getTrackInfo(track, false);
        String album = "";
        if (trackInfo.has("track") && WaterPlayer.config.getBoolean("DISCORD.ALBUM", true)) {
            JsonObject info = trackInfo.getAsJsonObject("track");
            String string = album = info.has("album") ? info.get("album").getAsString() : "";
            if (album.equalsIgnoreCase(info.get("title").getAsString())) {
                album = "";
            }
        }
        return WaterPlayer.config.getBoolean("DISCORD.SERVICE", false) ? MusicHelper.getServiceName(MusicHelper.getService(track)).getString() : album;
    }

    protected void getYonKaGorMoment(AudioTrack track, RichPresence.Builder builder) {
        if (!MusicHelper.getAuthor(track).equals("YonKaGor") || !WaterPlayer.config.getBoolean("DISCORD.YONKACATS", true)) {
            return;
        }
        switch (MusicHelper.getTitle(track)) {
            case "Top 10 Things to Do Before You Die": 
            case "Top 10 Things To Do Before You Die": 
            case "[TW] Top 10 Things To Do Before You Die (Censored)": {
                builder.setLargeImage("https://wf.kelcu.ru/mods/waterplayer/icons/seadrive.gif", "HowTo: be happy \ud83d\udd0d");
                break;
            }
            case "You're Just Like Pop Music": {
                builder.setLargeImage("https://wf.kelcu.ru/mods/waterplayer/icons/tetra.gif", this.getLargeImageText(track));
                break;
            }
            case "Circus Hop": 
            case "Circus Hop [TW]": {
                builder.setLargeImage("https://wf.kelcu.ru/mods/waterplayer/icons/clownfish.png", this.getLargeImageText(track));
            }
        }
    }

    static {
        connected = false;
        empty = true;
        TIMER = new Timer();
    }
}

