/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.lowpass;

import com.github.natanbc.lavadsp.Converter;

public class LowPassConverter
implements Converter {
    private float smoothing = 20.0f;
    private float value;
    private boolean initialized;

    public void setSmoothing(float smoothing) {
        this.smoothing = smoothing;
    }

    public void onSeek() {
        this.initialized = false;
    }

    @Override
    public void process(float[] input, int inputOffset, float[] output, int outputOffset, int samples) {
        if (!this.initialized) {
            this.value = input[inputOffset];
            this.initialized = true;
        }
        for (int i = 0; i < samples; ++i) {
            float current = input[i + inputOffset];
            this.value += (current - this.value) / this.smoothing;
            output[i + outputOffset] = this.value;
        }
    }
}

