/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.timescale;

import com.github.natanbc.lavadsp.natives.TimescaleConverter;
import com.github.natanbc.lavadsp.timescale.Setting;
import com.github.natanbc.lavadsp.util.DoubleToDoubleFunction;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public class TimescalePcmAudioFilter
implements FloatPcmAudioFilter {
    private static final int BUFFER_SIZE = 4096;
    private final FloatPcmAudioFilter downstream;
    private final TimescaleConverter[] converters;
    private final float[][] outputSegments;
    private volatile double speed;
    private volatile double pitch;
    private volatile double rate;

    public TimescalePcmAudioFilter(FloatPcmAudioFilter downstream, int channels, int sampleRate) {
        this.downstream = downstream;
        this.converters = new TimescaleConverter[channels];
        this.outputSegments = new float[channels][];
        this.speed = 1.0;
        this.pitch = 1.0;
        this.rate = 1.0;
        for (int i = 0; i < channels; ++i) {
            this.outputSegments[i] = new float[4096];
            this.converters[i] = new TimescaleConverter(1, sampleRate);
        }
    }

    public double getSpeed() {
        return this.speed;
    }

    public TimescalePcmAudioFilter setSpeed(double speed) {
        for (TimescaleConverter converter : this.converters) {
            converter.setSpeed(speed);
        }
        this.speed = speed;
        return this;
    }

    public TimescalePcmAudioFilter updateSpeed(DoubleToDoubleFunction function) {
        return this.setSpeed(function.apply(this.speed));
    }

    public TimescalePcmAudioFilter setSpeedChange(double change) {
        return this.setSpeed(1.0 + 0.01 * change);
    }

    public double getPitch() {
        return this.pitch;
    }

    public TimescalePcmAudioFilter setPitch(double pitch) {
        for (TimescaleConverter converter : this.converters) {
            converter.setPitch(pitch);
        }
        this.pitch = pitch;
        return this;
    }

    public TimescalePcmAudioFilter updatePitch(DoubleToDoubleFunction function) {
        return this.setPitch(function.apply(this.pitch));
    }

    public TimescalePcmAudioFilter setPitchOctaves(double pitch) {
        return this.setPitch(Math.exp(0.69314718056 * Math.max(Math.min(pitch, 1.0), -1.0)));
    }

    public TimescalePcmAudioFilter setPitchSemiTones(double pitch) {
        return this.setPitchOctaves(pitch / 12.0);
    }

    public double getRate() {
        return this.rate;
    }

    public TimescalePcmAudioFilter setRate(double rate) {
        for (TimescaleConverter converter : this.converters) {
            converter.setRate(rate);
        }
        this.rate = rate;
        return this;
    }

    public TimescalePcmAudioFilter updateRate(DoubleToDoubleFunction function) {
        return this.setRate(function.apply(this.rate));
    }

    public TimescalePcmAudioFilter setRateChange(double change) {
        return this.setRate(1.0 + 0.01 * change);
    }

    public int[] getNominalInputSequences() {
        int[] ret = new int[this.converters.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.converters[i].getNominalInputSequence();
        }
        return ret;
    }

    public int[] getNominalOutputSequences() {
        int[] ret = new int[this.converters.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.converters[i].getNominalOutputSequence();
        }
        return ret;
    }

    public int[] getInitialLatencies() {
        int[] ret = new int[this.converters.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.converters[i].getInitialLatency();
        }
        return ret;
    }

    public <T> T getSetting(Setting<T> setting) {
        return setting.get(this.converters[0]);
    }

    public <T> boolean setSetting(Setting<T> setting, T value) {
        boolean success = false;
        for (TimescaleConverter converter : this.converters) {
            success = setting.set(converter, value);
        }
        return success;
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        for (TimescaleConverter converter : this.converters) {
            converter.reset();
        }
    }

    @Override
    public void flush() {
        for (TimescaleConverter converter : this.converters) {
            converter.flush();
        }
    }

    @Override
    public void close() {
        for (TimescaleConverter converter : this.converters) {
            converter.close();
        }
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        int written = 0;
        for (int i = 0; i < input.length; ++i) {
            written = this.converters[i].process(input[i], offset, length, this.outputSegments[i], 0, 4096);
        }
        if (written > 0) {
            this.downstream.process(this.outputSegments, 0, written);
        }
        while (true) {
            boolean allEmpty = true;
            for (int i = 0; i < input.length; ++i) {
                written = this.converters[i].read(this.outputSegments[i], 0, 4096);
                if (written == 0) continue;
                allEmpty = false;
            }
            if (allEmpty) break;
            this.downstream.process(this.outputSegments, 0, written);
        }
    }
}

