/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader;

import com.github.natanbc.nativeloader.system.Aarch64CPUInfo;
import com.github.natanbc.nativeloader.system.ArmCPUInfo;
import com.github.natanbc.nativeloader.system.CPUInfo;
import com.github.natanbc.nativeloader.system.CPUType;
import com.github.natanbc.nativeloader.system.CacheInfo;
import com.github.natanbc.nativeloader.system.CacheLevelInfo;
import com.github.natanbc.nativeloader.system.CacheType;
import com.github.natanbc.nativeloader.system.DefaultArchitectureTypes;
import com.github.natanbc.nativeloader.system.X86CPUInfo;
import com.github.natanbc.nativeloader.system.X86Microarchitecture;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

class Natives {
    private static final int OFFSET_CACHE_LEVEL = 0;
    private static final int OFFSET_CACHE_TYPE = 1;
    private static final int OFFSET_CACHE_SIZE = 2;
    private static final int OFFSET_CACHE_WAYS = 3;
    private static final int OFFSET_CACHE_LINE_SIZE = 4;
    private static final int OFFSET_CACHE_TLB_ENTRIES = 5;
    private static final int OFFSET_CACHE_PARTITIONING = 6;

    Natives() {
    }

    private static native int arch();

    private static native int featureCount();

    private static native boolean hasFeature(int var0);

    private static native String featureName(int var0);

    private static native String x86Microarchitecture();

    private static native int x86Family();

    private static native int x86Model();

    private static native int x86Stepping();

    private static native void x86Vendor(@Nonnull byte[] var0, @Nonnegative int var1);

    private static native void x86BrandString(@Nonnull byte[] var0, @Nonnegative int var1);

    private static native int armCpuId();

    private static native int armImplementer();

    private static native int armArchitecture();

    private static native int armVariant();

    private static native int armPart();

    private static native int armRevision();

    private static native int aarch64Implementer();

    private static native int aarch64Variant();

    private static native int aarch64Part();

    private static native int aarch64Revision();

    private static native int cacheSize();

    private static native int cacheLevelFields();

    private static native void cacheLevel(int var0, int[] var1);

    private static CacheInfo parseCacheInfo() {
        int count = Natives.cacheSize();
        ArrayList<CacheLevelInfo> caches = new ArrayList<CacheLevelInfo>(count);
        int[] fields = new int[Natives.cacheLevelFields()];
        for (int i = 0; i < count; ++i) {
            Natives.cacheLevel(i, fields);
            caches.add(new CacheLevelInfo(fields[0], CacheType.fromNative(fields[1]), fields[2], fields[3], fields[4], fields[5], fields[6]));
        }
        return new CacheInfo(caches);
    }

    @Nonnull
    static CPUInfo createSystemInfo() {
        CPUType arch = CPUType.values()[Natives.arch() - 1];
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        int j = Natives.featureCount();
        for (int i = 0; i < j; ++i) {
            features.put(Natives.featureName(i), Natives.hasFeature(i));
        }
        CacheInfo cache = Natives.parseCacheInfo();
        switch (arch) {
            case X86: {
                boolean is64Bit = DefaultArchitectureTypes.detect() == DefaultArchitectureTypes.X86_64;
                byte[] vendor = new byte[12];
                byte[] brandString = new byte[48];
                Natives.x86Vendor(vendor, 0);
                Natives.x86BrandString(brandString, 0);
                return new X86CPUInfo(is64Bit, features, cache, X86Microarchitecture.fromNative(Natives.x86Microarchitecture()), Natives.x86Family(), Natives.x86Model(), Natives.x86Stepping(), Natives.fromCString(vendor), Natives.fromCString(brandString));
            }
            case ARM: {
                return new ArmCPUInfo(features, cache, Natives.armCpuId(), Natives.armImplementer(), Natives.armArchitecture(), Natives.armVariant(), Natives.armPart(), Natives.armRevision());
            }
            case AARCH64: {
                return new Aarch64CPUInfo(features, cache, Natives.aarch64Implementer(), Natives.aarch64Variant(), Natives.aarch64Part(), Natives.aarch64Revision());
            }
        }
        throw new IllegalArgumentException("Unknown architecture " + arch);
    }

    private static String fromCString(byte[] data) {
        int i;
        for (i = 0; i < data.length && data[i] != 0; ++i) {
        }
        return new String(data, 0, i, StandardCharsets.US_ASCII);
    }
}

