/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader;

import com.github.natanbc.nativeloader.NativeLibraryProperties;
import javax.annotation.Nullable;

public class SystemNativeLibraryProperties
implements NativeLibraryProperties {
    private final String libraryName;
    private final String propertyPrefix;

    public SystemNativeLibraryProperties(@Nullable String libraryName, String propertyPrefix) {
        this.libraryName = libraryName;
        this.propertyPrefix = propertyPrefix;
    }

    @Override
    public String libraryPath() {
        return this.get("path");
    }

    @Override
    public String libraryDirectory() {
        return this.get("dir");
    }

    @Override
    public String extractionPath() {
        return this.get("extractPath");
    }

    @Override
    public String operatingSystemName() {
        return this.get("os");
    }

    @Override
    public String libraryFileNamePrefix() {
        return this.get("libPrefix");
    }

    @Override
    public String libraryFileNameSuffix() {
        return this.get("libSuffix");
    }

    @Override
    public String architectureName() {
        return this.get("arch");
    }

    private String get(String property) {
        if (this.libraryName == null) {
            return System.getProperty(this.propertyPrefix + property);
        }
        return System.getProperty(this.propertyPrefix + this.libraryName + "." + property, System.getProperty(this.propertyPrefix + property));
    }
}

