/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader.system;

import com.github.natanbc.nativeloader.system.ArchitectureType;
import com.github.natanbc.nativeloader.system.CacheInfo;
import java.util.Collections;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class CPUInfo {
    private final ArchitectureType arch;
    private final Map<String, Boolean> features;
    private final CacheInfo cacheInfo;

    public CPUInfo(@Nonnull ArchitectureType arch, @Nonnull Map<String, Boolean> features, @Nonnull CacheInfo cacheInfo) {
        this.arch = arch;
        this.features = Collections.unmodifiableMap(features);
        this.cacheInfo = cacheInfo;
    }

    @Nonnull
    @CheckReturnValue
    public ArchitectureType arch() {
        return this.arch;
    }

    @Nonnull
    @CheckReturnValue
    public Map<String, Boolean> features() {
        return this.features;
    }

    @Nonnull
    @CheckReturnValue
    public CacheInfo cacheInfo() {
        return this.cacheInfo;
    }
}

