/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader.system;

import com.github.natanbc.nativeloader.system.ArchitectureType;
import com.github.natanbc.nativeloader.system.CPUType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public enum DefaultArchitectureTypes implements ArchitectureType
{
    ARM("arm", Arrays.asList("arm", "armeabi", "armv7b", "armv7l"), CPUType.ARM),
    ARM_HF("armhf", Arrays.asList("armeabihf", "armeabi-v7a"), CPUType.ARM),
    ARMv8_32("aarch32", Arrays.asList("armv8b", "armv8l"), CPUType.ARM),
    ARMv8_64("aarch64", Arrays.asList("arm64", "aarch64", "aarch64_be", "arm64-v8a"), CPUType.AARCH64),
    X86_32("x86", Arrays.asList("x86", "i386", "i486", "i586", "i686"), CPUType.X86),
    X86_64("x86-64", Arrays.asList("x86_64", "amd64"), CPUType.X86);

    private static final Map<String, ArchitectureType> ALIAS_MAP;
    public final String identifier;
    public final List<String> aliases;
    public final CPUType cpuType;

    private DefaultArchitectureTypes(String identifier, List<String> aliases, CPUType cpuType) {
        this.identifier = identifier;
        this.aliases = aliases;
        this.cpuType = cpuType;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public CPUType cpuType() {
        return this.cpuType;
    }

    public static ArchitectureType detect() {
        String arch = System.getProperty("os.arch");
        return DefaultArchitectureTypes.parse(arch).orElseThrow(() -> new IllegalArgumentException("Unknown architecture: " + arch));
    }

    public static Optional<ArchitectureType> parse(String name) {
        return Optional.ofNullable(ALIAS_MAP.get(name));
    }

    private static Map<String, ArchitectureType> createAliasMap() {
        HashMap<String, ArchitectureType> aliases = new HashMap<String, ArchitectureType>();
        for (DefaultArchitectureTypes value : DefaultArchitectureTypes.values()) {
            aliases.put(value.name().toLowerCase(), value);
            for (String alias : value.aliases) {
                aliases.put(alias, value);
            }
        }
        return aliases;
    }

    static {
        ALIAS_MAP = DefaultArchitectureTypes.createAliasMap();
    }
}

