/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.deezer;

import com.github.topi314.lavasrc.ExtendedAudioTrack;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.deezer.DeezerAudioSourceManager;
import com.github.topi314.lavasrc.deezer.DeezerPersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiFunction;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;

public class DeezerAudioTrack
extends ExtendedAudioTrack {
    private final DeezerAudioSourceManager sourceManager;
    private final CookieStore cookieStore;

    public DeezerAudioTrack(AudioTrackInfo trackInfo, DeezerAudioSourceManager sourceManager) {
        this(trackInfo, null, null, null, null, null, false, sourceManager);
    }

    public DeezerAudioTrack(AudioTrackInfo trackInfo, String albumName, String albumUrl, String artistUrl, String artistArtworkUrl, String previewUrl, boolean isPreview, DeezerAudioSourceManager sourceManager) {
        super(trackInfo, albumName, albumUrl, artistUrl, artistArtworkUrl, previewUrl, isPreview);
        this.sourceManager = sourceManager;
        this.cookieStore = new BasicCookieStore();
    }

    private static String formatFormats(TrackFormat[] formats) {
        ArrayList<CallSite> strFormats = new ArrayList<CallSite>();
        for (TrackFormat format : formats) {
            strFormats.add((CallSite)((Object)("{\"cipher\":\"BF_CBC_STRIPE\",\"format\":\"" + format.name() + "\"}")));
        }
        return String.join((CharSequence)",", strFormats);
    }

    private JsonBrowser getJsonResponse(HttpUriRequest request, boolean useArl) throws IOException {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            httpInterface.getContext().setRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
            httpInterface.getContext().setCookieStore(this.cookieStore);
            if (useArl && this.sourceManager.getArl() != null) {
                request.setHeader("Cookie", "arl=" + this.sourceManager.getArl());
            }
            JsonBrowser jsonBrowser = LavaSrcTools.fetchResponseAsJson(httpInterface, request);
            return jsonBrowser;
        }
    }

    private String getSessionId() throws IOException {
        HttpPost getSessionID = new HttpPost("https://www.deezer.com/ajax/gw-light.php?method=deezer.ping&input=3&api_version=1.0&api_token=");
        JsonBrowser sessionIdJson = this.getJsonResponse(getSessionID, false);
        DeezerAudioSourceManager.checkResponse(sessionIdJson, "Failed to get session ID: ");
        return sessionIdJson.get("results").get("SESSION").text();
    }

    private LicenseToken generateLicenceToken(boolean useArl) throws IOException {
        HttpGet request = new HttpGet("https://www.deezer.com/ajax/gw-light.php?method=deezer.getUserData&input=3&api_version=1.0&api_token=");
        if (!useArl || this.sourceManager.getArl() == null) {
            request.setHeader("Cookie", "sid=" + this.getSessionId());
        }
        JsonBrowser json2 = this.getJsonResponse(request, useArl);
        DeezerAudioSourceManager.checkResponse(json2, "Failed to get user token: ");
        return new LicenseToken(json2.get("results").get("USER").get("OPTIONS").get("license_token").text(), json2.get("results").get("checkForm").text());
    }

    public SourceWithFormat getSource(boolean useArl, boolean isRetry) throws IOException, URISyntaxException {
        LicenseToken licenseToken = this.generateLicenceToken(useArl);
        HttpPost getTrackToken = new HttpPost("https://www.deezer.com/ajax/gw-light.php?method=song.getData&input=3&api_version=1.0&api_token=" + licenseToken.apiToken);
        getTrackToken.setEntity(new StringEntity("{\"sng_id\":\"" + this.trackInfo.identifier + "\"}", ContentType.APPLICATION_JSON));
        JsonBrowser trackTokenJson = this.getJsonResponse(getTrackToken, useArl);
        DeezerAudioSourceManager.checkResponse(trackTokenJson, "Failed to get track token: ");
        if (trackTokenJson.get("error").get("VALID_TOKEN_REQUIRED").text() != null && !isRetry) {
            return this.getSource(useArl, true);
        }
        String trackToken = trackTokenJson.get("results").get("TRACK_TOKEN").text();
        HttpPost getMediaURL = new HttpPost("https://media.deezer.com/v1/get_url");
        getMediaURL.setEntity(new StringEntity("{\"license_token\":\"" + licenseToken.userLicenseToken + "\",\"media\":[{\"type\":\"FULL\",\"formats\":[" + DeezerAudioTrack.formatFormats(this.sourceManager.getFormats()) + "]}],\"track_tokens\": [\"" + trackToken + "\"]}", ContentType.APPLICATION_JSON));
        JsonBrowser json2 = this.getJsonResponse(getMediaURL, useArl);
        for (JsonBrowser error : json2.get("data").get("errors").values()) {
            if (error.get("code").asLong(0L) != 2000L) continue;
            return this.getSource(useArl, true);
        }
        DeezerAudioSourceManager.checkResponse(json2, "Failed to get media URL: ");
        return SourceWithFormat.fromResponse(json2, trackTokenJson);
    }

    public byte[] getTrackDecryptionKey() throws NoSuchAlgorithmException {
        char[] md5 = Hex.encodeHex(MessageDigest.getInstance("MD5").digest(this.trackInfo.identifier.getBytes()), true);
        byte[] master_key = this.sourceManager.getMasterDecryptionKey().getBytes();
        byte[] key = new byte[16];
        for (int i = 0; i < 16; ++i) {
            key[i] = (byte)(md5[i] ^ md5[i + 16] ^ master_key[i]);
        }
        return key;
    }

    @Override
    public void process(LocalAudioTrackExecutor executor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            if (this.isPreview) {
                if (this.previewUrl == null) {
                    throw new FriendlyException("No preview url found", FriendlyException.Severity.COMMON, new IllegalArgumentException());
                }
                try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(this.previewUrl), this.trackInfo.length);){
                    this.processDelegate(new Mp3AudioTrack(this.trackInfo, stream), executor);
                }
                return;
            }
            SourceWithFormat source = this.getSource(this.sourceManager.getArl() != null, false);
            try (DeezerPersistentHttpStream stream = new DeezerPersistentHttpStream(httpInterface, source.url, source.contentLength, this.getTrackDecryptionKey());){
                this.processDelegate(source.format.trackFactory.apply(this.trackInfo, stream), executor);
            }
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new DeezerAudioTrack(this.trackInfo, this.albumName, this.albumUrl, this.artistUrl, this.artistArtworkUrl, this.previewUrl, this.isPreview, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    public static class SourceWithFormat {
        private final URI url;
        private final TrackFormat format;
        private final long contentLength;

        private SourceWithFormat(String url, TrackFormat format, long contentLength) throws URISyntaxException {
            this.url = new URI(url);
            this.format = format;
            this.contentLength = contentLength;
        }

        private static SourceWithFormat fromResponse(JsonBrowser json2, JsonBrowser trackJson) throws URISyntaxException {
            JsonBrowser media = json2.get("data").index(0).get("media").index(0);
            if (media.isNull()) {
                return null;
            }
            String format = media.get("format").text();
            String url = media.get("sources").index(0).get("url").text();
            long contentLength = trackJson.get("results").get("FILESIZE_" + format).asLong(Long.MAX_VALUE);
            return new SourceWithFormat(url, TrackFormat.from(format), contentLength);
        }

        public URI getUrl() {
            return this.url;
        }

        public TrackFormat getFormat() {
            return this.format;
        }

        public long getContentLength() {
            return this.contentLength;
        }
    }

    private static class LicenseToken {
        private final String userLicenseToken;
        private final String apiToken;

        private LicenseToken(String userLicenseToken, String apiToken) {
            this.userLicenseToken = userLicenseToken;
            this.apiToken = apiToken;
        }
    }

    public static enum TrackFormat {
        FLAC(true, FlacAudioTrack::new),
        MP3_320(true, Mp3AudioTrack::new),
        MP3_256(true, Mp3AudioTrack::new),
        MP3_128(false, Mp3AudioTrack::new),
        MP3_64(false, Mp3AudioTrack::new),
        AAC_64(true, MpegAudioTrack::new);

        private boolean isPremiumFormat;
        private BiFunction<AudioTrackInfo, PersistentHttpStream, InternalAudioTrack> trackFactory;
        public static final TrackFormat[] DEFAULT_FORMATS;

        private TrackFormat(boolean isPremiumFormat, BiFunction<AudioTrackInfo, PersistentHttpStream, InternalAudioTrack> trackFactory) {
            this.isPremiumFormat = isPremiumFormat;
            this.trackFactory = trackFactory;
        }

        public static TrackFormat from(String format) {
            return Arrays.stream(TrackFormat.values()).filter(it -> it.name().equals(format)).findFirst().orElse(null);
        }

        static {
            DEFAULT_FORMATS = new TrackFormat[]{MP3_128, MP3_64};
        }
    }
}

