/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.youtube;

import com.github.topi314.lavalyrics.AudioLyricsManager;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.github.topi314.lavasearch.AudioSearchManager;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import com.github.topi314.lavasearch.result.AudioText;
import com.github.topi314.lavasearch.result.BasicAudioSearchResult;
import com.github.topi314.lavasearch.result.BasicAudioText;
import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.youtube.YoutubeSearchManager;
import com.github.topi314.lavasrc.youtube.YoutubeSourceManagerKt;
import com.github.topi314.lavasrc.youtube.innertube.ClientKt;
import com.github.topi314.lavasrc.youtube.innertube.InnerTubeBox;
import com.github.topi314.lavasrc.youtube.innertube.MusicResponsiveListItemRenderer;
import com.github.topi314.lavasrc.youtube.innertube.SearchSuggestionsRenderer;
import com.github.topi314.lavasrc.youtube.innertube.SearchSuggestionsRendererContent;
import com.github.topi314.lavasrc.youtube.innertube.SearchSuggestionsSectionRendererContent;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.track.YoutubeAudioTrack;
import dev.schlaubi.lyrics.LyricsNotFoundException;
import java.io.Closeable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.methods.HttpGet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\u0007H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/github/topi314/lavasrc/youtube/YoutubeSearchManager;", "Lcom/github/topi314/lavasearch/AudioSearchManager;", "Lcom/github/topi314/lavalyrics/AudioLyricsManager;", "playerManager", "Lkotlin/Function0;", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "region", "", "(Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "httpInterfaceManager", "Lcom/sedmelluq/discord/lavaplayer/tools/io/HttpInterfaceManager;", "kotlin.jvm.PlatformType", "getSourceName", "loadLyrics", "Lcom/github/topi314/lavalyrics/lyrics/AudioLyrics;", "track", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "loadSearch", "Lcom/github/topi314/lavasearch/result/AudioSearchResult;", "query", "types", "", "Lcom/github/topi314/lavasearch/result/AudioSearchResult$Type;", "requestYoutubeAutoComplete", "", "Lcom/github/topi314/lavasearch/result/AudioText;", "shutdown", "", "Companion", "lavasrc"})
@SourceDebugExtension(value={"SMAP\nYoutubeSourceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YoutubeSourceManager.kt\ncom/github/topi314/lavasrc/youtube/YoutubeSearchManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 YoutubeSourceManager.kt\ncom/github/topi314/lavasrc/youtube/YoutubeSourceManagerKt\n*L\n1#1,188:1\n1360#2:189\n1446#2,2:190\n1603#2,9:192\n1855#2:201\n1856#2:203\n1612#2:204\n1448#2,3:205\n800#2,11:210\n800#2,11:222\n1#3:202\n1#3:208\n183#4:209\n183#4:221\n*S KotlinDebug\n*F\n+ 1 YoutubeSourceManager.kt\ncom/github/topi314/lavasrc/youtube/YoutubeSearchManager\n*L\n87#1:189\n87#1:190,2\n88#1:192,9\n88#1:201\n88#1:203\n88#1:204\n87#1:205,3\n156#1:210,11\n160#1:222,11\n88#1:202\n156#1:209\n160#1:221\n*E\n"})
public final class YoutubeSearchManager
implements AudioSearchManager,
AudioLyricsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<AudioPlayerManager> playerManager;
    @NotNull
    private final String region;
    private final HttpInterfaceManager httpInterfaceManager;
    @NotNull
    public static final String SEARCH_PREFIX = "ytsearch:";
    @NotNull
    public static final String MUSIC_SEARCH_PREFIX = "ytmsearch:";
    @NotNull
    private static final Set<AudioSearchResult.Type> SEARCH_TYPES;

    public YoutubeSearchManager(@NotNull Function0<? extends AudioPlayerManager> playerManager, @NotNull String region) {
        Intrinsics.checkNotNullParameter(playerManager, "playerManager");
        Intrinsics.checkNotNullParameter(region, "region");
        this.playerManager = playerManager;
        this.region = region;
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "youtube";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AudioLyrics loadLyrics(@NotNull AudioTrack track) {
        Object object;
        Intrinsics.checkNotNullParameter(track, "track");
        try {
            AudioLyrics audioLyrics;
            object = this.httpInterfaceManager.getInterface();
            Throwable throwable = null;
            try {
                AudioLyrics audioLyrics2;
                String string;
                HttpInterface it = (HttpInterface)object;
                boolean bl = false;
                if (Intrinsics.areEqual(track.getSourceManager().getSourceName(), "youtube")) {
                    string = track.getInfo().identifier;
                } else if (track.getInfo().isrc != null) {
                    Intrinsics.checkNotNull(it);
                    String string2 = track.getInfo().isrc;
                    Intrinsics.checkNotNullExpressionValue(string2, "isrc");
                    string = ClientKt.takeFirstSearchResult(it, string2, this.region);
                } else {
                    Intrinsics.checkNotNull(it);
                    string = ClientKt.takeFirstSearchResult(it, track.getInfo().title + " - " + track.getInfo().author, this.region);
                }
                if (string == null) {
                    audioLyrics2 = null;
                } else {
                    String videoId = string;
                    Intrinsics.checkNotNull(it);
                    audioLyrics2 = ClientKt.requestLyrics(it, videoId);
                }
                audioLyrics = audioLyrics2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            object = audioLyrics;
        }
        catch (LyricsNotFoundException e) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public AudioSearchResult loadSearch(@NotNull String query, @NotNull Set<? extends AudioSearchResult.Type> types) {
        List list;
        List list2;
        List list3;
        Iterable $this$filterIsInstanceTo$iv$iv$iv;
        boolean $i$f$filterIsInstanceTo;
        Collection destination$iv$iv$iv;
        List $this$filter$iv;
        Set<AudioSearchResult.Type> set;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(query, "query");
        Intrinsics.checkNotNullParameter(types, "types");
        Closeable closeable = this.httpInterfaceManager.getInterface();
        Throwable throwable = null;
        try {
            Object it = (HttpInterface)closeable;
            boolean bl = false;
            if (!StringsKt.startsWith$default(query, MUSIC_SEARCH_PREFIX, false, 2, null)) {
                if (StringsKt.startsWith$default(query, SEARCH_PREFIX, false, 2, null)) {
                    List<AudioText> response = this.requestYoutubeAutoComplete(StringsKt.removePrefix(query, (CharSequence)SEARCH_PREFIX));
                    AudioSearchResult audioSearchResult = new BasicAudioSearchResult(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), response);
                    return audioSearchResult;
                }
                AudioSearchResult audioSearchResult = null;
                return audioSearchResult;
            }
            Intrinsics.checkNotNull(it);
            it = ClientKt.requestMusicAutoComplete$default((HttpInterface)it, StringsKt.removePrefix(query, (CharSequence)MUSIC_SEARCH_PREFIX), null, 2, null);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Object result = it;
        Iterable $this$flatMap$iv = ((InnerTubeBox)result).getContents();
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            SearchSuggestionsSectionRendererContent it = (SearchSuggestionsSectionRendererContent)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = it.getSearchSuggestionsSectionRenderer().getContents();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                SearchSuggestionsRendererContent suggestionRenderer = (SearchSuggestionsRendererContent)element$iv$iv2;
                boolean bl3 = false;
                if (suggestionRenderer.getSearchSuggestionRenderer() != null) {
                    object = new BasicAudioText(suggestionRenderer.getSearchSuggestionRenderer().getSuggestion().joinRuns());
                } else if (suggestionRenderer.getMusicResponsiveListItemRenderer() != null) {
                    String string;
                    SearchSuggestionsRenderer.Suggestion.Run run;
                    List<SearchSuggestionsRenderer.Suggestion.Run> list4;
                    SearchSuggestionsRenderer.Suggestion suggestion;
                    MusicResponsiveListItemRenderer.FlexColumn.MusicResponsiveListItemFlexColumnRenderer musicResponsiveListItemFlexColumnRenderer;
                    String artist;
                    MusicResponsiveListItemRenderer item = suggestionRenderer.getMusicResponsiveListItemRenderer();
                    String thumbnail = CollectionsKt.first(item.getThumbnail().getMusicThumbnailRenderer().getThumbnail().getThumbnails()).getUrl();
                    String url = YoutubeSourceManagerKt.access$toUrl(item.getNavigationEndpoint());
                    MusicResponsiveListItemRenderer.FlexColumn flexColumn = CollectionsKt.getOrNull(item.getFlexColumns(), 1);
                    String string2 = artist = flexColumn != null && (musicResponsiveListItemFlexColumnRenderer = flexColumn.getMusicResponsiveListItemFlexColumnRenderer()) != null && (suggestion = musicResponsiveListItemFlexColumnRenderer.getText()) != null && (list4 = suggestion.getRuns()) != null && (run = CollectionsKt.getOrNull(list4, 2)) != null && (string = run.getText()) != null ? string : "Unknown Author";
                    if (item.getNavigationEndpoint().getWatchEndpoint() != null) {
                        AudioTrackInfo info = new AudioTrackInfo(CollectionsKt.first(item.getFlexColumns()).getMusicResponsiveListItemFlexColumnRenderer().getText().joinRuns(), artist, -1L, item.getNavigationEndpoint().getWatchEndpoint().getVideoId(), false, url, thumbnail, null);
                        object = new YoutubeAudioTrack(info, this.playerManager.invoke().source(YoutubeAudioSourceManager.class));
                    } else if (item.getNavigationEndpoint().getBrowseEndpoint() != null) {
                        ExtendedAudioPlaylist extendedAudioPlaylist;
                        MusicResponsiveListItemRenderer.NavigationEndpoint.BrowseEndpoint.Configs.Config.Type type = item.getNavigationEndpoint().getBrowseEndpoint().getBrowseEndpointContextSupportedConfigs().getBrowseEndpointContextMusicConfig().getPageType();
                        String name = CollectionsKt.first(item.getFlexColumns()).getMusicResponsiveListItemFlexColumnRenderer().getText().joinRuns();
                        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                            case 1: {
                                extendedAudioPlaylist = new ExtendedAudioPlaylist(name, CollectionsKt.emptyList(), ExtendedAudioPlaylist.Type.ALBUM, url, thumbnail, artist, null);
                                break;
                            }
                            case 2: {
                                extendedAudioPlaylist = new ExtendedAudioPlaylist(name + "'s Top Tracks", CollectionsKt.emptyList(), ExtendedAudioPlaylist.Type.ARTIST, url, thumbnail, artist, null);
                                break;
                            }
                            case 3: {
                                extendedAudioPlaylist = new ExtendedAudioPlaylist(name, CollectionsKt.emptyList(), ExtendedAudioPlaylist.Type.PLAYLIST, url, thumbnail, artist, null);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        object = extendedAudioPlaylist;
                    } else {
                        object = null;
                    }
                } else {
                    object = null;
                }
                if (object == null) continue;
                BasicAudioText it$iv$iv = object;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List items = (List)destination$iv$iv;
        Collection<AudioSearchResult.Type> $i$f$flatMap22 = (Set<AudioSearchResult.Type>)types;
        if ($i$f$flatMap22.isEmpty()) {
            boolean bl = false;
            set = SEARCH_TYPES;
        } else {
            set = $i$f$flatMap22;
        }
        Set finalTypes = set;
        $i$f$flatMap22 = items;
        boolean enabled$iv = finalTypes.contains((Object)AudioSearchResult.Type.TRACK);
        boolean $i$f$filter = false;
        if (enabled$iv) {
            Object element$iv$iv;
            Iterable $this$filterIsInstance$iv$iv = $this$filter$iv;
            boolean $i$f$filterIsInstance = false;
            element$iv$iv = $this$filterIsInstance$iv$iv;
            destination$iv$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof AudioTrack)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            list3 = (List)destination$iv$iv$iv;
        } else {
            list3 = CollectionsKt.emptyList();
        }
        $this$filter$iv = items;
        enabled$iv = finalTypes.contains((Object)AudioSearchResult.Type.TEXT);
        List list5 = YoutubeSourceManagerKt.access$filter(items, finalTypes.contains((Object)AudioSearchResult.Type.PLAYLIST), ExtendedAudioPlaylist.Type.PLAYLIST);
        List list6 = YoutubeSourceManagerKt.access$filter(items, finalTypes.contains((Object)AudioSearchResult.Type.ARTIST), ExtendedAudioPlaylist.Type.ARTIST);
        List list7 = YoutubeSourceManagerKt.access$filter(items, finalTypes.contains((Object)AudioSearchResult.Type.ALBUM), ExtendedAudioPlaylist.Type.ALBUM);
        List list8 = list3;
        $i$f$filter = false;
        if (enabled$iv) {
            Iterable $this$filterIsInstance$iv$iv = $this$filter$iv;
            boolean $i$f$filterIsInstance = false;
            $this$filterIsInstanceTo$iv$iv$iv = $this$filterIsInstance$iv$iv;
            destination$iv$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof AudioText)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            list2 = (List)destination$iv$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List list9 = list = list2;
        List list10 = list5;
        List list11 = list6;
        List list12 = list7;
        List list13 = list8;
        return new BasicAudioSearchResult(list13, list12, list11, list10, list9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AudioText> requestYoutubeAutoComplete(String query) {
        String string;
        Closeable closeable = this.httpInterfaceManager.getInterface();
        Throwable throwable = null;
        try {
            HttpInterface it = (HttpInterface)closeable;
            boolean bl = false;
            String encodedQuery = URLEncoder.encode(query, Charsets.UTF_8);
            HttpGet request = new HttpGet("https://suggestqueries-clients6.youtube.com/complete/search?client=youtube&q=" + encodedQuery);
            byte[] byArray = it.execute(request).getEntity().getContent().readAllBytes();
            Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
            string = StringsKt.decodeToString(byArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        String input = string;
        return SequencesKt.toList(SequencesKt.map(Regex.findAll$default(YoutubeSourceManagerKt.access$getSearchPattern$p(), input, 0, 2, null), requestYoutubeAutoComplete.1.INSTANCE));
    }

    @Override
    public void shutdown() {
        this.httpInterfaceManager.close();
    }

    static {
        AudioSearchResult.Type[] typeArray = new AudioSearchResult.Type[]{AudioSearchResult.Type.ALBUM, AudioSearchResult.Type.ARTIST, AudioSearchResult.Type.PLAYLIST, AudioSearchResult.Type.TRACK, AudioSearchResult.Type.TEXT};
        SEARCH_TYPES = SetsKt.setOf(typeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/topi314/lavasrc/youtube/YoutubeSearchManager$Companion;", "", "()V", "MUSIC_SEARCH_PREFIX", "", "SEARCH_PREFIX", "SEARCH_TYPES", "", "Lcom/github/topi314/lavasearch/result/AudioSearchResult$Type;", "getSEARCH_TYPES", "()Ljava/util/Set;", "lavasrc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<AudioSearchResult.Type> getSEARCH_TYPES() {
            return SEARCH_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MusicResponsiveListItemRenderer.NavigationEndpoint.BrowseEndpoint.Configs.Config.Type.values().length];
            try {
                nArray[MusicResponsiveListItemRenderer.NavigationEndpoint.BrowseEndpoint.Configs.Config.Type.MUSIC_PAGE_TYPE_ALBUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MusicResponsiveListItemRenderer.NavigationEndpoint.BrowseEndpoint.Configs.Config.Type.MUSIC_PAGE_TYPE_ARTIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MusicResponsiveListItemRenderer.NavigationEndpoint.BrowseEndpoint.Configs.Config.Type.MUSIC_PAGE_TYPE_PLAYLIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

