/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.AudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompositeAudioFilter
implements UniversalPcmAudioFilter {
    private static final Logger log = LoggerFactory.getLogger(CompositeAudioFilter.class);

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        for (AudioFilter filter2 : this.getFilters()) {
            try {
                filter2.seekPerformed(requestedTime, providedTime);
            }
            catch (Exception e) {
                log.error("Notifying filter {} of seek failed with exception.", (Object)filter2.getClass(), (Object)e);
            }
        }
    }

    @Override
    public void flush() throws InterruptedException {
        for (AudioFilter filter2 : this.getFilters()) {
            try {
                filter2.flush();
            }
            catch (Exception e) {
                log.error("Flushing filter {} failed with exception.", (Object)filter2.getClass(), (Object)e);
            }
        }
    }

    @Override
    public void close() {
        for (AudioFilter filter2 : this.getFilters()) {
            try {
                filter2.close();
            }
            catch (Exception e) {
                log.error("Closing filter {} failed with exception.", (Object)filter2.getClass(), (Object)e);
            }
        }
    }

    protected abstract List<AudioFilter> getFilters();
}

