/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.player;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackStartEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class AudioPlayerLifecycleManager
implements Runnable,
AudioEventListener {
    private static final long CHECK_INTERVAL = 10000L;
    private final ConcurrentMap<AudioPlayer, AudioPlayer> activePlayers = new ConcurrentHashMap<AudioPlayer, AudioPlayer>();
    private final ScheduledExecutorService scheduler;
    private final AtomicLong cleanupThreshold;
    private final AtomicReference<ScheduledFuture<?>> scheduledTask;

    public AudioPlayerLifecycleManager(ScheduledExecutorService scheduler, AtomicLong cleanupThreshold) {
        this.scheduler = scheduler;
        this.cleanupThreshold = cleanupThreshold;
        this.scheduledTask = new AtomicReference();
    }

    public void initialise() {
        ScheduledFuture<?> task = this.scheduler.scheduleAtFixedRate(this, 10000L, 10000L, TimeUnit.MILLISECONDS);
        if (!this.scheduledTask.compareAndSet(null, task)) {
            task.cancel(false);
        }
    }

    public void shutdown() {
        ScheduledFuture task = this.scheduledTask.getAndSet(null);
        if (task != null) {
            task.cancel(false);
        }
    }

    @Override
    public void onEvent(AudioEvent event) {
        if (event instanceof TrackStartEvent) {
            this.activePlayers.put(event.player, event.player);
        } else if (event instanceof TrackEndEvent) {
            this.activePlayers.remove(event.player);
        }
    }

    @Override
    public void run() {
        for (AudioPlayer player : this.activePlayers.keySet()) {
            player.checkCleanup(this.cleanupThreshold.get());
        }
    }
}

