/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.beam;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;

public class BeamAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String STREAM_NAME_REGEX = "^https://(?:www\\.)?(?:beam\\.pro|mixer\\.com)/([^/]+)$";
    private static final Pattern streamNameRegex = Pattern.compile("^https://(?:www\\.)?(?:beam\\.pro|mixer\\.com)/([^/]+)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();

    @Override
    public String getSourceName() {
        return "beam.pro";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String streamName = BeamAudioSourceManager.getChannelNameFromUrl(reference.identifier);
        if (streamName == null) {
            return null;
        }
        JsonBrowser channelInfo = this.fetchStreamChannelInfo(streamName);
        if (channelInfo == null) {
            return AudioReference.NO_TRACK;
        }
        String displayName = channelInfo.get("name").text();
        String id = BeamAudioSourceManager.getPlayedStreamId(channelInfo);
        String thumbnailUrl = channelInfo.get("thumbnail").get("url").text();
        if (displayName == null || id == null) {
            throw new IllegalStateException("Expected id and name fields from Beam channel info.");
        }
        return new BeamAudioTrack(new AudioTrackInfo(displayName, streamName, Long.MAX_VALUE, id + "|" + streamName + "|" + reference.identifier, true, "https://beam.pro/" + streamName, thumbnailUrl, null), this);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new BeamAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
    }

    private static String getPlayedStreamId(JsonBrowser channelInfo) {
        String hosteeId = channelInfo.get("hosteeId").text();
        return hosteeId != null ? hosteeId : channelInfo.get("id").text();
    }

    private static String getChannelNameFromUrl(String url) {
        Matcher matcher = streamNameRegex.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    private JsonBrowser fetchStreamChannelInfo(String name) {
        JsonBrowser jsonBrowser;
        block8: {
            HttpInterface httpInterface = this.getHttpInterface();
            try {
                jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, new HttpGet("https://mixer.com/api/v1/channels/" + name + "?noCount=1"));
                if (httpInterface == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpInterface != null) {
                        try {
                            httpInterface.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FriendlyException("Loading Beam channel information failed.", FriendlyException.Severity.SUSPICIOUS, e);
                }
            }
            httpInterface.close();
        }
        return jsonBrowser;
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }
}

