/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.yamusic;

import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexHttpContextFilter;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicApiLoader;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpGet;

public abstract class AbstractYandexMusicApiLoader
implements YandexMusicApiLoader {
    protected HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();

    AbstractYandexMusicApiLoader() {
        this.httpInterfaceManager.setHttpContextFilter(new YandexHttpContextFilter());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T extractFromApi(String url, ApiExtractor<T> extractor) {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            String responseText;
            try (Object response = httpInterface.execute(new HttpGet(url));){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new IOException("Invalid status code: " + statusCode);
                }
                responseText = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            }
            response = JsonBrowser.parse(responseText);
            if (((JsonBrowser)response).isNull()) {
                throw new FriendlyException("Couldn't get API response.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            if (((JsonBrowser)(response = ((JsonBrowser)response).get("result"))).isNull() && !((JsonBrowser)response).isList()) {
                throw new FriendlyException("Couldn't get API response result.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            T t = extractor.extract(httpInterface, (JsonBrowser)response);
            return t;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Loading information for a Yandex Music track failed.", FriendlyException.Severity.FAULT, e);
        }
    }

    @Override
    public ExtendedHttpConfigurable getHttpConfiguration() {
        return this.httpInterfaceManager;
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }

    protected static interface ApiExtractor<T> {
        public T extract(HttpInterface var1, JsonBrowser var2) throws Exception;
    }
}

