/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.track;

import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.Units;
import org.jetbrains.annotations.NotNull;

public class TemporalInfo {
    public final boolean isActiveStream;
    public final long durationMillis;

    private TemporalInfo(boolean isActiveStream, long durationMillis) {
        this.isActiveStream = isActiveStream;
        this.durationMillis = durationMillis;
    }

    @NotNull
    public static TemporalInfo fromRawData(JsonBrowser playabilityStatus, JsonBrowser videoDetails) {
        JsonBrowser durationField = videoDetails.get("lengthSeconds");
        long durationValue = durationField.asLong(0L);
        boolean isLive = videoDetails.get("isLive").asBoolean(false);
        if (isLive) {
            durationValue = 0L;
        }
        return new TemporalInfo(isLive, durationValue == 0L ? Long.MAX_VALUE : Units.secondsToMillis(durationValue));
    }
}

