/*
 * Decompiled with CFR 0.152.
 */
package express;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import express.DynExpress;
import express.ExpressListener;
import express.ExpressRouter;
import express.Router;
import express.filter.FilterImpl;
import express.filter.FilterLayerHandler;
import express.filter.FilterTask;
import express.filter.FilterWorker;
import express.http.HttpRequestHandler;
import express.http.request.Request;
import express.http.response.Response;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class Express
implements Router {
    private final ConcurrentHashMap<String, HttpRequestHandler> parameterListener = new ConcurrentHashMap();
    private final ConcurrentHashMap<Object, Object> locals = new ConcurrentHashMap();
    private final ArrayList<FilterWorker> worker = new ArrayList();
    private final FilterLayerHandler handler = new FilterLayerHandler(2);
    private Executor executor = Executors.newCachedThreadPool();
    private String hostname;
    private HttpServer httpServer;
    private HttpsConfigurator httpsConfigurator;

    public Express(String hostname) {
        this.hostname = hostname;
    }

    public Express(HttpsConfigurator httpsConfigurator) {
        this.httpsConfigurator = httpsConfigurator;
    }

    public Express(String hostname, HttpsConfigurator httpsConfigurator) {
        this.hostname = hostname;
        this.httpsConfigurator = httpsConfigurator;
    }

    public Express() {
    }

    public boolean isSecure() {
        return this.httpsConfigurator != null;
    }

    public Express onParam(String param, HttpRequestHandler request) {
        this.parameterListener.put(param, request);
        return this;
    }

    public ConcurrentHashMap<String, HttpRequestHandler> getParameterListener() {
        return this.parameterListener;
    }

    public Object set(String key, String val) {
        return this.locals.put(key, val);
    }

    public Object get(String key) {
        return this.locals.get(key);
    }

    public void setExecutor(Executor executor) throws IOException {
        if (this.httpServer != null) {
            throw new IOException("Cannot set executor after the server has stardet!");
        }
        this.executor = executor;
    }

    public Express use(ExpressRouter router) {
        this.handler.combine(router.getHandler());
        this.worker.addAll(router.getWorker());
        return this;
    }

    public Express use(String root, ExpressRouter router) {
        router.getHandler().forEach(fl -> fl.getFilter().forEach(layer -> ((FilterImpl)layer).setRoot(root)));
        this.handler.combine(router.getHandler());
        this.worker.addAll(router.getWorker());
        return this;
    }

    @Override
    public Express use(HttpRequestHandler middleware) {
        this.addMiddleware("*", "*", middleware);
        return this;
    }

    @Override
    public Express use(String context, HttpRequestHandler middleware) {
        this.addMiddleware("*", context, middleware);
        return this;
    }

    @Override
    public Express use(String context, String requestMethod, HttpRequestHandler middleware) {
        this.addMiddleware(requestMethod.toUpperCase(), context, middleware);
        return this;
    }

    private void addMiddleware(String requestMethod, String context, HttpRequestHandler middleware) {
        if (middleware instanceof FilterTask) {
            this.worker.add(new FilterWorker((FilterTask)((Object)middleware)));
        }
        this.handler.add(0, new FilterImpl(requestMethod, context, middleware));
    }

    @Override
    public Express all(HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("*", "*", request));
        return this;
    }

    @Override
    public Express all(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("*", context, request));
        return this;
    }

    @Override
    public Express all(String context, String requestMethod, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl(requestMethod, context, request));
        return this;
    }

    @Override
    public Express get(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("GET", context, request));
        return this;
    }

    @Override
    public Express post(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("POST", context, request));
        return this;
    }

    @Override
    public Express put(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("PUT", context, request));
        return this;
    }

    @Override
    public Express delete(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("DELETE", context, request));
        return this;
    }

    @Override
    public Express patch(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("PATCH", context, request));
        return this;
    }

    public Express bind(Object ... objects) {
        for (Object o : objects) {
            Method[] methods;
            if (o == null) continue;
            for (Method method : methods = o.getClass().getDeclaredMethods()) {
                Class<?>[] params;
                if (!method.isAnnotationPresent(DynExpress.class)) continue;
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                if ((params = method.getParameterTypes()).length < 1 || params[0] != Request.class || params[1] != Response.class) {
                    StringBuilder sb = new StringBuilder();
                    for (Class<?> c : params) {
                        sb.append(c.getSimpleName());
                        sb.append(", ");
                    }
                    String paramString = sb.toString();
                    if (paramString.length() > 2) {
                        paramString = paramString.substring(0, paramString.length() - 2);
                    }
                    System.err.println("Skipped method with invalid parameter types found in " + method.getName() + "(" + paramString + ") in " + o.getClass().getName() + ". Expected Request and Response.");
                    continue;
                }
                DynExpress[] annotations = (DynExpress[])method.getAnnotationsByType(DynExpress.class);
                for (DynExpress dex : annotations) {
                    String context = dex.context();
                    String requestMethod = dex.method().getMethod();
                    this.handler.add(1, new FilterImpl(requestMethod, context, (req, res) -> {
                        try {
                            method.invoke(o, req, res);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }));
                }
            }
        }
        return this;
    }

    public void listen() {
        this.listen(null, 80);
    }

    public void listen(int port) {
        this.listen(null, port);
    }

    public void listen(ExpressListener onStart) {
        this.listen(onStart, 80);
    }

    public void listen(ExpressListener onStart, int port) {
        new Thread(() -> {
            try {
                InetSocketAddress socketAddress;
                this.worker.forEach(FilterWorker::start);
                InetSocketAddress inetSocketAddress = socketAddress = this.hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(this.hostname, port);
                if (this.httpsConfigurator != null) {
                    this.httpServer = HttpsServer.create(socketAddress, 0);
                    ((HttpsServer)this.httpServer).setHttpsConfigurator(this.httpsConfigurator);
                } else {
                    this.httpServer = HttpServer.create(socketAddress, 0);
                }
                this.httpServer.setExecutor(this.executor);
                this.httpServer.createContext("/", exchange -> this.handler.handle(exchange, this));
                this.httpServer.start();
                if (onStart != null) {
                    onStart.action();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void stop() {
        if (this.httpServer != null) {
            this.httpServer.stop(0);
            this.worker.forEach(FilterWorker::stop);
        }
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }
}

