/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffFileHeader;
import org.jaudiotagger.audio.aiff.chunk.AiffChunkReader;
import org.jaudiotagger.audio.aiff.chunk.AiffChunkType;
import org.jaudiotagger.audio.aiff.chunk.ID3Chunk;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.ChunkSummary;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.tag.aiff.AiffTag;

public class AiffTagReader
extends AiffChunkReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.aiff");
    private String loggingName;

    public AiffTagReader(String loggingName) {
        this.loggingName = loggingName;
    }

    public AiffTag read(Path file) throws CannotReadException, IOException {
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            AiffAudioHeader aiffAudioHeader = new AiffAudioHeader();
            AiffTag aiffTag = new AiffTag();
            AiffFileHeader fileHeader = new AiffFileHeader(file.toString());
            long overallChunkSize = fileHeader.readHeader(fc, aiffAudioHeader);
            aiffTag.setFormSize(overallChunkSize);
            aiffTag.setFileSize(fc.size());
            long endLocationOfAiffData = overallChunkSize + 8L;
            while (fc.position() < endLocationOfAiffData && fc.position() < fc.size() && this.readChunk(fc, aiffTag)) {
            }
            if (aiffTag.getID3Tag() == null) {
                aiffTag.setID3Tag(AiffTag.createDefaultID3Tag());
            }
            if (fc.position() > endLocationOfAiffData) {
                aiffTag.setLastChunkSizeExtendsPastFormSize(true);
            }
            AiffTag aiffTag2 = aiffTag;
            return aiffTag2;
        }
    }

    private boolean readChunk(FileChannel fc, AiffTag aiffTag) throws IOException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        if (!chunkHeader.readHeader(fc)) {
            return false;
        }
        long startLocationOfId3TagInFile = fc.position();
        AiffChunkType chunkType = AiffChunkType.get(chunkHeader.getID());
        if (chunkType != null && chunkType == AiffChunkType.TAG && chunkHeader.getSize() > 0L) {
            ByteBuffer chunkData = this.readChunkDataIntoBuffer(fc, chunkHeader);
            aiffTag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
            if (aiffTag.getID3Tag() == null) {
                ID3Chunk chunk = new ID3Chunk(chunkHeader, chunkData, aiffTag, this.loggingName);
                ((Chunk)chunk).readChunk();
                aiffTag.setExistingId3Tag(true);
                aiffTag.getID3Tag().setStartLocationInFile(startLocationOfId3TagInFile);
                aiffTag.getID3Tag().setEndLocationInFile(fc.position());
            }
        } else {
            if (chunkType != null && chunkType == AiffChunkType.CORRUPT_TAG_LATE) {
                if (aiffTag.getID3Tag() == null) {
                    aiffTag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 9L);
                return true;
            }
            if (chunkType != null && chunkType == AiffChunkType.CORRUPT_TAG_EARLY) {
                if (aiffTag.getID3Tag() == null) {
                    aiffTag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 7L);
                return true;
            }
            aiffTag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
            fc.position(fc.position() + chunkHeader.getSize());
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }
}

