/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.io.WriteableChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class MetadataContainer
extends Chunk
implements WriteableChunk {
    private final ContainerType containerType;
    private final Map<DescriptorPointer, List<MetadataDescriptor>> descriptors = new Hashtable<DescriptorPointer, List<MetadataDescriptor>>();
    private final DescriptorPointer perfPoint = new DescriptorPointer(new MetadataDescriptor(""));

    private static ContainerType determineType(GUID guid) throws IllegalArgumentException {
        assert (guid != null);
        ContainerType result = null;
        for (ContainerType curr : ContainerType.values()) {
            if (!curr.getContainerGUID().equals(guid)) continue;
            result = curr;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown metadata container specified by GUID (" + guid.toString() + ")");
        }
        return result;
    }

    public MetadataContainer(ContainerType type) {
        this(type, 0L, BigInteger.ZERO);
    }

    public MetadataContainer(ContainerType type, long pos, BigInteger size) {
        super(type.getContainerGUID(), pos, size);
        this.containerType = type;
    }

    public MetadataContainer(GUID containerGUID, long pos, BigInteger size) {
        this(MetadataContainer.determineType(containerGUID), pos, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDescriptor(MetadataDescriptor toAdd) throws IllegalArgumentException {
        List<MetadataDescriptor> list;
        this.containerType.assertConstraints(toAdd.getName(), toAdd.getRawData(), toAdd.getType(), toAdd.getStreamNumber(), toAdd.getLanguageIndex());
        if (!this.isAddSupported(toAdd)) {
            throw new IllegalArgumentException("Descriptor cannot be added, see isAddSupported(...)");
        }
        DescriptorPointer descriptorPointer = this.perfPoint;
        synchronized (descriptorPointer) {
            list = this.descriptors.get(this.perfPoint.setDescriptor(toAdd));
        }
        if (list == null) {
            list = new ArrayList<MetadataDescriptor>();
            this.descriptors.put(new DescriptorPointer(toAdd), list);
        } else if (!list.isEmpty() && !this.containerType.isMultiValued()) {
            throw new IllegalArgumentException("Container does not allow multiple values of descriptors with same name, language index and stream number");
        }
        list.add(toAdd);
    }

    protected final MetadataDescriptor assertDescriptor(String key) {
        return this.assertDescriptor(key, 0);
    }

    protected final MetadataDescriptor assertDescriptor(String key, int type) {
        MetadataDescriptor desc;
        List<MetadataDescriptor> descriptorsByName = this.getDescriptorsByName(key);
        if (descriptorsByName == null || descriptorsByName.isEmpty()) {
            desc = new MetadataDescriptor(this.getContainerType(), key, type);
            this.addDescriptor(desc);
        } else {
            desc = descriptorsByName.get(0);
        }
        return desc;
    }

    public final boolean containsDescriptor(MetadataDescriptor lookup) {
        assert (lookup != null);
        return this.descriptors.containsKey(this.perfPoint.setDescriptor(lookup));
    }

    public final ContainerType getContainerType() {
        return this.containerType;
    }

    @Override
    public long getCurrentAsfChunkSize() {
        long result = 26L;
        for (MetadataDescriptor curr : this.getDescriptors()) {
            result += (long)curr.getCurrentAsfSize(this.containerType);
        }
        return result;
    }

    public final int getDescriptorCount() {
        return this.getDescriptors().size();
    }

    public final List<MetadataDescriptor> getDescriptors() {
        ArrayList<MetadataDescriptor> result = new ArrayList<MetadataDescriptor>();
        for (List<MetadataDescriptor> curr : this.descriptors.values()) {
            result.addAll(curr);
        }
        return result;
    }

    public final List<MetadataDescriptor> getDescriptorsByName(String name) {
        assert (name != null);
        ArrayList<MetadataDescriptor> result = new ArrayList<MetadataDescriptor>();
        Collection<List<MetadataDescriptor>> values2 = this.descriptors.values();
        for (List<MetadataDescriptor> currList : values2) {
            if (currList.isEmpty() || !currList.get(0).getName().equals(name)) continue;
            result.addAll(currList);
        }
        return result;
    }

    protected final String getValueFor(String name) {
        String result = "";
        List<MetadataDescriptor> descs = this.getDescriptorsByName(name);
        if (descs != null) {
            assert (descs.size() <= 1);
            if (!descs.isEmpty()) {
                result = descs.get(0).getString();
            }
        }
        return result;
    }

    public final boolean hasDescriptor(String name) {
        return !this.getDescriptorsByName(name).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddSupported(MetadataDescriptor descriptor2) {
        boolean result;
        boolean bl = result = this.getContainerType().checkConstraints(descriptor2.getName(), descriptor2.getRawData(), descriptor2.getType(), descriptor2.getStreamNumber(), descriptor2.getLanguageIndex()) == null;
        if (result && !this.getContainerType().isMultiValued()) {
            DescriptorPointer descriptorPointer = this.perfPoint;
            synchronized (descriptorPointer) {
                List<MetadataDescriptor> list = this.descriptors.get(this.perfPoint.setDescriptor(descriptor2));
                if (list != null) {
                    result = list.isEmpty();
                }
            }
        }
        return result;
    }

    @Override
    public final boolean isEmpty() {
        boolean result;
        if (this.getDescriptorCount() != 0) {
            Iterator<MetadataDescriptor> iterator2 = this.getDescriptors().iterator();
            for (result = true; result && iterator2.hasNext(); result &= iterator2.next().isEmpty()) {
            }
        }
        return result;
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        for (MetadataDescriptor curr : this.getDescriptors()) {
            result.append(prefix).append("  |-> ");
            result.append(curr);
            result.append(Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public final void removeDescriptorsByName(String name) {
        assert (name != null);
        Iterator<List<MetadataDescriptor>> iterator2 = this.descriptors.values().iterator();
        while (iterator2.hasNext()) {
            List<MetadataDescriptor> curr = iterator2.next();
            if (curr.isEmpty() || !curr.get(0).getName().equals(name)) continue;
            iterator2.remove();
        }
    }

    protected final void setStringValue(String name, String value) {
        this.assertDescriptor(name).setStringValue(value);
    }

    @Override
    public long writeInto(OutputStream out) throws IOException {
        long chunkSize = this.getCurrentAsfChunkSize();
        List<MetadataDescriptor> descriptorList = this.getDescriptors();
        out.write(this.getGuid().getBytes());
        Utils.writeUINT64(chunkSize, out);
        Utils.writeUINT16(descriptorList.size(), out);
        for (MetadataDescriptor curr : descriptorList) {
            curr.writeInto(out, this.containerType);
        }
        return chunkSize;
    }

    private static final class DescriptorPointer {
        private MetadataDescriptor desc;

        public DescriptorPointer(MetadataDescriptor descriptor2) {
            this.setDescriptor(descriptor2);
        }

        public boolean equals(Object obj) {
            boolean result;
            boolean bl = result = obj == this;
            if (obj instanceof DescriptorPointer && !result) {
                MetadataDescriptor other = ((DescriptorPointer)obj).desc;
                result = this.desc.getName().equals(other.getName());
                result &= this.desc.getLanguageIndex() == other.getLanguageIndex();
                result &= this.desc.getStreamNumber() == other.getStreamNumber();
            }
            return result;
        }

        public int hashCode() {
            int hashCode = this.desc.getName().hashCode();
            hashCode = hashCode * 31 + this.desc.getLanguageIndex();
            hashCode = hashCode * 31 + this.desc.getStreamNumber();
            return hashCode;
        }

        protected DescriptorPointer setDescriptor(MetadataDescriptor descriptor2) {
            assert (descriptor2 != null);
            this.desc = descriptor2;
            return this;
        }
    }
}

