/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dsf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.dsf.DsdChunk;
import org.jaudiotagger.audio.dsf.DsfChunkType;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.IffHeaderChunk;

public class FmtChunk {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.dsf.FmtChunk");
    public static final int FMT_CHUNK_MIN_DATA_SIZE_ = 40;
    private long chunkSizeLength;

    public static FmtChunk readChunkHeader(ByteBuffer dataBuffer) {
        String type = Utils.readFourBytesAsChars(dataBuffer);
        if (DsfChunkType.FORMAT.getCode().equals(type)) {
            return new FmtChunk(dataBuffer);
        }
        return null;
    }

    private FmtChunk(ByteBuffer dataBuffer) {
        this.chunkSizeLength = dataBuffer.getLong();
    }

    public GenericAudioHeader readChunkData(DsdChunk dsd, FileChannel fc) throws IOException {
        long sizeExcludingChunkHeader = this.chunkSizeLength - (long)(IffHeaderChunk.SIGNATURE_LENGTH + 8);
        ByteBuffer audioData = Utils.readFileDataIntoBufferLE(fc, (int)sizeExcludingChunkHeader);
        return this.readAudioInfo(dsd, audioData);
    }

    private GenericAudioHeader readAudioInfo(DsdChunk dsd, ByteBuffer audioInfoChunk) {
        GenericAudioHeader audioHeader = new GenericAudioHeader();
        if (audioInfoChunk.limit() < 40) {
            return audioHeader;
        }
        audioInfoChunk.order(ByteOrder.LITTLE_ENDIAN);
        int version = audioInfoChunk.getInt();
        int formatId = audioInfoChunk.getInt();
        int channelType = audioInfoChunk.getInt();
        int channelNumber = audioInfoChunk.getInt();
        int samplingFreqency = audioInfoChunk.getInt();
        int bitsPerSample = audioInfoChunk.getInt();
        long sampleCount = audioInfoChunk.getLong();
        int blocksPerSample = audioInfoChunk.getInt();
        audioHeader.setEncodingType("DSF");
        audioHeader.setFormat(SupportedFileFormat.DSF.getDisplayName());
        audioHeader.setBitRate(bitsPerSample * samplingFreqency * channelNumber);
        audioHeader.setBitsPerSample(bitsPerSample);
        audioHeader.setChannelNumber(channelNumber);
        audioHeader.setSamplingRate(samplingFreqency);
        audioHeader.setNoOfSamples(sampleCount);
        audioHeader.setPreciseLength((float)sampleCount / (float)samplingFreqency);
        audioHeader.setVariableBitRate(false);
        return audioHeader;
    }
}

