/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;

public class FlacStreamReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    public static final int FLAC_STREAM_IDENTIFIER_LENGTH = 4;
    public static final String FLAC_STREAM_IDENTIFIER = "fLaC";
    private FileChannel fc;
    private String loggingName;
    private int startOfFlacInFile;

    public FlacStreamReader(FileChannel fc, String loggingName) {
        this.fc = fc;
        this.loggingName = loggingName;
    }

    public void findStream() throws IOException, CannotReadException {
        if (this.fc.size() == 0L) {
            throw new CannotReadException("Error: File empty " + this.loggingName);
        }
        this.fc.position(0L);
        if (this.isFlacHeader()) {
            this.startOfFlacInFile = 0;
            return;
        }
        if (this.isId3v2Tag()) {
            this.startOfFlacInFile = (int)(this.fc.position() - 4L);
            return;
        }
        throw new CannotReadException(this.loggingName + ErrorMessage.FLAC_NO_FLAC_HEADER_FOUND.getMsg());
    }

    private boolean isId3v2Tag() throws IOException {
        this.fc.position(0L);
        return AbstractID3v2Tag.isId3Tag(this.fc) && this.isFlacHeader();
    }

    private boolean isFlacHeader() throws IOException {
        ByteBuffer headerBuffer = Utils.readFileDataIntoBufferBE(this.fc, 4);
        return Utils.readFourBytesAsChars(headerBuffer).equals(FLAC_STREAM_IDENTIFIER);
    }

    public int getStartOfFlacInFile() {
        return this.startOfFlacInFile;
    }
}

