/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.audio.generic.AbstractTagCreator;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentCreator;

public class FlacTagCreator
extends AbstractTagCreator {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    public static final int DEFAULT_PADDING = 4000;
    private static final VorbisCommentCreator creator = new VorbisCommentCreator();

    @Override
    public ByteBuffer convertMetadata(Tag tag, boolean isLastBlock) throws UnsupportedEncodingException {
        FlacTag flacTag = (FlacTag)tag;
        int tagLength = 0;
        ByteBuffer vorbiscomment = null;
        if (flacTag.getVorbisCommentTag() != null) {
            vorbiscomment = creator.convertMetadata(flacTag.getVorbisCommentTag());
            tagLength = vorbiscomment.capacity() + 4;
        }
        for (MetadataBlockDataPicture image : flacTag.getImages()) {
            tagLength += image.getBytes().limit() + 4;
        }
        ByteBuffer buf = ByteBuffer.allocate(tagLength);
        if (flacTag.getVorbisCommentTag() != null) {
            MetadataBlockHeader vorbisHeader = isLastBlock || flacTag.getImages().size() > 0 ? new MetadataBlockHeader(false, BlockType.VORBIS_COMMENT, vorbiscomment.capacity()) : new MetadataBlockHeader(true, BlockType.VORBIS_COMMENT, vorbiscomment.capacity());
            buf.put(vorbisHeader.getBytes());
            buf.put(vorbiscomment);
        }
        ListIterator<MetadataBlockDataPicture> li = flacTag.getImages().listIterator();
        while (li.hasNext()) {
            MetadataBlockDataPicture imageField = li.next();
            MetadataBlockHeader imageHeader = isLastBlock || li.hasNext() ? new MetadataBlockHeader(false, BlockType.PICTURE, imageField.getLength()) : new MetadataBlockHeader(true, BlockType.PICTURE, imageField.getLength());
            buf.put(imageHeader.getBytes());
            buf.put(imageField.getBytes());
        }
        buf.rewind();
        return buf;
    }
}

