/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.NoWritePermissionsException;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.FlacTagCreator;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlock;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataApplication;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataCueSheet;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPadding;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataSeekTable;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataStreamInfo;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.utils.ShiftData;

public class FlacTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    private FlacTagCreator tc = new FlacTagCreator();

    public void delete(Tag tag, Path file) throws CannotWriteException {
        FlacTag emptyTag = new FlacTag(null, new ArrayList<MetadataBlockDataPicture>());
        this.write(emptyTag, file);
    }

    public void write(Tag tag, Path file) throws CannotWriteException {
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            MetadataBlockInfo blockInfo = new MetadataBlockInfo();
            FlacStreamReader flacStream = new FlacStreamReader(fc, file.toString() + " ");
            try {
                flacStream.findStream();
            }
            catch (CannotReadException cre) {
                throw new CannotWriteException(cre.getMessage());
            }
            boolean isLastBlock = false;
            while (!isLastBlock) {
                try {
                    MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(fc);
                    if (mbh.getBlockType() != null) {
                        switch (mbh.getBlockType()) {
                            case STREAMINFO: {
                                blockInfo.streamInfoBlock = new MetadataBlock(mbh, new MetadataBlockDataStreamInfo(mbh, fc));
                                break;
                            }
                            case VORBIS_COMMENT: 
                            case PADDING: 
                            case PICTURE: {
                                fc.position(fc.position() + (long)mbh.getDataLength());
                                MetadataBlockData mbd = new MetadataBlockDataPadding(mbh.getDataLength());
                                blockInfo.metadataBlockPadding.add(new MetadataBlock(mbh, mbd));
                                break;
                            }
                            case APPLICATION: {
                                MetadataBlockData mbd = new MetadataBlockDataApplication(mbh, fc);
                                blockInfo.metadataBlockApplication.add(new MetadataBlock(mbh, mbd));
                                break;
                            }
                            case SEEKTABLE: {
                                MetadataBlockData mbd = new MetadataBlockDataSeekTable(mbh, fc);
                                blockInfo.metadataBlockSeekTable.add(new MetadataBlock(mbh, mbd));
                                break;
                            }
                            case CUESHEET: {
                                MetadataBlockData mbd = new MetadataBlockDataCueSheet(mbh, fc);
                                blockInfo.metadataBlockCueSheet.add(new MetadataBlock(mbh, mbd));
                                break;
                            }
                            default: {
                                fc.position(fc.position() + (long)mbh.getDataLength());
                            }
                        }
                    }
                    isLastBlock = mbh.isLastBlock();
                }
                catch (CannotReadException cre) {
                    throw new CannotWriteException(cre.getMessage());
                }
            }
            int availableRoom = blockInfo.computeAvailableRoom();
            int newTagSize = this.tc.convertMetadata(tag).limit();
            int otherBlocksRequiredSize = blockInfo.computeNeededRoom();
            int neededRoom = newTagSize + otherBlocksRequiredSize;
            fc.position(flacStream.getStartOfFlacInFile());
            if (availableRoom == neededRoom || availableRoom > neededRoom + 4) {
                this.writeAllNonAudioData(tag, fc, blockInfo, flacStream, availableRoom - neededRoom);
            } else {
                this.insertUsingChunks(file, tag, fc, blockInfo, flacStream, neededRoom + 4000, availableRoom);
            }
        }
        catch (AccessDeniedException ade) {
            throw new NoWritePermissionsException(file + ":" + ade.getMessage());
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    public ByteBuffer addPaddingBlock(int paddingSize) throws UnsupportedEncodingException {
        ByteBuffer buf = ByteBuffer.allocate(paddingSize);
        if (paddingSize > 0) {
            int paddingDataSize = paddingSize - 4;
            MetadataBlockHeader paddingHeader = new MetadataBlockHeader(true, BlockType.PADDING, paddingDataSize);
            MetadataBlockDataPadding padding = new MetadataBlockDataPadding(paddingDataSize);
            buf.put(paddingHeader.getBytes());
            buf.put(padding.getBytes());
            buf.rewind();
        }
        return buf;
    }

    private void writeAllNonAudioData(Tag tag, FileChannel fc, MetadataBlockInfo blockInfo, FlacStreamReader flacStream, int padding) throws IOException {
        fc.position(flacStream.getStartOfFlacInFile() + 4);
        this.writeStreamBlock(fc, blockInfo);
        fc.write(this.tc.convertMetadata(tag, padding > 0 || blockInfo.getOtherBlockCount(blockInfo) > 0));
        List<MetadataBlock> blocks = blockInfo.getListOfNonMetadataBlocks();
        if (blocks.size() > 1) {
            for (int i = 0; i < blocks.size() - 1; ++i) {
                fc.write(ByteBuffer.wrap(blocks.get(i).getHeader().getBytesWithoutIsLastBlockFlag()));
                fc.write(blocks.get(i).getData().getBytes());
            }
        }
        if (blocks.size() > 0) {
            if (padding > 0) {
                fc.write(ByteBuffer.wrap(blocks.get(blocks.size() - 1).getHeader().getBytesWithoutIsLastBlockFlag()));
            } else {
                fc.write(ByteBuffer.wrap(blocks.get(blocks.size() - 1).getHeader().getBytesWithLastBlockFlag()));
            }
            fc.write(blocks.get(blocks.size() - 1).getData().getBytes());
        }
        if (padding > 0) {
            fc.write(this.addPaddingBlock(padding));
        }
    }

    private void insertUsingChunks(Path file, Tag tag, FileChannel fc, MetadataBlockInfo blockInfo, FlacStreamReader flacStream, int neededRoom, int availableRoom) throws IOException, UnsupportedEncodingException {
        long audioStart = flacStream.getStartOfFlacInFile() + 4 + 4 + 34 + availableRoom;
        int extraSpaceRequired = neededRoom - availableRoom;
        fc.position(audioStart);
        ShiftData.shiftDataByOffsetToMakeSpace(fc, extraSpaceRequired);
        fc.position(flacStream.getStartOfFlacInFile() + 4);
        this.writeAllNonAudioData(tag, fc, blockInfo, flacStream, 4000);
    }

    private void writeStreamBlock(FileChannel fc, MetadataBlockInfo blockInfo) throws IOException {
        fc.write(ByteBuffer.wrap(blockInfo.streamInfoBlock.getHeader().getBytesWithoutIsLastBlockFlag()));
        fc.write(blockInfo.streamInfoBlock.getData().getBytes());
    }

    private static class MetadataBlockInfo {
        private List<MetadataBlock> blocks = new ArrayList<MetadataBlock>();
        private MetadataBlock streamInfoBlock;
        private List<MetadataBlock> metadataBlockPadding = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockApplication = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockSeekTable = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockCueSheet = new ArrayList<MetadataBlock>(1);

        private MetadataBlockInfo() {
        }

        public List<MetadataBlock> getListOfNonMetadataBlocks() {
            for (MetadataBlock next : this.metadataBlockSeekTable) {
                this.blocks.add(next);
            }
            for (MetadataBlock next : this.metadataBlockCueSheet) {
                this.blocks.add(next);
            }
            for (MetadataBlock next : this.metadataBlockApplication) {
                this.blocks.add(next);
            }
            return this.blocks;
        }

        private int getOtherBlockCount(MetadataBlockInfo blockInfo) {
            int count = blockInfo.metadataBlockApplication.size();
            count += blockInfo.metadataBlockSeekTable.size();
            return count += blockInfo.metadataBlockCueSheet.size();
        }

        public int computeAvailableRoom() {
            int length = 0;
            for (MetadataBlock aMetadataBlockApplication : this.metadataBlockApplication) {
                length += aMetadataBlockApplication.getLength();
            }
            for (MetadataBlock aMetadataBlockSeekTable : this.metadataBlockSeekTable) {
                length += aMetadataBlockSeekTable.getLength();
            }
            for (MetadataBlock aMetadataBlockCueSheet : this.metadataBlockCueSheet) {
                length += aMetadataBlockCueSheet.getLength();
            }
            for (MetadataBlock aMetadataBlockPadding : this.metadataBlockPadding) {
                length += aMetadataBlockPadding.getLength();
            }
            return length;
        }

        public int computeNeededRoom() {
            int length = 0;
            for (MetadataBlock aMetadataBlockApplication : this.metadataBlockApplication) {
                length += aMetadataBlockApplication.getLength();
            }
            for (MetadataBlock aMetadataBlockSeekTable : this.metadataBlockSeekTable) {
                length += aMetadataBlockSeekTable.getLength();
            }
            for (MetadataBlock aMetadataBlockCueSheet : this.metadataBlockCueSheet) {
                length += aMetadataBlockCueSheet.getLength();
            }
            return length;
        }
    }
}

