/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.NoReadPermissionsException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;

public abstract class AudioFileReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic");
    protected static final int MINIMUM_SIZE_FOR_VALID_AUDIO_FILE = 100;

    protected abstract GenericAudioHeader getEncodingInfo(RandomAccessFile var1) throws CannotReadException, IOException;

    protected abstract Tag getTag(RandomAccessFile var1) throws CannotReadException, IOException;

    public AudioFile read(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        if (logger.isLoggable(Level.CONFIG)) {
            // empty if block
        }
        if (!Files.isReadable(f.toPath())) {
            if (!Files.exists(f.toPath(), new LinkOption[0])) {
                throw new FileNotFoundException(ErrorMessage.UNABLE_TO_FIND_FILE.getMsg(f.toPath()));
            }
            throw new NoReadPermissionsException(ErrorMessage.GENERAL_READ_FAILED_DO_NOT_HAVE_PERMISSION_TO_READ_FILE.getMsg(f.toPath()));
        }
        if (f.length() <= 100L) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_FILE_TOO_SMALL.getMsg(f.getAbsolutePath()));
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            raf.seek(0L);
            GenericAudioHeader info = this.getEncodingInfo(raf);
            raf.seek(0L);
            Tag tag = this.getTag(raf);
            AudioFile audioFile = new AudioFile(f, (AudioHeader)info, tag);
            return audioFile;
        }
        catch (CannotReadException cre) {
            throw cre;
        }
        catch (Exception e) {
            throw new CannotReadException(f.getAbsolutePath() + ":" + e.getMessage(), e);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

