/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.ModifyVetoException;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;

public abstract class AudioFileWriter {
    private static final String TEMP_FILENAME_SUFFIX = ".tmp";
    private static final String WRITE_MODE = "rw";
    protected static final int MINIMUM_FILESIZE = 100;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic");
    private static final String FILE_NAME_TOO_LONG = "File name too long";
    private static final int FILE_NAME_TOO_LONG_SAFE_LIMIT = 50;
    private AudioFileModificationListener modificationListener = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(AudioFile af) throws CannotReadException, CannotWriteException {
        File result;
        Path file = af.getFile().toPath();
        if (TagOptionSingleton.getInstance().isCheckIsWritable() && !Files.isWritable(file)) {
            throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(file));
        }
        if (af.getFile().length() <= 100L) {
            throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file));
        }
        RandomAccessFile raf = null;
        RandomAccessFile rafTemp = null;
        File tempF = null;
        boolean revert = false;
        try {
            tempF = File.createTempFile(af.getFile().getName().replace('.', '_'), TEMP_FILENAME_SUFFIX, af.getFile().getParentFile());
            rafTemp = new RandomAccessFile(tempF, WRITE_MODE);
            raf = new RandomAccessFile(af.getFile(), WRITE_MODE);
            raf.seek(0L);
            rafTemp.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(af, true);
                }
                this.deleteTag(af.getTag(), raf, rafTemp);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(af, tempF);
                }
            }
            catch (ModifyVetoException veto) {
                throw new CannotWriteException(veto);
            }
            result = af.getFile();
        }
        catch (Exception e) {
            try {
                revert = true;
                throw new CannotWriteException("\"" + af.getFile().getAbsolutePath() + "\" :" + e, e);
            }
            catch (Throwable throwable) {
                File result2 = af.getFile();
                try {
                    if (raf != null) {
                        raf.close();
                    }
                    if (rafTemp != null) {
                        rafTemp.close();
                    }
                    if (tempF.length() > 0L && !revert) {
                        boolean deleteResult = af.getFile().delete();
                        if (!deleteResult) {
                            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                        }
                        boolean renameResult = tempF.renameTo(af.getFile());
                        if (!renameResult) {
                            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                        }
                        result2 = tempF;
                        if (tempF.exists() && tempF.delete()) {
                            // empty if block
                        }
                    } else if (tempF.delete()) {
                        // empty if block
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.modificationListener == null) throw throwable;
                this.modificationListener.fileOperationFinished(result2);
                throw throwable;
            }
        }
        try {
            if (raf != null) {
                raf.close();
            }
            if (rafTemp != null) {
                rafTemp.close();
            }
            if (tempF.length() > 0L && !revert) {
                boolean deleteResult = af.getFile().delete();
                if (!deleteResult) {
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                }
                boolean renameResult = tempF.renameTo(af.getFile());
                if (!renameResult) {
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                }
                result = tempF;
                if (tempF.exists() && tempF.delete()) {
                    // empty if block
                }
            } else if (tempF.delete()) {
                // empty if block
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.modificationListener == null) return;
        this.modificationListener.fileOperationFinished(result);
    }

    public void delete(Tag tag, RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotReadException, CannotWriteException, IOException {
        raf.seek(0L);
        tempRaf.seek(0L);
        this.deleteTag(tag, raf, tempRaf);
    }

    protected abstract void deleteTag(Tag var1, RandomAccessFile var2, RandomAccessFile var3) throws CannotReadException, CannotWriteException, IOException;

    public void setAudioFileModificationListener(AudioFileModificationListener listener) {
        this.modificationListener = listener;
    }

    private void precheckWrite(AudioFile af) throws CannotWriteException {
        try {
            if (af.getTag().isEmpty()) {
                this.delete(af);
                return;
            }
        }
        catch (CannotReadException re) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(af.getFile().getPath()));
        }
        Path file = af.getFile().toPath();
        if (TagOptionSingleton.getInstance().isCheckIsWritable() && !Files.isWritable(file)) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file));
        }
        if (af.getFile().length() <= 100L) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file));
        }
    }

    public void write(AudioFile af) throws CannotWriteException {
        File newFile;
        this.precheckWrite(af);
        if (af instanceof MP3File) {
            af.commit();
            return;
        }
        RandomAccessFile raf = null;
        RandomAccessFile rafTemp = null;
        try {
            newFile = File.createTempFile(af.getFile().getName().replace('.', '_'), TEMP_FILENAME_SUFFIX, af.getFile().getParentFile());
        }
        catch (IOException ioe) {
            if (ioe.getMessage().equals(FILE_NAME_TOO_LONG) && af.getFile().getName().length() > 50) {
                try {
                    newFile = File.createTempFile(af.getFile().getName().substring(0, 50).replace('.', '_'), TEMP_FILENAME_SUFFIX, af.getFile().getParentFile());
                }
                catch (IOException ioe2) {
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(af.getFile().getName(), af.getFile().getParentFile().getAbsolutePath()));
                }
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(af.getFile().getName(), af.getFile().getParentFile().getAbsolutePath()));
        }
        try {
            rafTemp = new RandomAccessFile(newFile, WRITE_MODE);
            raf = new RandomAccessFile(af.getFile(), WRITE_MODE);
        }
        catch (IOException ioe) {
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!newFile.delete()) {
                // empty if block
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(af.getFile().getAbsolutePath()));
        }
        try {
            raf.seek(0L);
            rafTemp.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(af, false);
                }
                this.writeTag(af, af.getTag(), raf, rafTemp);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(af, newFile);
                }
            }
            catch (ModifyVetoException veto) {
                throw new CannotWriteException(veto);
            }
        }
        catch (Exception e) {
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!newFile.delete()) {
                // empty if block
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE.getMsg(af.getFile(), e.getMessage()));
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
            }
            catch (IOException iOException) {}
        }
        File result = af.getFile();
        if (newFile.length() > 0L) {
            this.transferNewFileToOriginalFile(newFile, af.getFile(), TagOptionSingleton.getInstance().isPreserveFileIdentity());
        } else if (!newFile.delete()) {
            // empty if block
        }
        if (this.modificationListener != null) {
            this.modificationListener.fileOperationFinished(result);
        }
    }

    private void transferNewFileToOriginalFile(File newFile, File originalFile, boolean reuseExistingOriginalFile) throws CannotWriteException {
        if (reuseExistingOriginalFile) {
            this.transferNewFileContentToOriginalFile(newFile, originalFile);
        } else {
            this.transferNewFileToNewOriginalFile(newFile, originalFile);
        }
    }

    private void transferNewFileContentToOriginalFile(File newFile, File originalFile) throws CannotWriteException {
        block19: {
            try (RandomAccessFile raf = new RandomAccessFile(originalFile, WRITE_MODE);){
                FileChannel outChannel = raf.getChannel();
                try (FileLock lock = outChannel.tryLock();){
                    if (lock != null) {
                        this.transferNewFileContentToOriginalFile(newFile, originalFile, raf, outChannel);
                        break block19;
                    }
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_FILE_LOCKED.getMsg(originalFile.getPath()));
                }
                catch (IOException e) {
                    if ("Operation not supported".equals(e.getMessage())) {
                        this.transferNewFileContentToOriginalFile(newFile, originalFile, raf, outChannel);
                        break block19;
                    }
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_FILE_LOCKED.getMsg(originalFile.getPath()), e);
                }
                catch (Exception e) {
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_FILE_LOCKED.getMsg(originalFile.getPath()), e);
                }
            }
            catch (FileNotFoundException e) {
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(originalFile.getPath()), e);
            }
            catch (Exception e) {
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(originalFile.getPath()), e);
            }
        }
    }

    private void transferNewFileContentToOriginalFile(File newFile, File originalFile, RandomAccessFile raf, FileChannel outChannel) throws CannotWriteException {
        try (FileInputStream fileInputStream = new FileInputStream(newFile);){
            FileChannel inChannel = fileInputStream.getChannel();
            long size = inChannel.size();
            for (long position = 0L; position < size; position += inChannel.transferTo(position, 0x100000L, outChannel)) {
            }
            raf.setLength(size);
        }
        catch (FileNotFoundException e) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_NEW_FILE_DOESNT_EXIST.getMsg(newFile.getName()), e);
        }
        catch (IOException e) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(originalFile.getAbsolutePath(), newFile.getName()), e);
        }
        if (!newFile.exists() || !newFile.delete()) {
            // empty if block
        }
    }

    private void transferNewFileToNewOriginalFile(File newFile, File originalFile) throws CannotWriteException {
        FileTime creationTime = this.getCreationTime(originalFile);
        File originalFileBackup = new File(originalFile.getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(originalFile) + ".old");
        int count = 1;
        while (originalFileBackup.exists()) {
            originalFileBackup = new File(originalFile.getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(originalFile) + ".old" + count);
            ++count;
        }
        boolean renameResult = Utils.rename(originalFile, originalFileBackup);
        if (!renameResult) {
            if (newFile != null) {
                newFile.delete();
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(originalFile.getPath(), originalFileBackup.getName()));
        }
        renameResult = Utils.rename(newFile, originalFile);
        if (!renameResult) {
            if (!newFile.exists()) {
                // empty if block
            }
            if (!originalFileBackup.renameTo(originalFile)) {
                // empty if block
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(originalFile.getAbsolutePath(), newFile.getName()));
        }
        boolean deleteResult = originalFileBackup.delete();
        if (!deleteResult) {
            // empty if block
        }
        if (creationTime != null) {
            this.setCreationTime(originalFile, creationTime);
        }
        if (!newFile.exists() || !newFile.delete()) {
            // empty if block
        }
    }

    private void setCreationTime(File file, FileTime creationTime) {
        try {
            Files.setAttribute(file.toPath(), "creationTime", creationTime, new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private FileTime getCreationTime(File file) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attributes.creationTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected abstract void writeTag(AudioFile var1, Tag var2, RandomAccessFile var3, RandomAccessFile var4) throws CannotReadException, CannotWriteException, IOException;
}

