/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.generic.AudioFileWriter;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;

public abstract class AudioFileWriter2
extends AudioFileWriter {
    @Override
    public void delete(AudioFile af) throws CannotReadException, CannotWriteException {
        Path file = af.getFile().toPath();
        if (TagOptionSingleton.getInstance().isCheckIsWritable() && !Files.isWritable(file)) {
            throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(file));
        }
        if (af.getFile().length() <= 100L) {
            throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file));
        }
        this.deleteTag(af.getTag(), file);
    }

    @Override
    public void write(AudioFile af) throws CannotWriteException {
        Path file = af.getFile().toPath();
        if (TagOptionSingleton.getInstance().isCheckIsWritable() && !Files.isWritable(file)) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file));
        }
        if (af.getFile().length() <= 100L) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file));
        }
        this.writeTag(af.getTag(), file);
    }

    protected abstract void deleteTag(Tag var1, Path var2) throws CannotReadException, CannotWriteException;

    @Override
    public void deleteTag(Tag tag, RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotReadException, CannotWriteException, IOException {
        throw new UnsupportedOperationException("Old method not used in version 2");
    }

    protected abstract void writeTag(Tag var1, Path var2) throws CannotWriteException;

    @Override
    protected void writeTag(AudioFile audioFile, Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotReadException, CannotWriteException, IOException {
        throw new UnsupportedOperationException("Old method not used in version 2");
    }
}

