/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.ogg.OggVorbisCommentTagCreator;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.jaudiotagger.audio.ogg.util.OggCRCFactory;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class OggVorbisTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private OggVorbisCommentTagCreator tc = new OggVorbisCommentTagCreator();
    private OggVorbisTagReader reader = new OggVorbisTagReader();

    public void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws IOException, CannotReadException, CannotWriteException {
        try {
            this.reader.read(raf);
        }
        catch (CannotReadException e) {
            this.write(VorbisCommentTag.createNewTag(), raf, tempRaf);
            return;
        }
        VorbisCommentTag emptyTag = VorbisCommentTag.createNewTag();
        raf.seek(0L);
        this.write(emptyTag, raf, tempRaf);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotReadException, CannotWriteException, IOException {
        OggPageHeader pageHeader = OggPageHeader.read(raf);
        raf.seek(pageHeader.getStartByte());
        rafTemp.getChannel().transferFrom(raf.getChannel(), 0L, pageHeader.getPageLength() + 27 + pageHeader.getSegmentTable().length);
        rafTemp.skipBytes(pageHeader.getPageLength() + 27 + pageHeader.getSegmentTable().length);
        OggPageHeader secondPageHeader = OggPageHeader.read(raf);
        long secondPageHeaderEndPos = raf.getFilePointer();
        raf.seek(0L);
        OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes = this.reader.readOggVorbisHeaderSizes(raf);
        ByteBuffer newComment = this.tc.convert(tag);
        int newCommentLength = newComment.capacity();
        int newSecondPageDataLength = vorbisHeaderSizes.getSetupHeaderSize() + newCommentLength + vorbisHeaderSizes.getExtraPacketDataSize();
        if (this.isCommentAndSetupHeaderFitsOnASinglePage(newCommentLength, vorbisHeaderSizes.getSetupHeaderSize(), vorbisHeaderSizes.getExtraPacketList())) {
            if (secondPageHeader.getPageLength() < 65025 && (secondPageHeader.getPacketList().size() == 2 && !secondPageHeader.isLastPacketIncomplete() || secondPageHeader.getPacketList().size() > 2)) {
                this.replaceSecondPageOnly(vorbisHeaderSizes, newCommentLength, newSecondPageDataLength, secondPageHeader, newComment, secondPageHeaderEndPos, raf, rafTemp);
            } else {
                this.replaceSecondPageAndRenumberPageSeqs(vorbisHeaderSizes, newCommentLength, newSecondPageDataLength, secondPageHeader, newComment, raf, rafTemp);
            }
        } else {
            this.replacePagesAndRenumberPageSeqs(vorbisHeaderSizes, newCommentLength, secondPageHeader, newComment, raf, rafTemp);
        }
    }

    private void calculateChecksumOverPage(ByteBuffer page) {
        page.putInt(22, 0);
        byte[] crc = OggCRCFactory.computeCRC(page.array());
        for (int i = 0; i < crc.length; ++i) {
            page.put(22 + i, crc[i]);
        }
        page.rewind();
    }

    private ByteBuffer startCreateBasicSecondPage(OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment) throws IOException {
        byte[] segmentTable = this.createSegmentTable(newCommentLength, vorbisHeaderSizes.getSetupHeaderSize(), vorbisHeaderSizes.getExtraPacketList());
        int newSecondPageHeaderLength = 27 + segmentTable.length;
        ByteBuffer secondPageBuffer = ByteBuffer.allocate(newSecondPageLength + newSecondPageHeaderLength);
        secondPageBuffer.order(ByteOrder.LITTLE_ENDIAN);
        secondPageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
        secondPageBuffer.put((byte)segmentTable.length);
        for (byte aSegmentTable : segmentTable) {
            secondPageBuffer.put(aSegmentTable);
        }
        secondPageBuffer.put(newComment);
        return secondPageBuffer;
    }

    private void replaceSecondPageOnly(OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment, long secondPageHeaderEndPos, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException {
        ByteBuffer secondPageBuffer = this.startCreateBasicSecondPage(vorbisHeaderSizes, newCommentLength, newSecondPageLength, secondPageHeader, newComment);
        raf.seek(secondPageHeaderEndPos);
        raf.skipBytes(vorbisHeaderSizes.getCommentHeaderSize());
        raf.getChannel().read(secondPageBuffer);
        this.calculateChecksumOverPage(secondPageBuffer);
        rafTemp.getChannel().write(secondPageBuffer);
        rafTemp.getChannel().transferFrom(raf.getChannel(), rafTemp.getFilePointer(), raf.length() - raf.getFilePointer());
    }

    private void replaceSecondPageAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes originalHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        ByteBuffer secondPageBuffer = this.startCreateBasicSecondPage(originalHeaderSizes, newCommentLength, newSecondPageLength, secondPageHeader, newComment);
        int pageSequence = secondPageHeader.getPageSequence();
        byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
        secondPageBuffer.put(setupHeaderData);
        this.calculateChecksumOverPage(secondPageBuffer);
        rafTemp.getChannel().write(secondPageBuffer);
        this.writeRemainingPages(pageSequence, raf, rafTemp);
    }

    private void replacePagesAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes originalHeaderSizes, int newCommentLength, OggPageHeader secondPageHeader, ByteBuffer newComment, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        int lastPageCommentPacketSize;
        Object nextPartOfComment;
        ByteBuffer pageBuffer;
        int pageHeaderLength;
        byte[] segmentTable;
        int pageSequence = secondPageHeader.getPageSequence();
        int noOfCompletePagesNeededForComment = newCommentLength / 65025;
        int newCommentOffset = 0;
        if (noOfCompletePagesNeededForComment > 0) {
            for (int i = 0; i < noOfCompletePagesNeededForComment; ++i) {
                segmentTable = this.createSegments(65025, false);
                pageHeaderLength = 27 + segmentTable.length;
                pageBuffer = ByteBuffer.allocate(pageHeaderLength + 65025);
                pageBuffer.order(ByteOrder.LITTLE_ENDIAN);
                pageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
                pageBuffer.put((byte)segmentTable.length);
                for (Object aSegmentTable : segmentTable) {
                    pageBuffer.put((byte)aSegmentTable);
                }
                nextPartOfComment = newComment.slice();
                ((ByteBuffer)nextPartOfComment).limit(65025);
                pageBuffer.put((ByteBuffer)nextPartOfComment);
                pageBuffer.putInt(18, pageSequence);
                ++pageSequence;
                if (i != 0) {
                    pageBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
                }
                this.calculateChecksumOverPage(pageBuffer);
                rafTemp.getChannel().write(pageBuffer);
                newComment.position(newCommentOffset += 65025);
            }
        }
        if (!this.isCommentAndSetupHeaderFitsOnASinglePage(lastPageCommentPacketSize = newCommentLength % 65025, originalHeaderSizes.getSetupHeaderSize(), originalHeaderSizes.getExtraPacketList())) {
            segmentTable = this.createSegments(lastPageCommentPacketSize, true);
            pageHeaderLength = 27 + segmentTable.length;
            pageBuffer = ByteBuffer.allocate(lastPageCommentPacketSize + pageHeaderLength);
            pageBuffer.order(ByteOrder.LITTLE_ENDIAN);
            pageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            pageBuffer.put((byte)segmentTable.length);
            nextPartOfComment = segmentTable;
            int n = ((byte[])nextPartOfComment).length;
            for (int i = 0; i < n; ++i) {
                Object aSegmentTable;
                aSegmentTable = nextPartOfComment[i];
                pageBuffer.put((byte)aSegmentTable);
            }
            newComment.position(newCommentOffset);
            pageBuffer.put(newComment.slice());
            pageBuffer.putInt(18, pageSequence);
            if (noOfCompletePagesNeededForComment > 0) {
                pageBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            }
            ++pageSequence;
            this.calculateChecksumOverPage(pageBuffer);
            rafTemp.getChannel().write(pageBuffer);
            segmentTable = this.createSegmentTable(originalHeaderSizes.getSetupHeaderSize(), originalHeaderSizes.getExtraPacketList());
            pageHeaderLength = 27 + segmentTable.length;
            byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
            ByteBuffer pageBuffer2 = ByteBuffer.allocate(setupHeaderData.length + pageHeaderLength);
            pageBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            pageBuffer2.put(secondPageHeader.getRawHeaderData(), 0, 26);
            pageBuffer2.put((byte)segmentTable.length);
            for (byte aSegmentTable : segmentTable) {
                pageBuffer2.put(aSegmentTable);
            }
            pageBuffer2.put(setupHeaderData);
            pageBuffer2.putInt(18, pageSequence);
            this.calculateChecksumOverPage(pageBuffer2);
            rafTemp.getChannel().write(pageBuffer2);
        } else {
            int newSecondPageDataLength = originalHeaderSizes.getSetupHeaderSize() + lastPageCommentPacketSize + originalHeaderSizes.getExtraPacketDataSize();
            newComment.position(newCommentOffset);
            ByteBuffer lastComment = newComment.slice();
            ByteBuffer lastHeaderBuffer = this.startCreateBasicSecondPage(originalHeaderSizes, lastPageCommentPacketSize, newSecondPageDataLength, secondPageHeader, lastComment);
            raf.seek(originalHeaderSizes.getSetupHeaderStartPosition());
            byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
            lastHeaderBuffer.put(setupHeaderData);
            lastHeaderBuffer.putInt(18, pageSequence);
            lastHeaderBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            this.calculateChecksumOverPage(lastHeaderBuffer);
            rafTemp.getChannel().write(lastHeaderBuffer);
        }
        this.writeRemainingPages(pageSequence, raf, rafTemp);
    }

    public void writeRemainingPages(int pageSequence, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        long startAudio = raf.getFilePointer();
        long startAudioWritten = rafTemp.getFilePointer();
        ByteBuffer bb = ByteBuffer.allocate((int)(raf.length() - raf.getFilePointer()));
        ByteBuffer bbTemp = ByteBuffer.allocate((int)(raf.length() - raf.getFilePointer()));
        raf.getChannel().read(bb);
        bb.rewind();
        long bytesToDiscard = 0L;
        while (bb.hasRemaining()) {
            OggPageHeader nextPage = null;
            try {
                nextPage = OggPageHeader.read(bb);
            }
            catch (CannotReadException cre) {
                bb.position(bb.position() - OggPageHeader.CAPTURE_PATTERN.length);
                if (Utils.readThreeBytesAsChars(bb).equals("TAG")) {
                    bytesToDiscard = bb.remaining() + "TAG".length();
                    break;
                }
                throw cre;
            }
            ByteBuffer nextPageHeaderBuffer = ByteBuffer.allocate(nextPage.getRawHeaderData().length + nextPage.getPageLength());
            nextPageHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            nextPageHeaderBuffer.put(nextPage.getRawHeaderData());
            ByteBuffer data = bb.slice();
            data.limit(nextPage.getPageLength());
            nextPageHeaderBuffer.put(data);
            nextPageHeaderBuffer.putInt(18, ++pageSequence);
            this.calculateChecksumOverPage(nextPageHeaderBuffer);
            bb.position(bb.position() + nextPage.getPageLength());
            nextPageHeaderBuffer.rewind();
            bbTemp.put(nextPageHeaderBuffer);
        }
        bbTemp.flip();
        rafTemp.getChannel().write(bbTemp);
        if (raf.length() - startAudio != rafTemp.length() + bytesToDiscard - startAudioWritten) {
            throw new CannotWriteException("File written counts don't match, file not written:origAudioLength:" + (raf.length() - startAudio) + ":newAudioLength:" + (rafTemp.length() + bytesToDiscard - startAudioWritten) + ":bytesDiscarded:" + bytesToDiscard);
        }
    }

    private byte[] createSegmentTable(int newCommentLength, int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPackets) {
        ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
        if (setupHeaderLength == 0) {
            byte[] newStart = this.createSegments(newCommentLength, false);
            return newStart;
        }
        byte[] newStart = this.createSegments(newCommentLength, true);
        byte[] restShouldBe = extraPackets.size() > 0 ? this.createSegments(setupHeaderLength, true) : this.createSegments(setupHeaderLength, false);
        try {
            resultBaos.write(newStart);
            resultBaos.write(restShouldBe);
            if (extraPackets.size() > 0) {
                for (OggPageHeader.PacketStartAndLength packet : extraPackets) {
                    byte[] nextPacket = this.createSegments(packet.getLength(), false);
                    resultBaos.write(nextPacket);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create segment table:" + ioe.getMessage());
        }
        return resultBaos.toByteArray();
    }

    private byte[] createSegmentTable(int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPackets) {
        ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
        byte[] restShouldBe = this.createSegments(setupHeaderLength, true);
        try {
            resultBaos.write(restShouldBe);
            if (extraPackets.size() > 0) {
                for (OggPageHeader.PacketStartAndLength packet : extraPackets) {
                    byte[] nextPacket = this.createSegments(packet.getLength(), false);
                    resultBaos.write(nextPacket);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create segment table:" + ioe.getMessage());
        }
        return resultBaos.toByteArray();
    }

    private byte[] createSegments(int length, boolean quitStream) {
        int i;
        if (length == 0) {
            byte[] result = new byte[]{0};
            return result;
        }
        byte[] result = new byte[length / 255 + (length % 255 == 0 && !quitStream ? 0 : 1)];
        for (i = 0; i < result.length - 1; ++i) {
            result[i] = -1;
        }
        result[result.length - 1] = (byte)(length - i * 255);
        return result;
    }

    private boolean isCommentAndSetupHeaderFitsOnASinglePage(int commentLength, int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPacketList) {
        int totalDataSize = 0;
        if (commentLength == 0) {
            ++totalDataSize;
        } else {
            totalDataSize = commentLength / 255 + 1;
            if (commentLength % 255 == 0) {
                ++totalDataSize;
            }
        }
        if (setupHeaderLength == 0) {
            ++totalDataSize;
        } else {
            totalDataSize += setupHeaderLength / 255 + 1;
            if (setupHeaderLength % 255 == 0) {
                ++totalDataSize;
            }
        }
        for (OggPageHeader.PacketStartAndLength extraPacket : extraPacketList) {
            if (extraPacket.getLength() == 0) {
                ++totalDataSize;
                continue;
            }
            totalDataSize += extraPacket.getLength() / 255 + 1;
            if (extraPacket.getLength() % 255 != 0) continue;
            ++totalDataSize;
        }
        return totalDataSize <= 255;
    }
}

