/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavRIFFHeader;
import org.jaudiotagger.audio.wav.chunk.WavCorruptChunkType;
import org.jaudiotagger.audio.wav.chunk.WavFactChunk;
import org.jaudiotagger.audio.wav.chunk.WavFormatChunk;

public class WavInfoReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav");
    private String loggingName;
    private boolean isFoundAudio = false;
    private boolean isFoundFormat = false;

    public WavInfoReader(String loggingName) {
        this.loggingName = loggingName;
    }

    public GenericAudioHeader read(Path path) throws CannotReadException, IOException {
        GenericAudioHeader info;
        block9: {
            info = new GenericAudioHeader();
            try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
                if (WavRIFFHeader.isValidHeader(this.loggingName, fc)) {
                    while (fc.position() < fc.size()) {
                        if (this.readChunk(fc, info)) continue;
                        break block9;
                    }
                    break block9;
                }
                throw new CannotReadException(this.loggingName + " Wav RIFF Header not valid");
            }
        }
        if (this.isFoundFormat && this.isFoundAudio) {
            info.setFormat(SupportedFileFormat.WAV.getDisplayName());
            info.setLossless(true);
            this.calculateTrackLength(info);
            return info;
        }
        throw new CannotReadException(this.loggingName + " Unable to safetly read chunks for this file, appears to be corrupt");
    }

    private void calculateTrackLength(GenericAudioHeader info) throws CannotReadException {
        if (info.getNoOfSamples() != null) {
            if (info.getSampleRateAsNumber() > 0) {
                info.setPreciseLength((float)info.getNoOfSamples().longValue() / (float)info.getSampleRateAsNumber());
            }
        } else if (info.getAudioDataLength() > 0L) {
            info.setPreciseLength((float)info.getAudioDataLength().longValue() / (float)info.getByteRate().intValue());
        } else {
            throw new CannotReadException(this.loggingName + " Wav Data Header Missing");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected boolean readChunk(FileChannel fc, GenericAudioHeader info) throws IOException, CannotReadException {
        ChunkHeader chunkHeader;
        block19: {
            chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
            if (!chunkHeader.readHeader(fc)) {
                return false;
            }
            String id = chunkHeader.getID();
            WavChunkType chunkType = WavChunkType.get(id);
            if (chunkType != null) {
                switch (chunkType) {
                    case FACT: {
                        ByteBuffer fmtChunkData = Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize());
                        WavFactChunk chunk = new WavFactChunk(fmtChunkData, chunkHeader, info);
                        if (((Chunk)chunk).readChunk()) break;
                        return false;
                    }
                    case DATA: {
                        info.setAudioDataLength(chunkHeader.getSize());
                        info.setAudioDataStartPosition(fc.position());
                        info.setAudioDataEndPosition(fc.position() + chunkHeader.getSize());
                        fc.position(fc.position() + chunkHeader.getSize());
                        this.isFoundAudio = true;
                        break;
                    }
                    case FORMAT: {
                        ByteBuffer fmtChunkData = Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize());
                        WavFormatChunk chunk = new WavFormatChunk(fmtChunkData, chunkHeader, info);
                        if (!((Chunk)chunk).readChunk()) {
                            return false;
                        }
                        this.isFoundFormat = true;
                        break;
                    }
                    default: {
                        if (fc.position() + chunkHeader.getSize() <= fc.size()) {
                            fc.position(fc.position() + chunkHeader.getSize());
                            break;
                        }
                        if (!this.isFoundAudio) throw new CannotReadException(this.loggingName + " Size of Chunk Header larger than data, cannot read file");
                        if (!this.isFoundFormat) throw new CannotReadException(this.loggingName + " Size of Chunk Header larger than data, cannot read file");
                        fc.position(fc.size());
                        break;
                    }
                }
            } else {
                if (id.substring(1, 3).equals(WavCorruptChunkType.CORRUPT_LIST_EARLY.getCode())) {
                    fc.position(fc.position() - 7L);
                    return true;
                }
                if (id.substring(0, 3).equals(WavCorruptChunkType.CORRUPT_LIST_LATE.getCode())) {
                    fc.position(fc.position() - 9L);
                    return true;
                }
                if (id.equals("\u0000\u0000\u0000\u0000") && chunkHeader.getSize() == 0L) {
                    int fileRemainder = (int)(fc.size() - fc.position());
                    ByteBuffer restOfFile = ByteBuffer.allocate(fileRemainder);
                    fc.read(restOfFile);
                    restOfFile.flip();
                    while (restOfFile.hasRemaining() && restOfFile.get() == 0) {
                    }
                    fc.position(chunkHeader.getStartLocationInFile() + (long)restOfFile.position() + 8L - 1L);
                    return true;
                }
                if (chunkHeader.getSize() < 0L) {
                    if (this.isFoundAudio && this.isFoundFormat) {
                        fc.position(fc.size());
                        break block19;
                    } else {
                        String msg = this.loggingName + " Not a valid header, unable to read a sensible size:Header" + chunkHeader.getID() + "Size:" + chunkHeader.getSize();
                        throw new CannotReadException(msg);
                    }
                }
                if (fc.position() + chunkHeader.getSize() <= fc.size()) {
                    fc.position(fc.position() + chunkHeader.getSize());
                } else {
                    if (!this.isFoundAudio) throw new CannotReadException(this.loggingName + " Size of Chunk Header larger than data, cannot read file");
                    if (!this.isFoundFormat) throw new CannotReadException(this.loggingName + " Size of Chunk Header larger than data, cannot read file");
                    fc.position(fc.size());
                }
            }
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }
}

