/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.BadChunkSummary;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.ChunkSummary;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.iff.PaddingChunkSummary;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavRIFFHeader;
import org.jaudiotagger.audio.wav.chunk.WavCorruptChunkType;
import org.jaudiotagger.audio.wav.chunk.WavId3Chunk;
import org.jaudiotagger.audio.wav.chunk.WavListChunk;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.wav.WavInfoTag;
import org.jaudiotagger.tag.wav.WavTag;

public class WavTagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav");
    private String loggingName;

    public WavTagReader(String loggingName) {
        this.loggingName = loggingName;
    }

    public WavTag read(Path path) throws CannotReadException, IOException {
        WavTag tag;
        block8: {
            tag = new WavTag(TagOptionSingleton.getInstance().getWavOptions());
            try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
                if (WavRIFFHeader.isValidHeader(this.loggingName, fc)) {
                    while (fc.position() < fc.size()) {
                        if (this.readChunk(fc, tag)) continue;
                        break block8;
                    }
                    break block8;
                }
                throw new CannotReadException(this.loggingName + " Wav RIFF Header not valid");
            }
        }
        this.createDefaultMetadataTagsIfMissing(tag);
        return tag;
    }

    private void createDefaultMetadataTagsIfMissing(WavTag tag) {
        if (!tag.isExistingId3Tag()) {
            tag.setID3Tag(WavTag.createDefaultID3Tag());
        }
        if (!tag.isExistingInfoTag()) {
            tag.setInfoTag(new WavInfoTag());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean readChunk(FileChannel fc, WavTag tag) throws IOException, CannotReadException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        if (!chunkHeader.readHeader(fc)) {
            return false;
        }
        String id = chunkHeader.getID();
        WavChunkType chunkType = WavChunkType.get(id);
        if (chunkType != null) {
            switch (chunkType) {
                case LIST: {
                    ChunkSummary cs = new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize());
                    tag.addChunkSummary(cs);
                    tag.addMetadataChunkSummary(cs);
                    if (tag.getInfoTag() == null) {
                        WavListChunk chunk = new WavListChunk(this.loggingName, Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize()), chunkHeader, tag);
                        if (((Chunk)chunk).readChunk()) break;
                        return false;
                    }
                    fc.position(fc.position() + chunkHeader.getSize());
                    break;
                }
                case ID3_UPPERCASE: {
                    ChunkSummary cs = new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize());
                    tag.addChunkSummary(cs);
                    tag.addMetadataChunkSummary(cs);
                    if (tag.getID3Tag() == null) {
                        WavId3Chunk chunk = new WavId3Chunk(Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize()), chunkHeader, tag, this.loggingName);
                        if (((Chunk)chunk).readChunk()) break;
                        return false;
                    }
                    fc.position(fc.position() + chunkHeader.getSize());
                    break;
                }
                case ID3: {
                    ChunkSummary cs = new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize());
                    tag.addChunkSummary(cs);
                    tag.addMetadataChunkSummary(cs);
                    if (tag.getID3Tag() == null) {
                        WavId3Chunk chunk = new WavId3Chunk(Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize()), chunkHeader, tag, this.loggingName);
                        if (((Chunk)chunk).readChunk()) break;
                        return false;
                    }
                    fc.position(fc.position() + chunkHeader.getSize());
                    break;
                }
                default: {
                    tag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
                    fc.position(fc.position() + chunkHeader.getSize());
                    break;
                }
            }
        } else {
            if (id.substring(1, 3).equals(WavCorruptChunkType.CORRUPT_ID3_EARLY.getCode())) {
                if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                    tag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 7L);
                return true;
            }
            if (id.substring(0, 3).equals(WavCorruptChunkType.CORRUPT_ID3_LATE.getCode())) {
                if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                    tag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 9L);
                return true;
            }
            if (id.substring(1, 3).equals(WavCorruptChunkType.CORRUPT_LIST_EARLY.getCode())) {
                if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                    tag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 7L);
                return true;
            }
            if (id.substring(0, 3).equals(WavCorruptChunkType.CORRUPT_LIST_LATE.getCode())) {
                if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                    tag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 9L);
                return true;
            }
            if (id.equals("\u0000\u0000\u0000\u0000") && chunkHeader.getSize() == 0L) {
                int fileRemainder = (int)(fc.size() - fc.position());
                ByteBuffer restOfFile = ByteBuffer.allocate(fileRemainder);
                fc.read(restOfFile);
                restOfFile.flip();
                while (restOfFile.get() == 0) {
                }
                fc.position(chunkHeader.getStartLocationInFile() + (long)restOfFile.position() + 8L - 1L);
                tag.addChunkSummary(new PaddingChunkSummary(chunkHeader.getStartLocationInFile(), restOfFile.position() - 1));
                tag.setNonStandardPadding(true);
                return true;
            }
            if (chunkHeader.getSize() < 0L) {
                tag.addChunkSummary(new BadChunkSummary(chunkHeader.getStartLocationInFile(), fc.size() - fc.position()));
                tag.setBadChunkData(true);
                fc.position(fc.size());
            } else if (fc.position() + chunkHeader.getSize() <= fc.size()) {
                tag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
                fc.position(fc.position() + chunkHeader.getSize());
            } else {
                tag.addChunkSummary(new BadChunkSummary(chunkHeader.getStartLocationInFile(), fc.size() - fc.position()));
                tag.setBadChunkData(true);
                fc.position(fc.size());
            }
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }
}

