/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.wav.WavTag;

public class WavId3Chunk
extends Chunk {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav.chunk");
    private WavTag wavTag;
    private String loggingName;

    public WavId3Chunk(ByteBuffer chunkData, ChunkHeader chunkHeader, WavTag tag, String loggingName) {
        super(chunkData, chunkHeader);
        this.wavTag = tag;
        this.loggingName = loggingName;
    }

    @Override
    public boolean readChunk() throws IOException {
        AbstractID3v2Tag id3Tag;
        if (!this.isId3v2Tag(this.chunkData)) {
            return false;
        }
        byte version = this.chunkData.get();
        switch (version) {
            case 2: {
                id3Tag = new ID3v22Tag();
                id3Tag.setLoggingFilename(this.loggingName);
                break;
            }
            case 3: {
                id3Tag = new ID3v23Tag();
                id3Tag.setLoggingFilename(this.loggingName);
                break;
            }
            case 4: {
                id3Tag = new ID3v24Tag();
                id3Tag.setLoggingFilename(this.loggingName);
                break;
            }
            default: {
                return false;
            }
        }
        id3Tag.setStartLocationInFile(this.chunkHeader.getStartLocationInFile() + 8L);
        id3Tag.setEndLocationInFile(this.chunkHeader.getStartLocationInFile() + 8L + this.chunkHeader.getSize());
        this.wavTag.setExistingId3Tag(true);
        this.wavTag.setID3Tag(id3Tag);
        this.chunkData.position(0);
        try {
            id3Tag.read(this.chunkData);
        }
        catch (TagException e) {
            AudioFile.logger.info("Exception reading ID3 tag: " + e.getClass().getName() + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean isId3v2Tag(ByteBuffer headerData) throws IOException {
        for (int i = 0; i < 3; ++i) {
            if (headerData.get() == AbstractID3v2Tag.TAG_ID[i]) continue;
            return false;
        }
        return true;
    }
}

