/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class TextEncodedStringSizeTerminated
extends AbstractString {
    public TextEncodedStringSizeTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public TextEncodedStringSizeTerminated(TextEncodedStringSizeTerminated object) {
        super(object);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof TextEncodedStringSizeTerminated && super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        ByteBuffer inBuffer;
        if (TagOptionSingleton.getInstance().isAndroid()) {
            byte[] truncArr = new byte[arr.length - offset];
            System.arraycopy(arr, offset, truncArr, 0, truncArr.length);
            inBuffer = ByteBuffer.wrap(truncArr);
        } else {
            inBuffer = ByteBuffer.wrap(arr, offset, arr.length - offset).slice();
        }
        CharBuffer outBuffer = CharBuffer.allocate(arr.length - offset);
        CharsetDecoder decoder = this.getCorrectDecoder(inBuffer);
        CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
        if (coderResult.isError()) {
            // empty if block
        }
        decoder.flush(outBuffer);
        outBuffer.flip();
        if (StandardCharsets.UTF_16.equals(this.getTextEncodingCharSet())) {
            this.value = outBuffer.toString().replace("\ufeff", "").replace("\ufffe", "");
            this.value = ((String)this.value).replace("\ufdff", "").replace("\ufffd", "");
        } else {
            this.value = outBuffer.toString();
        }
        this.setSize(arr.length - offset);
        if (logger.isLoggable(Level.FINEST)) {
            // empty if block
        }
    }

    protected ByteBuffer writeString(CharsetEncoder encoder2, String next, int i, int noOfValues) throws CharacterCodingException {
        ByteBuffer bb = i + 1 == noOfValues ? encoder2.encode(CharBuffer.wrap(next)) : encoder2.encode(CharBuffer.wrap(next + '\u0000'));
        bb.rewind();
        return bb;
    }

    protected ByteBuffer writeStringUTF16LEBOM(String next, int i, int noOfValues) throws CharacterCodingException {
        CharsetEncoder encoder2 = StandardCharsets.UTF_16LE.newEncoder();
        encoder2.onMalformedInput(CodingErrorAction.IGNORE);
        encoder2.onUnmappableCharacter(CodingErrorAction.IGNORE);
        ByteBuffer bb = i + 1 == noOfValues ? encoder2.encode(CharBuffer.wrap('\ufeff' + next)) : encoder2.encode(CharBuffer.wrap('\ufeff' + next + '\u0000'));
        bb.rewind();
        return bb;
    }

    protected ByteBuffer writeStringUTF16BEBOM(String next, int i, int noOfValues) throws CharacterCodingException {
        CharsetEncoder encoder2 = StandardCharsets.UTF_16BE.newEncoder();
        encoder2.onMalformedInput(CodingErrorAction.IGNORE);
        encoder2.onUnmappableCharacter(CodingErrorAction.IGNORE);
        ByteBuffer bb = i + 1 == noOfValues ? encoder2.encode(CharBuffer.wrap('\ufeff' + next)) : encoder2.encode(CharBuffer.wrap('\ufeff' + next + '\u0000'));
        bb.rewind();
        return bb;
    }

    protected void stripTrailingNull() {
        String stringValue;
        if (TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && (stringValue = (String)this.value).length() > 0 && stringValue.charAt(stringValue.length() - 1) == '\u0000') {
            stringValue = stringValue.substring(0, stringValue.length() - 1);
            this.value = stringValue;
        }
    }

    protected void checkTrailingNull(List<String> values2, String stringValue) {
        if (!TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && stringValue.length() > 0 && stringValue.charAt(stringValue.length() - 1) == '\u0000') {
            String lastVal = values2.get(values2.size() - 1);
            String newLastVal = lastVal + '\u0000';
            values2.set(values2.size() - 1, newLastVal);
        }
    }

    @Override
    public byte[] writeByteArray() {
        byte[] data;
        Charset charset = this.getTextEncodingCharSet();
        try {
            this.stripTrailingNull();
            String stringValue = (String)this.value;
            Charset actualCharSet = null;
            if (StandardCharsets.UTF_16.equals(charset)) {
                actualCharSet = TagOptionSingleton.getInstance().isEncodeUTF16BomAsLittleEndian() ? StandardCharsets.UTF_16LE : StandardCharsets.UTF_16BE;
            }
            ByteBuffer outputBuffer = ByteBuffer.allocate((stringValue.length() + 3) * 3);
            List<String> values2 = TextEncodedStringSizeTerminated.splitByNullSeperator(stringValue);
            this.checkTrailingNull(values2, stringValue);
            for (int i = 0; i < values2.size(); ++i) {
                String next = values2.get(i);
                if (StandardCharsets.UTF_16LE.equals(actualCharSet)) {
                    outputBuffer.put(this.writeStringUTF16LEBOM(next, i, values2.size()));
                    continue;
                }
                if (StandardCharsets.UTF_16BE.equals(actualCharSet)) {
                    outputBuffer.put(this.writeStringUTF16BEBOM(next, i, values2.size()));
                    continue;
                }
                CharsetEncoder charsetEncoder = charset.newEncoder();
                charsetEncoder.onMalformedInput(CodingErrorAction.IGNORE);
                charsetEncoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                outputBuffer.put(this.writeString(charsetEncoder, next, i, values2.size()));
            }
            outputBuffer.flip();
            data = new byte[outputBuffer.limit()];
            outputBuffer.rewind();
            outputBuffer.get(data, 0, outputBuffer.limit());
            this.setSize(data.length);
        }
        catch (CharacterCodingException ce) {
            throw new RuntimeException(ce);
        }
        return data;
    }

    public static List<String> splitByNullSeperator(String value) {
        String[] valuesarray = value.split("\\u0000");
        List<String> values2 = Arrays.asList(valuesarray);
        if (values2.size() == 0) {
            values2 = new ArrayList<String>(1);
            values2.add("");
        }
        return values2;
    }

    public void addValue(String value) {
        this.setValue(this.value + "\u0000" + value);
    }

    public int getNumberOfValues() {
        return TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value).size();
    }

    public String getValueAtIndex(int index) {
        List<String> values2 = TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
        return values2.get(index);
    }

    public List<String> getValues() {
        return TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
    }

    public String getValueWithoutTrailingNull() {
        List<String> values2 = TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values2.size(); ++i) {
            if (i != 0) {
                sb.append("\u0000");
            }
            sb.append(values2.get(i));
        }
        return sb.toString();
    }
}

