/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.PaddingException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAENC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyASPI;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCHAP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCRM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCTOC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyENCR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyEQU2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyETCO;
import org.jaudiotagger.tag.id3.framebody.FrameBodyEncrypted;
import org.jaudiotagger.tag.id3.framebody.FrameBodyGEOB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyGRID;
import org.jaudiotagger.tag.id3.framebody.FrameBodyGRP1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyIPLS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyLINK;
import org.jaudiotagger.tag.id3.framebody.FrameBodyMCDI;
import org.jaudiotagger.tag.id3.framebody.FrameBodyMVIN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyMVNM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyOWNE;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPCNT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPOPM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPOSS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPRIV;
import org.jaudiotagger.tag.id3.framebody.FrameBodyRBUF;
import org.jaudiotagger.tag.id3.framebody.FrameBodyRVA2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyRVAD;
import org.jaudiotagger.tag.id3.framebody.FrameBodyRVRB;
import org.jaudiotagger.tag.id3.framebody.FrameBodySEEK;
import org.jaudiotagger.tag.id3.framebody.FrameBodySIGN;
import org.jaudiotagger.tag.id3.framebody.FrameBodySYLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodySYTC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTBPM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCMP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCOP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDAT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDEN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDLY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDOR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDTG;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTENC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTEXT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTFLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIME;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT3;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTKEY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTLAN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTLEN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMCL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMED;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMOO;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOAL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOFN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOLY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOPE;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTORY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOWN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE3;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE4;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPOS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPRO;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPUB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRDA;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRSN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRSO;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSIZ;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSO2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSOA;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSOC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSOP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSOT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSSE;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSST;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTYER;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUFID;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSER;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWCOM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWCOP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAF;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWORS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWPAY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWPUB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyXSOA;
import org.jaudiotagger.tag.id3.framebody.FrameBodyXSOP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyXSOT;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.utils.EqualsUtil;

public abstract class AbstractID3v2Frame
extends AbstractTagFrame
implements TagTextField {
    protected static final String TYPE_FRAME = "frame";
    protected static final String TYPE_FRAME_SIZE = "frameSize";
    protected static final String UNSUPPORTED_ID = "Unsupported";
    protected String identifier = "";
    protected int frameSize;
    private String loggingFilename = "";
    StatusFlags statusFlags = null;
    EncodingFlags encodingFlags = null;

    protected abstract int getFrameIdSize();

    protected abstract int getFrameSizeSize();

    protected abstract int getFrameHeaderSize();

    protected AbstractID3v2Frame() {
    }

    public AbstractID3v2Frame(AbstractID3v2Frame frame) {
        super(frame);
    }

    public AbstractID3v2Frame(AbstractID3v2FrameBody body) {
        this.frameBody = body;
        this.frameBody.setHeader(this);
    }

    public AbstractID3v2Frame(String identifier) {
        this.identifier = identifier;
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
            this.frameBody = (AbstractTagFrameBody)c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this.frameBody = new FrameBodyUnsupported(identifier);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        this.frameBody.setHeader(this);
        if (this instanceof ID3v24Frame) {
            this.frameBody.setTextEncoding(TagOptionSingleton.getInstance().getId3v24DefaultTextEncoding());
        } else if (this instanceof ID3v23Frame) {
            this.frameBody.setTextEncoding(TagOptionSingleton.getInstance().getId3v23DefaultTextEncoding());
        }
    }

    protected String getLoggingFilename() {
        return this.loggingFilename;
    }

    protected void setLoggingFilename(String loggingFilename) {
        this.loggingFilename = loggingFilename;
    }

    @Override
    public String getId() {
        return this.getIdentifier();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void copyContent(TagField field) {
    }

    protected AbstractID3v2FrameBody readEncryptedBody(String identifier, ByteBuffer byteBuffer, int frameSize) throws InvalidFrameException, InvalidDataTypeException {
        try {
            FrameBodyEncrypted frameBody = new FrameBodyEncrypted(identifier, byteBuffer, frameSize);
            frameBody.setHeader(this);
            return frameBody;
        }
        catch (InvalidTagException ite) {
            throw new InvalidDataTypeException(ite);
        }
    }

    protected boolean isPadding(byte[] buffer) {
        return buffer[0] == 0 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0;
    }

    protected AbstractID3v2FrameBody readBody(String identifier, ByteBuffer byteBuffer, int frameSize) throws InvalidFrameException, InvalidDataTypeException {
        AbstractID3v2FrameBody frameBody;
        try {
            switch (identifier) {
                case "AENC": {
                    frameBody = new FrameBodyAENC(byteBuffer, frameSize);
                    break;
                }
                case "APIC": {
                    frameBody = new FrameBodyAPIC(byteBuffer, frameSize);
                    break;
                }
                case "ASPI": {
                    frameBody = new FrameBodyASPI(byteBuffer, frameSize);
                    break;
                }
                case "CHAP": {
                    frameBody = new FrameBodyCHAP(byteBuffer, frameSize);
                    break;
                }
                case "COMM": {
                    frameBody = new FrameBodyCOMM(byteBuffer, frameSize);
                    break;
                }
                case "COMR": {
                    frameBody = new FrameBodyCOMR(byteBuffer, frameSize);
                    break;
                }
                case "CRM": {
                    frameBody = new FrameBodyCRM(byteBuffer, frameSize);
                    break;
                }
                case "CTOC": {
                    frameBody = new FrameBodyCTOC(byteBuffer, frameSize);
                    break;
                }
                case "ENCR": {
                    frameBody = new FrameBodyENCR(byteBuffer, frameSize);
                    break;
                }
                case "EQU2": {
                    frameBody = new FrameBodyEQU2(byteBuffer, frameSize);
                    break;
                }
                case "ETCO": {
                    frameBody = new FrameBodyETCO(byteBuffer, frameSize);
                    break;
                }
                case "GEOB": {
                    frameBody = new FrameBodyGEOB(byteBuffer, frameSize);
                    break;
                }
                case "GRP1": {
                    frameBody = new FrameBodyGRP1(byteBuffer, frameSize);
                    break;
                }
                case "GRID": {
                    frameBody = new FrameBodyGRID(byteBuffer, frameSize);
                    break;
                }
                case "IPLS": {
                    frameBody = new FrameBodyIPLS(byteBuffer, frameSize);
                    break;
                }
                case "LINK": {
                    frameBody = new FrameBodyLINK(byteBuffer, frameSize);
                    break;
                }
                case "MCDI": {
                    frameBody = new FrameBodyMCDI(byteBuffer, frameSize);
                    break;
                }
                case "MVIN": {
                    frameBody = new FrameBodyMVIN(byteBuffer, frameSize);
                    break;
                }
                case "MVNM": {
                    frameBody = new FrameBodyMVNM(byteBuffer, frameSize);
                    break;
                }
                case "OWNE": {
                    frameBody = new FrameBodyOWNE(byteBuffer, frameSize);
                    break;
                }
                case "PCNT": {
                    frameBody = new FrameBodyPCNT(byteBuffer, frameSize);
                    break;
                }
                case "PIC": {
                    frameBody = new FrameBodyPIC(byteBuffer, frameSize);
                    break;
                }
                case "POPM": {
                    frameBody = new FrameBodyPOPM(byteBuffer, frameSize);
                    break;
                }
                case "POSS": {
                    frameBody = new FrameBodyPOSS(byteBuffer, frameSize);
                    break;
                }
                case "PRIV": {
                    frameBody = new FrameBodyPRIV(byteBuffer, frameSize);
                    break;
                }
                case "RBUF": {
                    frameBody = new FrameBodyRBUF(byteBuffer, frameSize);
                    break;
                }
                case "RVA2": {
                    frameBody = new FrameBodyRVA2(byteBuffer, frameSize);
                    break;
                }
                case "RVAD": {
                    frameBody = new FrameBodyRVAD(byteBuffer, frameSize);
                    break;
                }
                case "RVRB": {
                    frameBody = new FrameBodyRVRB(byteBuffer, frameSize);
                    break;
                }
                case "SEEK": {
                    frameBody = new FrameBodySEEK(byteBuffer, frameSize);
                    break;
                }
                case "SIGN": {
                    frameBody = new FrameBodySIGN(byteBuffer, frameSize);
                    break;
                }
                case "SYLT": {
                    frameBody = new FrameBodySYLT(byteBuffer, frameSize);
                    break;
                }
                case "SYTC": {
                    frameBody = new FrameBodySYTC(byteBuffer, frameSize);
                    break;
                }
                case "TALB": {
                    frameBody = new FrameBodyTALB(byteBuffer, frameSize);
                    break;
                }
                case "TBPM": {
                    frameBody = new FrameBodyTBPM(byteBuffer, frameSize);
                    break;
                }
                case "TCMP": {
                    frameBody = new FrameBodyTCMP(byteBuffer, frameSize);
                    break;
                }
                case "TCON": {
                    frameBody = new FrameBodyTCON(byteBuffer, frameSize);
                    break;
                }
                case "TCOP": {
                    frameBody = new FrameBodyTCOP(byteBuffer, frameSize);
                    break;
                }
                case "TDAT": {
                    frameBody = new FrameBodyTDAT(byteBuffer, frameSize);
                    break;
                }
                case "TDEN": {
                    frameBody = new FrameBodyTDEN(byteBuffer, frameSize);
                    break;
                }
                case "TDLY": {
                    frameBody = new FrameBodyTDLY(byteBuffer, frameSize);
                    break;
                }
                case "TDOR": {
                    frameBody = new FrameBodyTDOR(byteBuffer, frameSize);
                    break;
                }
                case "TDRC": {
                    frameBody = new FrameBodyTDRC(byteBuffer, frameSize);
                    break;
                }
                case "TDRL": {
                    frameBody = new FrameBodyTDRL(byteBuffer, frameSize);
                    break;
                }
                case "TDTG": {
                    frameBody = new FrameBodyTDTG(byteBuffer, frameSize);
                    break;
                }
                case "TENC": {
                    frameBody = new FrameBodyTENC(byteBuffer, frameSize);
                    break;
                }
                case "TEXT": {
                    frameBody = new FrameBodyTEXT(byteBuffer, frameSize);
                    break;
                }
                case "TFLT": {
                    frameBody = new FrameBodyTFLT(byteBuffer, frameSize);
                    break;
                }
                case "TIME": {
                    frameBody = new FrameBodyTIME(byteBuffer, frameSize);
                    break;
                }
                case "TIPL": {
                    frameBody = new FrameBodyTIPL(byteBuffer, frameSize);
                    break;
                }
                case "TIT1": {
                    frameBody = new FrameBodyTIT1(byteBuffer, frameSize);
                    break;
                }
                case "TIT2": {
                    frameBody = new FrameBodyTIT2(byteBuffer, frameSize);
                    break;
                }
                case "TIT3": {
                    frameBody = new FrameBodyTIT3(byteBuffer, frameSize);
                    break;
                }
                case "TKEY": {
                    frameBody = new FrameBodyTKEY(byteBuffer, frameSize);
                    break;
                }
                case "TLAN": {
                    frameBody = new FrameBodyTLAN(byteBuffer, frameSize);
                    break;
                }
                case "TLEN": {
                    frameBody = new FrameBodyTLEN(byteBuffer, frameSize);
                    break;
                }
                case "TMCL": {
                    frameBody = new FrameBodyTMCL(byteBuffer, frameSize);
                    break;
                }
                case "TMED": {
                    frameBody = new FrameBodyTMED(byteBuffer, frameSize);
                    break;
                }
                case "TMOO": {
                    frameBody = new FrameBodyTMOO(byteBuffer, frameSize);
                    break;
                }
                case "TOAL": {
                    frameBody = new FrameBodyTOAL(byteBuffer, frameSize);
                    break;
                }
                case "TOFN": {
                    frameBody = new FrameBodyTOFN(byteBuffer, frameSize);
                    break;
                }
                case "TOLY": {
                    frameBody = new FrameBodyTOLY(byteBuffer, frameSize);
                    break;
                }
                case "TOPE": {
                    frameBody = new FrameBodyTOPE(byteBuffer, frameSize);
                    break;
                }
                case "TORY": {
                    frameBody = new FrameBodyTORY(byteBuffer, frameSize);
                    break;
                }
                case "TOWN": {
                    frameBody = new FrameBodyTOWN(byteBuffer, frameSize);
                    break;
                }
                case "TPE1": {
                    frameBody = new FrameBodyTPE1(byteBuffer, frameSize);
                    break;
                }
                case "TPE2": {
                    frameBody = new FrameBodyTPE2(byteBuffer, frameSize);
                    break;
                }
                case "TPE3": {
                    frameBody = new FrameBodyTPE3(byteBuffer, frameSize);
                    break;
                }
                case "TPE4": {
                    frameBody = new FrameBodyTPE4(byteBuffer, frameSize);
                    break;
                }
                case "TPOS": {
                    frameBody = new FrameBodyTPOS(byteBuffer, frameSize);
                    break;
                }
                case "TPRO": {
                    frameBody = new FrameBodyTPRO(byteBuffer, frameSize);
                    break;
                }
                case "TPUB": {
                    frameBody = new FrameBodyTPUB(byteBuffer, frameSize);
                    break;
                }
                case "TRCK": {
                    frameBody = new FrameBodyTRCK(byteBuffer, frameSize);
                    break;
                }
                case "TRDA": {
                    frameBody = new FrameBodyTRDA(byteBuffer, frameSize);
                    break;
                }
                case "TRSN": {
                    frameBody = new FrameBodyTRSN(byteBuffer, frameSize);
                    break;
                }
                case "TRSO": {
                    frameBody = new FrameBodyTRSO(byteBuffer, frameSize);
                    break;
                }
                case "TSIZ": {
                    frameBody = new FrameBodyTSIZ(byteBuffer, frameSize);
                    break;
                }
                case "TSO2": {
                    frameBody = new FrameBodyTSO2(byteBuffer, frameSize);
                    break;
                }
                case "TSOA": {
                    frameBody = new FrameBodyTSOA(byteBuffer, frameSize);
                    break;
                }
                case "TSOC": {
                    frameBody = new FrameBodyTSOC(byteBuffer, frameSize);
                    break;
                }
                case "TSOP": {
                    frameBody = new FrameBodyTSOP(byteBuffer, frameSize);
                    break;
                }
                case "TSOT": {
                    frameBody = new FrameBodyTSOT(byteBuffer, frameSize);
                    break;
                }
                case "TSRC": {
                    frameBody = new FrameBodyTSRC(byteBuffer, frameSize);
                    break;
                }
                case "TSSE": {
                    frameBody = new FrameBodyTSSE(byteBuffer, frameSize);
                    break;
                }
                case "TSST": {
                    frameBody = new FrameBodyTSST(byteBuffer, frameSize);
                    break;
                }
                case "TXXX": {
                    frameBody = new FrameBodyTXXX(byteBuffer, frameSize);
                    break;
                }
                case "TYER": {
                    frameBody = new FrameBodyTYER(byteBuffer, frameSize);
                    break;
                }
                case "UFID": {
                    frameBody = new FrameBodyUFID(byteBuffer, frameSize);
                    break;
                }
                case "USER": {
                    frameBody = new FrameBodyUSER(byteBuffer, frameSize);
                    break;
                }
                case "USLT": {
                    frameBody = new FrameBodyUSLT(byteBuffer, frameSize);
                    break;
                }
                case "WCOM": {
                    frameBody = new FrameBodyWCOM(byteBuffer, frameSize);
                    break;
                }
                case "WCOP": {
                    frameBody = new FrameBodyWCOP(byteBuffer, frameSize);
                    break;
                }
                case "WOAF": {
                    frameBody = new FrameBodyWOAF(byteBuffer, frameSize);
                    break;
                }
                case "WOAR": {
                    frameBody = new FrameBodyWOAR(byteBuffer, frameSize);
                    break;
                }
                case "WOAS": {
                    frameBody = new FrameBodyWOAS(byteBuffer, frameSize);
                    break;
                }
                case "WORS": {
                    frameBody = new FrameBodyWORS(byteBuffer, frameSize);
                    break;
                }
                case "WPAY": {
                    frameBody = new FrameBodyWPAY(byteBuffer, frameSize);
                    break;
                }
                case "WPUB": {
                    frameBody = new FrameBodyWPUB(byteBuffer, frameSize);
                    break;
                }
                case "WXXX": {
                    frameBody = new FrameBodyWXXX(byteBuffer, frameSize);
                    break;
                }
                case "XSOA": {
                    frameBody = new FrameBodyXSOA(byteBuffer, frameSize);
                    break;
                }
                case "XSOP": {
                    frameBody = new FrameBodyXSOP(byteBuffer, frameSize);
                    break;
                }
                case "XSOT": {
                    frameBody = new FrameBodyXSOT(byteBuffer, frameSize);
                    break;
                }
                default: {
                    Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
                    Class[] constructorParameterTypes = new Class[]{Class.forName("java.nio.ByteBuffer"), Integer.TYPE};
                    Object[] constructorParameterValues = new Object[]{byteBuffer, frameSize};
                    Constructor<?> construct = c.getConstructor(constructorParameterTypes);
                    frameBody = (AbstractID3v2FrameBody)construct.newInstance(constructorParameterValues);
                    break;
                }
            }
        }
        catch (InvalidTagException e) {
            throw new InvalidFrameException(e.getMessage());
        }
        catch (ClassNotFoundException cex) {
            try {
                frameBody = new FrameBodyUnsupported(byteBuffer, frameSize);
            }
            catch (InvalidFrameException ife) {
                throw ife;
            }
            catch (InvalidTagException te) {
                throw new InvalidFrameException(te.getMessage());
            }
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Error) {
                throw (Error)ite.getCause();
            }
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            if (ite.getCause() instanceof InvalidFrameException) {
                throw (InvalidFrameException)ite.getCause();
            }
            if (ite.getCause() instanceof InvalidDataTypeException) {
                throw (InvalidDataTypeException)ite.getCause();
            }
            throw new InvalidFrameException(ite.getCause().getMessage());
        }
        catch (NoSuchMethodException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae.getMessage());
        }
        frameBody.setHeader(this);
        return frameBody;
    }

    protected String readIdentifier(ByteBuffer byteBuffer) throws PaddingException, InvalidFrameException {
        byte[] buffer = new byte[this.getFrameIdSize()];
        if (this.getFrameIdSize() <= byteBuffer.remaining()) {
            byteBuffer.get(buffer, 0, this.getFrameIdSize());
        }
        if (this.isPadding(buffer)) {
            throw new PaddingException(this.getLoggingFilename() + ":only padding found");
        }
        if (this.getFrameHeaderSize() - this.getFrameIdSize() > byteBuffer.remaining()) {
            throw new InvalidFrameException(this.getLoggingFilename() + ":No space to find another frame");
        }
        this.identifier = new String(buffer);
        return this.identifier;
    }

    protected AbstractID3v2FrameBody readBody(String identifier, AbstractID3v2FrameBody body) throws InvalidFrameException {
        AbstractID3v2FrameBody frameBody;
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
            Class[] constructorParameterTypes = new Class[]{body.getClass()};
            Object[] constructorParameterValues = new Object[]{body};
            Constructor<?> construct = c.getConstructor(constructorParameterTypes);
            frameBody = (AbstractID3v2FrameBody)construct.newInstance(constructorParameterValues);
        }
        catch (ClassNotFoundException cex) {
            throw new InvalidFrameException("FrameBody" + identifier + " does not exist");
        }
        catch (NoSuchMethodException sme) {
            throw new InvalidFrameException("FrameBody" + identifier + " does not have a constructor that takes:" + body.getClass().getName());
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Error) {
                throw (Error)ite.getCause();
            }
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            throw new InvalidFrameException(ite.getCause().getMessage());
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae.getMessage());
        }
        frameBody.setHeader(this);
        return frameBody;
    }

    @Override
    public byte[] getRawContent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        return baos.toByteArray();
    }

    public abstract void write(ByteArrayOutputStream var1);

    @Override
    public void isBinary(boolean b) {
    }

    @Override
    public boolean isEmpty() {
        AbstractTagFrameBody body = this.getBody();
        return body == null;
    }

    public StatusFlags getStatusFlags() {
        return this.statusFlags;
    }

    public EncodingFlags getEncodingFlags() {
        return this.encodingFlags;
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_FRAME, this.getIdentifier());
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_FRAME);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractID3v2Frame)) {
            return false;
        }
        AbstractID3v2Frame that = (AbstractID3v2Frame)obj;
        return super.equals(that);
    }

    @Override
    public String getContent() {
        return this.getBody().getUserFriendlyValue();
    }

    @Override
    public Charset getEncoding() {
        byte textEncoding = this.getBody().getTextEncoding();
        return TextEncoding.getInstanceOf().getCharsetForId(textEncoding);
    }

    @Override
    public void setContent(String content) {
        throw new UnsupportedOperationException("Not implemented please use the generic tag methods for setting content");
    }

    class EncodingFlags {
        protected static final String TYPE_FLAGS = "encodingFlags";
        protected byte flags;

        protected EncodingFlags() {
            this.resetFlags();
        }

        protected EncodingFlags(byte flags) {
            this.setFlags(flags);
        }

        public byte getFlags() {
            return this.flags;
        }

        public void setFlags(byte flags) {
            this.flags = flags;
        }

        public void resetFlags() {
            this.setFlags((byte)0);
        }

        public void createStructure() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EncodingFlags)) {
                return false;
            }
            EncodingFlags that = (EncodingFlags)obj;
            return EqualsUtil.areEqual(this.getFlags(), that.getFlags());
        }
    }

    public class StatusFlags {
        protected static final String TYPE_FLAGS = "statusFlags";
        protected byte originalFlags;
        protected byte writeFlags;

        protected StatusFlags() {
        }

        public byte getOriginalFlags() {
            return this.originalFlags;
        }

        public byte getWriteFlags() {
            return this.writeFlags;
        }

        public void createStructure() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StatusFlags)) {
                return false;
            }
            StatusFlags that = (StatusFlags)obj;
            return EqualsUtil.areEqual(this.getOriginalFlags(), that.getOriginalFlags()) && EqualsUtil.areEqual(this.getWriteFlags(), that.getWriteFlags());
        }
    }
}

