/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.EventTimingCode;
import org.jaudiotagger.tag.datatype.EventTimingCodeList;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.id3.valuepair.EventTimingTimestampTypes;

public class FrameBodyETCO
extends AbstractID3v2FrameBody
implements ID3v24FrameBody,
ID3v23FrameBody {
    public static final int MPEG_FRAMES = 1;
    public static final int MILLISECONDS = 2;

    public FrameBodyETCO() {
        this.setObjectValue("TimeStampFormat", 2);
    }

    public FrameBodyETCO(FrameBodyETCO body) {
        super(body);
    }

    public FrameBodyETCO(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public int getTimestampFormat() {
        return ((Number)this.getObjectValue("TimeStampFormat")).intValue();
    }

    public void setTimestampFormat(int timestampFormat) {
        if (EventTimingTimestampTypes.getInstanceOf().getValueForId(timestampFormat) == null) {
            throw new IllegalArgumentException("Timestamp format must be 1 or 2 (ID3v2.4, 4.5): " + timestampFormat);
        }
        this.setObjectValue("TimeStampFormat", timestampFormat);
    }

    public Map<Long, int[]> getTimingCodes() {
        LinkedHashMap<Long, int[]> map = new LinkedHashMap<Long, int[]>();
        List codes = (List)this.getObjectValue("TimedEventList");
        long lastTimestamp = 0L;
        for (EventTimingCode code : codes) {
            long translatedTimestamp = code.getTimestamp() == 0L ? lastTimestamp : code.getTimestamp();
            int[] types = (int[])map.get(translatedTimestamp);
            if (types == null) {
                map.put(translatedTimestamp, new int[]{code.getType()});
            } else {
                int[] newTypes = new int[types.length + 1];
                System.arraycopy(types, 0, newTypes, 0, types.length);
                newTypes[newTypes.length - 1] = code.getType();
                map.put(translatedTimestamp, newTypes);
            }
            lastTimestamp = translatedTimestamp;
        }
        return Collections.unmodifiableMap(map);
    }

    public List<Long> getTimestamps(int ... type) {
        Set<Integer> typeSet = FrameBodyETCO.toSet(type);
        ArrayList<Long> list = new ArrayList<Long>();
        List codes = (List)this.getObjectValue("TimedEventList");
        long lastTimestamp = 0L;
        for (EventTimingCode code : codes) {
            long translatedTimestamp;
            long l = translatedTimestamp = code.getTimestamp() == 0L ? lastTimestamp : code.getTimestamp();
            if (typeSet.contains(code.getType())) {
                list.add(translatedTimestamp);
            }
            lastTimestamp = translatedTimestamp;
        }
        return Collections.unmodifiableList(list);
    }

    public void addTimingCode(long timestamp, int ... types) {
        List codes = (List)this.getObjectValue("TimedEventList");
        long lastTimestamp = 0L;
        int insertIndex = 0;
        if (!codes.isEmpty() && ((EventTimingCode)codes.get(0)).getTimestamp() <= timestamp) {
            Object object = codes.iterator();
            while (object.hasNext()) {
                long translatedTimestamp;
                EventTimingCode code = (EventTimingCode)object.next();
                long l = translatedTimestamp = code.getTimestamp() == 0L ? lastTimestamp : code.getTimestamp();
                if (timestamp < translatedTimestamp) break;
                ++insertIndex;
                lastTimestamp = translatedTimestamp;
            }
        }
        for (int type : types) {
            codes.add(insertIndex, new EventTimingCode("TimedEvent", this, type, timestamp));
            ++insertIndex;
        }
    }

    public boolean removeTimingCode(long timestamp, int ... types) {
        this.resolveRelativeTimestamps();
        Set<Integer> typeSet = FrameBodyETCO.toSet(types);
        List codes = (List)this.getObjectValue("TimedEventList");
        boolean removed = false;
        ListIterator iterator2 = codes.listIterator();
        while (iterator2.hasNext()) {
            EventTimingCode code = (EventTimingCode)iterator2.next();
            if (timestamp == code.getTimestamp() && typeSet.contains(code.getType())) {
                iterator2.remove();
                removed = true;
            }
            if (timestamp <= code.getTimestamp()) continue;
            break;
        }
        return removed;
    }

    public void clearTimingCodes() {
        ((List)this.getObjectValue("TimedEventList")).clear();
    }

    private void resolveRelativeTimestamps() {
        List codes = (List)this.getObjectValue("TimedEventList");
        long lastTimestamp = 0L;
        for (EventTimingCode code : codes) {
            long translatedTimestamp = code.getTimestamp() == 0L ? lastTimestamp : code.getTimestamp();
            code.setTimestamp(translatedTimestamp);
            lastTimestamp = translatedTimestamp;
        }
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        super.read(byteBuffer);
        List codes = (List)this.getObjectValue("TimedEventList");
        long lastTimestamp = 0L;
        for (EventTimingCode code : codes) {
            long translatedTimestamp;
            long l = translatedTimestamp = code.getTimestamp() == 0L ? lastTimestamp : code.getTimestamp();
            if (code.getTimestamp() < lastTimestamp) {
                // empty if block
            }
            lastTimestamp = translatedTimestamp;
        }
    }

    @Override
    public String getIdentifier() {
        return "ETCO";
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TimeStampFormat", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new EventTimingCodeList(this));
    }

    private static Set<Integer> toSet(int ... types) {
        HashSet<Integer> typeSet = new HashSet<Integer>();
        for (int type : types) {
            typeSet.add(type);
        }
        return typeSet;
    }
}

