/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.utils.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.jaudiotagger.utils.tree.TreeNode;

public class TreePath<T>
implements Serializable {
    private static final long serialVersionUID = -5521484730448766444L;
    private TreePath<T> parentPath;
    private transient TreeNode<T> lastPathComponent;

    public TreePath(TreeNode<T>[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.lastPathComponent = path[path.length - 1];
        if (path.length > 1) {
            this.parentPath = new TreePath<T>(path, path.length - 1);
        }
    }

    public TreePath(TreeNode<T> singlePath) {
        if (singlePath == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.lastPathComponent = singlePath;
        this.parentPath = null;
    }

    protected TreePath(TreePath<T> parent, TreeNode<T> lastElement) {
        if (lastElement == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.parentPath = parent;
        this.lastPathComponent = lastElement;
    }

    protected TreePath(TreeNode<T>[] path, int length) {
        this.lastPathComponent = path[length - 1];
        if (length > 1) {
            this.parentPath = new TreePath<T>(path, length - 1);
        }
    }

    protected TreePath() {
    }

    public TreeNode<T>[] getPath() {
        int i = this.getPathCount();
        TreeNode[] result = new TreeNode[i--];
        TreePath<T> path = this;
        while (path != null) {
            result[i--] = path.lastPathComponent;
            path = path.parentPath;
        }
        return result;
    }

    public TreeNode<T> getLastPathComponent() {
        return this.lastPathComponent;
    }

    public int getPathCount() {
        int result = 0;
        TreePath<T> path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public TreeNode<T> getPathComponent(int element) {
        int pathLength = this.getPathCount();
        if (element < 0 || element >= pathLength) {
            throw new IllegalArgumentException("Index " + element + " is out of the specified range");
        }
        TreePath<T> path = this;
        for (int i = pathLength - 1; i != element; --i) {
            path = path.parentPath;
        }
        return path.lastPathComponent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TreePath) {
            TreePath<T> oTreePath = (TreePath<T>)o;
            if (this.getPathCount() != oTreePath.getPathCount()) {
                return false;
            }
            TreePath<T> path = this;
            while (path != null) {
                if (!path.lastPathComponent.equals(oTreePath.lastPathComponent)) {
                    return false;
                }
                oTreePath = oTreePath.parentPath;
                path = path.parentPath;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.lastPathComponent.hashCode();
    }

    public boolean isDescendant(TreePath<T> aTreePath) {
        if (aTreePath == this) {
            return true;
        }
        if (aTreePath != null) {
            int pathLength = this.getPathCount();
            int oPathLength = aTreePath.getPathCount();
            if (oPathLength < pathLength) {
                return false;
            }
            while (oPathLength-- > pathLength) {
                aTreePath = aTreePath.getParentPath();
            }
            return this.equals(aTreePath);
        }
        return false;
    }

    public TreePath<T> pathByAddingChild(TreeNode<T> child) {
        if (child == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath<T>(this, child);
    }

    public TreePath<T> getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuffer tempSpot = new StringBuffer("[");
        int maxCounter = this.getPathCount();
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (counter > 0) {
                tempSpot.append(", ");
            }
            tempSpot.append(this.getPathComponent(counter));
        }
        tempSpot.append("]");
        return tempSpot.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Vector<Object> values2 = new Vector<Object>();
        if (this.lastPathComponent != null && this.lastPathComponent instanceof Serializable) {
            values2.addElement("lastPathComponent");
            values2.addElement(this.lastPathComponent);
        }
        s.writeObject(values2);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values2 = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values2.size();
        if (indexCounter < maxCounter && values2.elementAt(indexCounter).equals("lastPathComponent")) {
            this.lastPathComponent = (TreeNode)values2.elementAt(++indexCounter);
            ++indexCounter;
        }
    }
}

