/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.queue.AbstractQueue;
import ru.kelcuprum.waterplayer.backend.queue.PlaylistQueue;
import ru.kelcuprum.waterplayer.backend.queue.Queue;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;

public class TrackScheduler
extends AudioEventAdapter {
    public boolean skiping = false;
    final AudioPlayer player;
    public AbstractQueue queue = new Queue();
    public AudioTrack lastTrack;
    public static long trackPosition = 0L;
    public static double trackSpeed = 0.0;
    public int repeatStatus = WaterPlayer.config.getNumber("REPEAT_STATUS", (Number)0).intValue();

    public TrackScheduler(AudioPlayer player) {
        this.player = player;
    }

    public void reset() {
        this.changeQueue(new Queue());
    }

    public void changeQueue(AbstractQueue queue) {
        if (queue == null) {
            queue = new Queue();
        }
        if (this.player.getPlayingTrack() != null) {
            this.player.stopTrack();
        }
        this.queue = queue;
        this.player.startTrack(this.queue.getCurrentTrack(), false);
    }

    public void playlistQueueToDefault() {
        if (this.queue instanceof PlaylistQueue) {
            Queue queue1 = new Queue();
            queue1.tracks = this.queue.tracks;
            queue1.position = this.queue.position;
            queue1.currentTrack = this.queue.currentTrack;
            this.queue = queue1;
        }
    }

    public void backTrack() {
        this.queue.backTrack();
        this.player.startTrack(this.queue.getCurrentTrack(), false);
        if (this.player.getPlayingTrack() != null) {
            WaterPlayer.log("----------");
            WaterPlayer.log("Starting Track: " + (String)(MusicHelper.isAuthorNull() ? "" : MusicHelper.getAuthor(this.player.getPlayingTrack()) + " - ") + MusicHelper.getTitle(this.player.getPlayingTrack()));
            WaterPlayer.log("Address: " + this.player.getPlayingTrack().getInfo().uri);
            if (WaterPlayer.config.getBoolean("ENABLE_NOTICE", false) && WaterPlayer.config.getBoolean("ENABLE_NOTICE.START_TRACK", false)) {
                ToastBuilder toast = WaterPlayer.getToast().setTitle((class_2561)(MusicHelper.isAuthorNull(this.player.getPlayingTrack()) ? class_2561.method_43471((String)"waterplayer.name") : class_2561.method_43470((String)MusicHelper.getAuthor(this.player.getPlayingTrack())))).setMessage((class_2561)class_2561.method_43470((String)MusicHelper.getTitle(this.player.getPlayingTrack())));
                if (MusicHelper.getAuthor(this.player.getPlayingTrack()).equals("YonKaGor")) {
                    toast.setIcon(this.getYonKaGorMoment(this.player.getPlayingTrack()));
                } else {
                    toast.setIcon(WaterPlayer.Icons.MUSIC);
                }
                toast.buildAndShow();
            }
        } else {
            this.reset();
        }
    }

    public void addTrack(AudioTrack track) {
        this.playlistQueueToDefault();
        this.queue.addTrack(track);
    }

    public void nextTrack() {
        WaterPlayer.discordIntegration.send(null);
        this.queue.nextTrack();
        this.player.startTrack(this.queue.getCurrentTrack(), false);
        if (this.player.getPlayingTrack() != null) {
            WaterPlayer.log("----------");
            WaterPlayer.log("Starting Track: " + (String)(MusicHelper.isAuthorNull() ? "" : MusicHelper.getAuthor(this.player.getPlayingTrack()) + " - ") + MusicHelper.getTitle(this.player.getPlayingTrack()));
            WaterPlayer.log("Address: " + this.player.getPlayingTrack().getInfo().uri);
            if (WaterPlayer.config.getBoolean("ENABLE_NOTICE", false) && WaterPlayer.config.getBoolean("ENABLE_NOTICE.START_TRACK", false)) {
                ToastBuilder toast = WaterPlayer.getToast().setTitle((class_2561)(MusicHelper.isAuthorNull(this.player.getPlayingTrack()) ? class_2561.method_43471((String)"waterplayer.name") : class_2561.method_43470((String)MusicHelper.getAuthor(this.player.getPlayingTrack())))).setMessage((class_2561)class_2561.method_43470((String)MusicHelper.getTitle(this.player.getPlayingTrack())));
                if (MusicHelper.getAuthor(this.player.getPlayingTrack()).equals("YonKaGor")) {
                    toast.setIcon(this.getYonKaGorMoment(this.player.getPlayingTrack()));
                } else {
                    toast.setIcon(WaterPlayer.Icons.MUSIC);
                }
                toast.buildAndShow();
            }
        } else {
            this.reset();
        }
    }

    @Override
    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        this.lastTrack = track;
        if (endReason.mayStartNext) {
            if (this.getRepeatStatus() == 2) {
                player.startTrack(this.lastTrack.makeClone(), false);
            } else {
                this.nextTrack();
            }
        }
    }

    @Override
    public void onTrackStart(AudioPlayer player, AudioTrack track) {
        trackPosition = track.getPosition();
        trackSpeed = WaterPlayer.player.speed;
    }

    public int getRepeatStatus() {
        return this.repeatStatus;
    }

    public class_2960 getRepeatIcon() {
        return this.getRepeatStatus() == 0 ? WaterPlayer.Icons.REPEAT_NON : (this.getRepeatStatus() == 1 ? WaterPlayer.Icons.REPEAT : WaterPlayer.Icons.REPEAT_ONE);
    }

    public int changeRepeatStatus() {
        int changedRepeatStatus = this.repeatStatus + 1;
        if (changedRepeatStatus > 2) {
            changedRepeatStatus = 0;
        }
        this.setRepeatStatus(changedRepeatStatus);
        return this.repeatStatus;
    }

    public void setRepeatStatus(int i) {
        i = i > 2 ? 0 : (i < 0 ? 2 : i);
        WaterPlayer.config.setNumber("REPEAT_STATUS", (Number)i);
        this.repeatStatus = i;
    }

    public void shuffle() {
        this.queue.shuffle();
    }

    protected class_1792 getYonKaGorMoment(AudioTrack track) {
        if (!MusicHelper.getAuthor(track).equals("YonKaGor")) {
            return class_1802.field_8065;
        }
        return switch (MusicHelper.getTitle(track)) {
            case "I Forgot That You Exist", "I Forgot That You Exist. \u00af\\_(\u30c4)_/\u00af" -> class_1802.field_8806;
            case "Top 10 Things to Do Before You Die", "Top 10 Things To Do Before You Die", "[TW] Top 10 Things To Do Before You Die (Censored)" -> class_1802.field_30904;
            case "Trash Talkin'", "kennyoung & YonKaGor - Trash Talkin'" -> class_1802.field_35358;
            case "Fallacy" -> class_1802.field_23984;
            case "You're Just Like Pop Music" -> class_1802.field_8344;
            case "Dandelion", "Dandelion \ud83c\udf3c (Full Song)" -> class_1802.field_8491;
            case "Mr. Sunfish", "Good Morning, Mr. Sunfish!", "Fish ! (Original)" -> class_1802.field_8846;
            case "You'll Be Gone" -> class_1802.field_8534;
            case "It's Normal", "It's Normal [TW]" -> class_1802.field_8731;
            case "Circus Hop", "Circus Hop [TW]" -> class_1802.field_8623;
            case "Paper Alibis", "Paper Alibis (Full Song)" -> class_1802.field_8407;
            case "Silly Plans" -> class_1802.field_8286;
            case "Silly Plans ~ Revisit" -> class_1802.field_8204;
            case "Another Mistake" -> class_1802.field_8077;
            case "Memory Merge" -> class_1802.field_8884;
            case "Waterland", "Waterland (Lyric video)" -> class_1802.field_8705;
            case "Artificial Abandonment", "(Original Song) Artificial Abandonment" -> class_1802.field_20392;
            default -> class_1802.field_8065;
        };
    }
}

