/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2561;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Async;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.WebAPI;
import ru.kelcuprum.alinlib.config.Config;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.alinlib.info.Player;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.exception.AuthException;
import ru.kelcuprum.waterplayer.backend.exception.WebPlaylistException;
import ru.kelcuprum.waterplayer.backend.playlist.Playlist;
import ru.kelcuprum.waterplayer.backend.playlist.WebPlaylist;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;

public class WaterPlayerAPI {
    public static Config config = new Config(new JsonObject());
    public static HashMap<String, JsonObject> urlsArtworks = new HashMap();

    public static String getURL() {
        return WaterPlayerAPI.getURL("/");
    }

    public static String getURL(String route) {
        String url;
        url = url + ((url = WaterPlayer.config.getString("API.URL", "https://api.waterplayer.ru") + route).contains("?") ? "&" : "?") + "version=2.1";
        return url;
    }

    @Async.Execute
    public static boolean serverEnable() {
        try {
            JsonObject object = WebAPI.getJsonObject((String)WaterPlayerAPI.getURL("/ping"));
            if (object.has("error")) {
                throw new AuthException(object.get("error").getAsJsonObject().get("message").getAsString());
            }
            return true;
        }
        catch (Exception e) {
            WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            return false;
        }
    }

    public static boolean isPlaylistUploadEnable() {
        return WaterPlayerAPI.serverEnable() && WaterPlayerAPI.isVerified();
    }

    @Async.Execute
    public static boolean isVerified() {
        if (!config.getBoolean("ENABLE_VERIFY", true)) {
            return true;
        }
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(WaterPlayerAPI.getURL("/verify"))).header("Authorization", "Bearer " + AlinLib.MINECRAFT.method_1548().method_1674());
            JsonObject json2 = WebAPI.getJsonObject((HttpRequest.Builder)builder);
            if (json2.has("error")) {
                if (json2.getAsJsonObject("error").get("code").getAsNumber().intValue() != 401) {
                    String msg = json2.getAsJsonObject("error").has("message") ? json2.getAsJsonObject("error").get("message").getAsString() : json2.getAsJsonObject("error").get("codename").getAsString();
                    WaterPlayer.getToast().setTitle((class_2561)class_2561.method_43470((String)"WaterPlayer API")).setMessage((class_2561)class_2561.method_43470((String)msg)).setType(ToastBuilder.Type.ERROR).setIcon(Icons.DONT).buildAndShow();
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            return false;
        }
    }

    @Async.Execute
    public static void loadConfig() {
        try {
            JsonObject object = WebAPI.getJsonObject((String)WaterPlayerAPI.getURL("/public_config"));
            if (object.has("error")) {
                throw new AuthException(object.get("error").getAsJsonObject().get("message").getAsString());
            }
            config = new Config(object);
        }
        catch (Exception e) {
            WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            if (e instanceof AuthException) {
                WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43470((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()))).setType(ToastBuilder.Type.ERROR).setIcon(Icons.DONT).buildAndShow();
            }
            WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43470((String)"Failed connect to API")).setType(ToastBuilder.Type.ERROR).setIcon(Icons.DONT).buildAndShow();
        }
    }

    public static boolean isModerator() {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(WaterPlayerAPI.getURL("/user"))).header("Authorization", "Bearer " + AlinLib.MINECRAFT.method_1548().method_1674());
            JsonObject json2 = WebAPI.getJsonObject((HttpRequest.Builder)builder);
            if (json2.has("error")) {
                if (json2.getAsJsonObject("error").get("code").getAsNumber().intValue() != 401) {
                    String msg = json2.getAsJsonObject("error").has("message") ? json2.getAsJsonObject("error").get("message").getAsString() : json2.getAsJsonObject("error").get("codename").getAsString();
                    WaterPlayer.log(msg, Level.ERROR);
                }
                return false;
            }
            return json2.has("moderator") && json2.get("moderator").getAsBoolean();
        }
        catch (Exception e) {
            WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            return false;
        }
    }

    public static boolean deletePlaylist(String id) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(WaterPlayerAPI.getURL(String.format("/playlist/%s", id)))).DELETE().header("Authorization", "Bearer " + AlinLib.MINECRAFT.method_1548().method_1674());
            JsonObject json2 = WebAPI.getJsonObject((HttpRequest.Builder)builder);
            if (json2.has("error")) {
                if (json2.getAsJsonObject("error").get("code").getAsNumber().intValue() != 401) {
                    String msg = json2.getAsJsonObject("error").has("message") ? json2.getAsJsonObject("error").get("message").getAsString() : json2.getAsJsonObject("error").get("codename").getAsString();
                    WaterPlayer.log(msg, Level.ERROR);
                }
                return false;
            }
            return json2.has("status") && json2.get("status").getAsBoolean();
        }
        catch (Exception e) {
            WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            return false;
        }
    }

    public static Playlist getPlaylist(String url, boolean save) throws WebPlaylistException, IOException, InterruptedException {
        try {
            JsonObject data = WebAPI.getJsonObject((String)url);
            if (data.has("error")) {
                throw new WebPlaylistException(data.getAsJsonObject("error").get("message").getAsString());
            }
            WebPlaylist playlist = new WebPlaylist(data);
            if (save) {
                playlist.save();
            }
            return playlist.playlist;
        }
        catch (Exception e) {
            WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            if (e instanceof WebPlaylistException) {
                throw new WebPlaylistException("External error: " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
            throw e;
        }
    }

    @Async.Execute
    public static String uploadPlaylist(Playlist playlist, String id) throws AuthException, WebPlaylistException {
        if (!WaterPlayerAPI.isVerified()) {
            throw new AuthException("Your account is not authorized!");
        }
        if (WaterPlayerAPI.isCorrectPlaylistForPublish(playlist) != null) {
            throw new WebPlaylistException(WaterPlayerAPI.isCorrectPlaylistForPublish(playlist));
        }
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(WaterPlayerAPI.getURL("/upload")));
            if (config.getBoolean("ENABLE_VERIFY", true)) {
                builder.header("Authorization", "Bearer " + AlinLib.MINECRAFT.method_1548().method_1674());
            }
            JsonObject request = new JsonObject();
            request.addProperty("id", id);
            request.add("data", playlist.toJSON());
            builder.POST(HttpRequest.BodyPublishers.ofString(request.toString()));
            JsonObject data = WebAPI.getJsonObject((HttpRequest.Builder)builder);
            if (data.has("error")) {
                throw new WebPlaylistException(data.getAsJsonObject("error").get("message").getAsString());
            }
            return data.has("url") ? String.format(config.getString("PLAYLIST_URL", WaterPlayerAPI.getURL("/playlist/%s")), data.get("url").getAsString()) : "";
        }
        catch (Exception e) {
            if (e instanceof WebPlaylistException) {
                throw new WebPlaylistException(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            }
            throw new RuntimeException(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
        }
    }

    public static String isCorrectPlaylistForPublish(Playlist playlist) {
        String state = null;
        if (!playlist.author.equalsIgnoreCase(Player.getName())) {
            state = class_2561.method_43471((String)"waterplayer.playlist.error.author").getString();
        }
        if (playlist.isPublic.booleanValue()) {
            if (playlist.urls.size() < config.getNumber("PUBLIC.MIN_URLS", (Number)3).intValue()) {
                state = class_2561.method_43469((String)"waterplayer.playlist.error.size", (Object[])new Object[]{config.getNumber("PUBLIC.MIN_URLS", (Number)3).intValue()}).getString();
            } else if (playlist.icon != null && playlist.icon.isEmpty()) {
                state = class_2561.method_43471((String)"waterplayer.playlist.error.icon").getString();
            }
        }
        return state;
    }

    public static List<WebPlaylist> searchPlaylists(String query) {
        ArrayList<WebPlaylist> results = new ArrayList<WebPlaylist>();
        if (!config.getBoolean("SEARCH", true)) {
            return results;
        }
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(WaterPlayerAPI.getURL(String.format("/search?query=%s", query)))).header("Authorization", "Bearer " + AlinLib.MINECRAFT.method_1548().method_1674());
            JsonObject data = WebAPI.getJsonObject((HttpRequest.Builder)builder);
            if (data.has("error")) {
                throw new WebPlaylistException(data.getAsJsonObject("error").get("message").getAsString());
            }
            if (data.has("results") && data.get("results").isJsonArray()) {
                for (JsonElement j : data.getAsJsonArray("results")) {
                    try {
                        WebPlaylist wp = new WebPlaylist(j.getAsJsonObject());
                        results.add(wp);
                    }
                    catch (Exception e) {
                        WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
                    }
                }
            }
            return results;
        }
        catch (Exception e) {
            WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            return results;
        }
    }

    public static JsonObject getTrackInfo(AudioTrack track, boolean onlyAuthor) {
        String author = MusicHelper.getAuthor(track);
        if (author.split(",").length > 1) {
            author = author.split(",")[0];
        } else if (author.split(";").length > 1) {
            author = author.split(";")[0];
        } else if (author.split("/").length > 1) {
            author = author.split("/")[0];
        }
        try {
            String aUrl;
            JsonObject authorInfo;
            String url = WaterPlayerAPI.getURL(onlyAuthor ? String.format("/info?author=%1$s", WaterPlayerAPI.uriEncode(author)) : String.format("/info?author=%1$s&album=%2$s", WaterPlayerAPI.uriEncode(author), WaterPlayerAPI.uriEncode(MusicHelper.getTitle(track))));
            if (urlsArtworks.containsKey(url)) {
                authorInfo = urlsArtworks.get(url);
            } else {
                authorInfo = WebAPI.getJsonObject((String)url);
                urlsArtworks.put(url, authorInfo);
            }
            if (!onlyAuthor && !urlsArtworks.containsKey(aUrl = String.format("/info?author=%1$s", WaterPlayerAPI.uriEncode(author)))) {
                JsonObject authorObject = new JsonObject();
                authorObject.add("author", authorInfo.get("author"));
                urlsArtworks.put(aUrl, authorObject);
            }
            return authorInfo;
        }
        catch (Exception ex) {
            WaterPlayer.log(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage(), Level.DEBUG);
            JsonObject rep = new JsonObject();
            JsonObject error = new JsonObject();
            error.addProperty("code", 500);
            error.addProperty("codename", "Internal Server Error");
            error.addProperty("message", ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage());
            rep.add("error", error);
            return rep;
        }
    }

    public static String getAuthorAvatar(AudioTrack track) {
        String author = MusicHelper.getAuthor(track);
        try {
            JsonObject authorInfo = WaterPlayerAPI.getTrackInfo(track, true);
            if (authorInfo.has("error")) {
                throw new RuntimeException(authorInfo.getAsJsonObject("error").get("message").getAsString());
            }
            if (authorInfo.getAsJsonObject("author").has("artwork")) {
                return authorInfo.getAsJsonObject("author").get("artwork").getAsString();
            }
            return "";
        }
        catch (Exception ex) {
            WaterPlayer.log(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage(), Level.DEBUG);
            return "";
        }
    }

    public static String getArtwork(AudioTrack track) {
        try {
            JsonObject authorInfo = WaterPlayerAPI.getTrackInfo(track, false);
            if (authorInfo.has("error")) {
                throw new RuntimeException(authorInfo.getAsJsonObject("error").get("message").getAsString());
            }
            if (authorInfo.getAsJsonObject("track").has("artwork")) {
                return authorInfo.getAsJsonObject("track").get("artwork").getAsString();
            }
            return "";
        }
        catch (Exception ex) {
            WaterPlayer.log(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage(), Level.DEBUG);
            return "";
        }
    }

    protected static String uriEncode(String uri) {
        return URLEncoder.encode(uri, StandardCharsets.UTF_8);
    }
}

